/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.policyset.WSPolicyAttachments;
import com.ibm.ws.wspolicy.policyset.WSPolicyFactoryPlugin;
import com.ibm.ws.wspolicy.policyset.WSPolicyProcessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class DefaultWSPolicyFactory
implements WSPolicyFactoryPlugin {
    private static final String WSPOLICYPROCESSOR_CLASSNAME = "com.ibm.ws.wspolicy.policyset.WSPolicyProcessorImpl";
    private static final String WSPOLICYATTACHMENTSIMPL_CLASSNAME = "com.ibm.ws.wspolicy.policyset.WSPolicyAttachmentsImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(DefaultWSPolicyFactory.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public WSPolicyProcessor createPolicyProcessor(String applicationPath, String serviceName, String moduleName) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicyProcessor", new Object[]{applicationPath});
        }
        WSPolicyProcessor result = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> c = loader.loadClass(WSPOLICYPROCESSOR_CLASSNAME);
            Constructor<?> constructor = c.getConstructor(String.class, String.class, String.class);
            result = (WSPolicyProcessor)constructor.newInstance(applicationPath, serviceName, moduleName);
        }
        catch (InstantiationException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (IllegalAccessException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (ClassNotFoundException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (IllegalArgumentException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (InvocationTargetException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (SecurityException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        catch (NoSuchMethodException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYPROCESSOR_CLASSNAME, e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicyProcessor");
        }
        return result;
    }

    public WSPolicyAttachments createWSPolicyAttachments(WSPolicyProcessor wsp2, PolicySetAttachments psa, String applicationPath, String serviceName, String moduleName) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createWSPolicyAttachments", new Object[]{wsp2, psa, applicationPath, serviceName, moduleName});
        }
        WSPolicyAttachments result = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> c = loader.loadClass(WSPOLICYATTACHMENTSIMPL_CLASSNAME);
            Constructor<?> constructor = c.getConstructor(WSPolicyProcessor.class, PolicySetAttachments.class, String.class, String.class, String.class);
            result = (WSPolicyAttachments)constructor.newInstance(wsp2, psa, applicationPath, serviceName, moduleName);
        }
        catch (InstantiationException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (IllegalAccessException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (ClassNotFoundException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (IllegalArgumentException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (InvocationTargetException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (SecurityException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        catch (NoSuchMethodException e) {
            DefaultWSPolicyFactory.traceAndFFDCException(WSPOLICYATTACHMENTSIMPL_CLASSNAME, e);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createWSPolicyAttachments");
        }
        return result;
    }

    private static void traceAndFFDCException(String className, Exception e) throws WSPolicyInternalException {
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSPolicyFactory caught Exception", e);
        }
        FFDCFilter.processException(e, className, "146");
        throw new WSPolicyInternalException(e);
    }

    public int version() {
        return 0;
    }
}

