/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.lightweight;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.BothAssertion;
import com.ibm.ws.wspolicy.domain.Parameter;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import com.ibm.ws.wspolicy.utils.CoreExceptionMapper;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyExternalizerImpl
implements WSPolicyExternalizer.WSPolicyExternalizerInterface {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyExternalizerImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    final WSPolicyFactory _wspf = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry().getWSPolicyFactory();
    final DataModelFactory _dmf = this._wspf.createDataModelFactory();

    @Override
    public Assertion createAssertion(QName name, Map<QName, String> attrs, List<Parameter> parameters, boolean isIgnorable, WSPolicyExternalizer.Policy nestedPolicy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAssertion", new Object[]{name, attrs, parameters, isIgnorable, nestedPolicy, this});
        }
        Assertion assertion = null;
        if (nestedPolicy != null) {
            DefaultNestingAssertion dna = new DefaultNestingAssertion(name);
            Policy policy = this.createPolicy(nestedPolicy);
            dna.setPolicy(policy);
            assertion = dna;
        } else {
            assertion = new BothAssertion(this._dmf, name);
        }
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                assertion.setAttribute((QName)entry.getKey(), (String)entry.getValue());
            }
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                assertion.setParameter(parameter);
            }
        }
        assertion.setIgnorable(isIgnorable);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAssertion", assertion);
        }
        return assertion;
    }

    @Override
    public void writePolicy(WSPolicyExternalizer.Policy lwpolicy, OutputStream sink) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicy", new Object[]{lwpolicy, sink, this});
        }
        Policy policy = this.createPolicy(lwpolicy);
        try {
            ElementWriter<OutputStream> ew = this._wspf.getWriter(OutputStream.class);
            ew.write(policy, sink);
        }
        catch (ElementWriterException e) {
            throw new WSPolicyInternalException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicy");
        }
    }

    private Policy createPolicy(WSPolicyExternalizer.Policy lwpolicy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicy", new Object[]{lwpolicy, this});
        }
        ExactlyOne eo = this._wspf.createDataModelFactory().createExactlyOne();
        for (WSPolicyExternalizer.Alternative alternative : lwpolicy) {
            eo.getChildren().add(this.createAll(alternative, this._wspf));
        }
        PolicyProcessor bpp = this._wspf.createWSPolicyProcessor();
        Policy policy = this._wspf.createDataModelFactory().createPolicy();
        policy.getChildren().add(eo);
        try {
            policy = bpp.normalize(policy);
        }
        catch (com.ibm.wspolicy.PolicyReferenceException e) {
            CoreExceptionMapper.map(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicy", policy);
        }
        return policy;
    }

    private All createAll(WSPolicyExternalizer.Alternative alternative, WSPolicyFactory wspf) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAll", new Object[]{alternative, this});
        }
        All all = wspf.createDataModelFactory().createAll();
        List<PolicyElement> children = all.getChildren();
        for (Assertion a : alternative) {
            com.ibm.wspolicy.datamodel.Assertion da = null;
            if (a instanceof DefaultNestingAssertion) {
                DefaultNestingAssertion wspena = (DefaultNestingAssertion)a;
                da = wspena.getWrapped();
            } else if (a instanceof BothAssertion) {
                BothAssertion ba = (BothAssertion)a;
                da = ba.getWrapped();
            } else {
                throw new RuntimeException("TODO: component: unable to process instance of com.ibm.ws.wspolicy.domain.Assertion");
            }
            children.add(da);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAll", all);
        }
        return all;
    }

    @Override
    public WSPolicyExternalizer.Policy readPolicy(InputStream is) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicy", new Object[]{is, this});
        }
        PolicyImpl result = new PolicyImpl();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            Element e = doc.getDocumentElement();
            ElementReader<Element> er = this._wspf.getReader(Element.class);
            PolicyElement p = er.read(e);
            Policy policy = (Policy)p;
            WSPolicyExternalizer.Policy alternatives = this.convertFullPolicyToLightweightPolicy(policy);
            for (WSPolicyExternalizer.Alternative a : alternatives) {
                result.add(a);
            }
        }
        catch (IOException e) {
            throw new WSPolicyInternalException(e);
        }
        catch (ParserConfigurationException e) {
            throw new WSPolicyInternalException(e);
        }
        catch (SAXException e) {
            throw new WSPolicyInternalException(e);
        }
        catch (ElementReaderException e) {
            throw new WSPolicyInternalException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicy", result);
        }
        return result;
    }

    private WSPolicyExternalizer.Policy convertFullPolicyToLightweightPolicy(Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertFullPolicyToLightweightPolicy", new Object[]{policy, this});
        }
        PolicyImpl result = new PolicyImpl();
        PolicyProcessor bpp = this._wspf.createWSPolicyProcessor();
        try {
            Policy normalized = bpp.normalize(policy);
            PolicyProcessor ap = this._wspf.createWSPolicyProcessor();
            Iterable<PolicyProcessor.Alternative> alts = ap.getAlternatives(normalized);
            for (PolicyProcessor.Alternative a : alts) {
                AlternativeImpl alternative = new AlternativeImpl();
                List<com.ibm.wspolicy.datamodel.Assertion> asserts = a.getAssertions();
                for (com.ibm.wspolicy.datamodel.Assertion assertion : asserts) {
                    Assertion assrt = null;
                    assrt = assertion instanceof BothAssertion ? (Assertion)((Object)assertion) : new BothAssertion(this._dmf, assertion);
                    if (assertion.getNestedPolicy() != null) {
                        assrt = new DefaultNestingAssertion(assertion);
                    }
                    alternative.add(assrt);
                }
                result.add(alternative);
            }
        }
        catch (com.ibm.wspolicy.PolicyReferenceException pre) {
            CoreExceptionMapper.map(pre);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertFullPolicyToLightweightPolicy", result);
        }
        return result;
    }

    @Override
    public WSPolicyExternalizer.Alternative createAlternative(Assertion ... assertions) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAlternative", new Object[]{assertions, this});
        }
        AlternativeImpl alternative = new AlternativeImpl();
        for (Assertion a : assertions) {
            alternative.add(a);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAlternative", alternative);
        }
        return alternative;
    }

    @Override
    public WSPolicyExternalizer.Policy createPolicy(WSPolicyExternalizer.Alternative ... alternatives) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicy", new Object[]{alternatives, this});
        }
        PolicyImpl policy = new PolicyImpl();
        for (WSPolicyExternalizer.Alternative a : alternatives) {
            policy.add(a);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicy", policy);
        }
        return policy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlternativeImpl
    extends ArrayList<Assertion>
    implements WSPolicyExternalizer.Alternative {
        private static final long serialVersionUID = 7276873084273322965L;

        private AlternativeImpl() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolicyImpl
    extends ArrayList<WSPolicyExternalizer.Alternative>
    implements WSPolicyExternalizer.Policy {
        private static final long serialVersionUID = -3664186222970771034L;

        private PolicyImpl() {
        }
    }

    private class DefaultNestingAssertion
    implements WSPolicyExternalizer.NestingAssertion {
        BothAssertion bothAssert = null;

        public DefaultNestingAssertion(QName qName) {
            this.bothAssert = new BothAssertion(WSPolicyExternalizerImpl.this._dmf, qName);
        }

        public DefaultNestingAssertion(com.ibm.wspolicy.datamodel.Assertion a) {
            this.bothAssert = a instanceof BothAssertion ? (BothAssertion)a : new BothAssertion(WSPolicyExternalizerImpl.this._dmf, a);
        }

        public WSPolicyExternalizer.Policy getNestedPolicy() throws PolicyReferenceException, WSPolicyInternalException {
            return WSPolicyExternalizerImpl.this.convertFullPolicyToLightweightPolicy(this.bothAssert.getNestedPolicy());
        }

        public Iterator getAllParameterNames() {
            return this.bothAssert.getAllParameterNames();
        }

        public QName getAssertionName() {
            return this.bothAssert.getName();
        }

        public Iterator getParameters(QName parameterName) {
            return this.bothAssert.getParameters(parameterName);
        }

        public boolean isIgnorable() {
            return this.bothAssert.isIgnorable();
        }

        public void setIgnorable(boolean flag) {
            this.bothAssert.setIgnorable(flag);
        }

        public void setParameter(Parameter parameter) {
            this.bothAssert.setParameter(parameter);
        }

        public Iterator getAttributeNames() {
            return this.bothAssert.getAttributeParameters().keySet().iterator();
        }

        public String getAttributeValue(QName attributeName) {
            return this.bothAssert.getAttributeParameters().get(attributeName);
        }

        public void setAttribute(QName attributeName, String value) {
            this.bothAssert.getAttributeParameters().put(attributeName, value);
        }

        public void setPolicy(Policy p) {
            this.bothAssert.setNestedPolicy(p);
        }

        public com.ibm.wspolicy.datamodel.Assertion getWrapped() {
            return this.bothAssert.getWrapped();
        }
    }
}

