/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.lightweight;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.Parameter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyExternalizer {
    private static WSPolicyExternalizerInterface _wsPolicyExternalizer = null;
    private static final String WSPOLICYEXTERNALIZER_CLASSNAME = "com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizerImpl";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSPolicyExternalizer.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");

    public static Assertion createAssertion(QName name, Map<QName, String> attrs, List<Parameter> parameters, boolean isIgnorable, Policy nestedPolicy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAssertion", new Object[]{name, attrs, parameters, isIgnorable, nestedPolicy});
        }
        Assertion result = _wsPolicyExternalizer.createAssertion(name, attrs, parameters, isIgnorable, nestedPolicy);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAssertion", result);
        }
        return result;
    }

    public static Alternative createAlternative(Assertion ... assertions) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createAlternative", assertions);
        }
        Alternative result = _wsPolicyExternalizer.createAlternative(assertions);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createAlternative", result);
        }
        return result;
    }

    public static Policy createPolicy(Alternative ... alternatives) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createPolicy", alternatives);
        }
        Policy result = _wsPolicyExternalizer.createPolicy(alternatives);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createPolicy", result);
        }
        return result;
    }

    public static void writePolicy(Policy lwpolicy, OutputStream sink) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "writePolicy", new Object[]{lwpolicy, sink});
        }
        _wsPolicyExternalizer.writePolicy(lwpolicy, sink);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "writePolicy");
        }
    }

    public static Policy readPolicy(InputStream is) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "readPolicy", is);
        }
        Policy result = _wsPolicyExternalizer.readPolicy(is);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "readPolicy", result);
        }
        return result;
    }

    static {
        try {
            Class<?> clazz = Class.forName(WSPOLICYEXTERNALIZER_CLASSNAME);
            _wsPolicyExternalizer = (WSPolicyExternalizerInterface)clazz.newInstance();
        }
        catch (Exception e) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSPolicyExternalizer caught Exception", e);
            }
            FFDCFilter.processException(e, WSPolicyExternalizer.class.toString(), "1:107:1.4");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WSPolicyExternalizerInterface {
        public Assertion createAssertion(QName var1, Map<QName, String> var2, List<Parameter> var3, boolean var4, Policy var5) throws PolicyReferenceException, WSPolicyInternalException;

        public Alternative createAlternative(Assertion ... var1);

        public Policy createPolicy(Alternative ... var1);

        public void writePolicy(Policy var1, OutputStream var2) throws PolicyReferenceException, WSPolicyInternalException;

        public Policy readPolicy(InputStream var1) throws PolicyReferenceException, UnsupportedNamespaceException, UnsupportedPolicyElementException, WSPolicyInternalException;
    }

    public static interface NestingAssertion
    extends Assertion {
        public Policy getNestedPolicy() throws PolicyReferenceException, WSPolicyInternalException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Alternative
    extends Iterable<Assertion> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Policy
    extends Iterable<Alternative> {
    }
}

