/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.domain;

import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.BothAssertion;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import com.ibm.wspolicy.domain.AssertionProcessor;
import com.ibm.wspolicy.factory.DataModelFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAssertionProcessor
implements AssertionProcessor {
    WSPolicyAssertionProcessor _internalWSPAP = null;
    DataModelFactory _dmf = null;
    Map<QName, AssertionProcessor.AssertionInformation> infoMap = new HashMap<QName, AssertionProcessor.AssertionInformation>();

    public WASAssertionProcessor(DataModelFactory dmf, WSPolicyAssertionProcessor wrapped) {
        this._internalWSPAP = wrapped;
        this._dmf = dmf;
        WSPolicyPreferenceResolver p = wrapped.getWSPolicyPreferenceResolver();
        this.buildInfoMapFromSupportedSupportMerge(this.infoMap, this._internalWSPAP.getSupportedWSPolicyAssertions(), this._internalWSPAP.getWSPolicyAssertionsWithSupportBehaviour(), this._internalWSPAP.getWSPolicyAssertionsWithCombineBehaviour(), p);
    }

    @Override
    public com.ibm.wspolicy.datamodel.Assertion combine(com.ibm.wspolicy.datamodel.Assertion assertion1, com.ibm.wspolicy.datamodel.Assertion assertion2) {
        Assertion assarg1 = null;
        Assertion assarg2 = null;
        assarg2 = assertion2 instanceof Assertion ? (Assertion)((Object)assertion2) : new BothAssertion(this._dmf, assertion2);
        Assertion oldAss = this._internalWSPAP.combine(assarg2, assarg1 = assertion1 instanceof Assertion ? (Assertion)((Object)assertion1) : new BothAssertion(this._dmf, assertion1));
        if (oldAss == null) {
            return null;
        }
        if (oldAss instanceof com.ibm.wspolicy.datamodel.Assertion) {
            return (com.ibm.wspolicy.datamodel.Assertion)((Object)oldAss);
        }
        throw new RuntimeException("We only support domains which hand us back a BothAssertion");
    }

    public List<QName> getAssertionsWithConditionalClientCapability() {
        return this._internalWSPAP.getAssertionsWithConditionalClientCapability();
    }

    public List<QName> getProviderVocabularyRequired() {
        return this._internalWSPAP.getProviderVocabularyRequired();
    }

    public List<QName> getSupportedAssertions() {
        return this._internalWSPAP.getSupportedWSPolicyAssertions();
    }

    @Override
    public String getType() {
        return this._internalWSPAP.getType();
    }

    public List<QName> getAssertionsWithCombineBehaviour() {
        return this._internalWSPAP.getWSPolicyAssertionsWithCombineBehaviour();
    }

    public List<QName> getAssertionsWithSupportBehaviour() {
        return this._internalWSPAP.getWSPolicyAssertionsWithSupportBehaviour();
    }

    @Override
    public boolean supports(com.ibm.wspolicy.datamodel.Assertion assertion) {
        Assertion assarg1 = null;
        assarg1 = assertion instanceof Assertion ? (Assertion)((Object)assertion) : new BothAssertion(this._dmf, assertion);
        boolean flag = false;
        try {
            flag = this._internalWSPAP.supports(assarg1, null);
        }
        catch (WSPolicyBindingsException e) {
            throw new RuntimeException("Utoh!");
        }
        return flag;
    }

    public String toString() {
        return "DAHR-Adapter " + this.hashCode() + " wrapping " + this._internalWSPAP.toString();
    }

    @Override
    public Map<QName, AssertionProcessor.AssertionInformation> getAssertionInformationMap() {
        return this.infoMap;
    }

    private void buildInfoMapFromSupportedSupportMerge(Map<QName, AssertionProcessor.AssertionInformation> m, List<QName> supported, List<QName> support, List<QName> merge, WSPolicyPreferenceResolver p) {
        for (QName qn : supported) {
            WSPolicyPreferenceResolver.WSPolicyPreferenceInformationForQName p4q;
            AssertionProcessor.AssertionInformation ai = new AssertionProcessor.AssertionInformation();
            ai.hasCustomCombineBehavior = false;
            ai.hasCustomSupportsBehavior = false;
            if (support != null && support.contains(qn)) {
                ai.hasCustomSupportsBehavior = true;
            }
            if (merge != null && merge.contains(qn)) {
                ai.hasCustomCombineBehavior = true;
            }
            if (p != null && (p4q = p.getWSPolicyPreferenceInformationForQName(qn)) != null) {
                ai.preferenceScore = p4q.getScore();
                ai.preferencePreferAbsent = p4q.getPreferredAbsent();
                ai.preferencePreferWithNested = p4q.getPreferredWithNested();
            }
            m.put(qn, ai);
        }
    }
}

