/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.domain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.misc.BASE64Encoder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WASAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionHandler;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionTransformer;
import com.ibm.ws.wssecurity.util.DigestUtil;
import com.ibm.ws.wssecurity.util.DigestUtilFactory;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.domain.AssertionProcessor;
import com.ibm.wspolicy.factory.ConfigurationException;
import com.ibm.wspolicy.factory.DataModelFactory;
import com.ibm.wspolicy.factory.SimpleFactoryConfiguration;
import com.ibm.wspolicy.factory.WSDigestValidator;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.DataModelUtility;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.w3c.dom.Element;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyProviderRegistry
implements PolicyProviderRegistry {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(DefaultPolicyProviderRegistry.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static DefaultPolicyProviderRegistry _instance = null;
    private final WSPolicyFactory _wspf;
    private final DataModelUtility _dmu;
    private final Map<QName, WSPolicyAssertionProcessor> _assertionProcessorQNames = new ConcurrentHashMap<QName, WSPolicyAssertionProcessor>();
    private final Map<String, Set<QName>> _clientCapabilitiesByNamespace = new ConcurrentHashMap<String, Set<QName>>();
    private final List<QName> _behaviorMergeQNames = new CopyOnWriteArrayList<QName>();
    private final List<QName> _behaviorSupportQNames = new CopyOnWriteArrayList<QName>();
    private final List<QName> _providerVocabRequiredQNames = new CopyOnWriteArrayList<QName>();
    private final List<QName> _clientCapabilityIsConditional = new CopyOnWriteArrayList<QName>();
    private final Map<String, WSPolicyAssertionProcessor> _assertionProcessorsByType = new ConcurrentHashMap<String, WSPolicyAssertionProcessor>();
    private final Map<String, String> _namespace2PolicyType = new ConcurrentHashMap<String, String>();
    private List<QName> behaviorScopeServiceQNames = new ArrayList<QName>();
    private List<QName> behaviorScopeEndpointQNames = new ArrayList<QName>();
    private List<QName> behaviorScopeOperationQNames = new ArrayList<QName>();
    private List<QName> behaviorScopeMessageQNames = new ArrayList<QName>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final DefaultPolicyProviderRegistry getInstance() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getInstance");
        }
        Class<DefaultPolicyProviderRegistry> clazz = DefaultPolicyProviderRegistry.class;
        synchronized (DefaultPolicyProviderRegistry.class) {
            if (_instance == null) {
                _instance = new DefaultPolicyProviderRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getInstance");
            }
            return _instance;
        }
    }

    private void processDomainInformation(WSPolicyAssertionProcessor assertionProcessor) throws WSPolicyException {
        List<QName> clientCapabilityIsConditional;
        List<QName> vocabRequired;
        List<QName> merges;
        List<QName> supports;
        List<QName> qNames;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processDomainInformation", new Object[]{assertionProcessor});
        }
        if ((qNames = assertionProcessor.getSupportedWSPolicyAssertions()) != null) {
            this.anyDuplicateSupportedQNames(qNames);
            Iterator<QName> iter = qNames.iterator();
            QName qName = null;
            while (iter.hasNext()) {
                qName = iter.next();
                this._assertionProcessorQNames.put(qName, assertionProcessor);
                String nameSpace = qName.getNamespaceURI();
                if (this._namespace2PolicyType.get(nameSpace) != null) continue;
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "adding new namespace to domain mapping, ", new Object[]{nameSpace, assertionProcessor.getType()});
                }
                this._namespace2PolicyType.put(nameSpace, assertionProcessor.getType());
            }
            this._assertionProcessorsByType.put(assertionProcessor.getType(), assertionProcessor);
        }
        if ((supports = assertionProcessor.getWSPolicyAssertionsWithSupportBehaviour()) != null) {
            this._behaviorSupportQNames.addAll(supports);
        }
        if ((merges = assertionProcessor.getWSPolicyAssertionsWithCombineBehaviour()) != null) {
            this._behaviorMergeQNames.addAll(merges);
        }
        if ((vocabRequired = assertionProcessor.getProviderVocabularyRequired()) != null) {
            this._providerVocabRequiredQNames.addAll(vocabRequired);
        }
        if ((clientCapabilityIsConditional = assertionProcessor.getAssertionsWithConditionalClientCapability()) != null) {
            this._clientCapabilityIsConditional.addAll(clientCapabilityIsConditional);
            for (QName qName : clientCapabilityIsConditional) {
                Set<QName> assertionsForQName = this._clientCapabilitiesByNamespace.get(qName.getNamespaceURI());
                if (assertionsForQName == null) {
                    assertionsForQName = new CopyOnWriteArraySet<QName>();
                    this._clientCapabilitiesByNamespace.put(qName.getNamespaceURI(), assertionsForQName);
                }
                assertionsForQName.add(qName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processDomainInformation");
        }
    }

    private DefaultPolicyProviderRegistry() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "DefaultPolicyProviderRegistry CTOR");
        }
        WSPolicyFactory wspfNoConfig = WSPolicyFactory.newInstance();
        final DataModelFactory dmf = wspfNoConfig.createDataModelFactory();
        final HashMap<String, 1> validators = new HashMap<String, 1>();
        validators.put(PolicyConstants.DEFAULT_DIGEST_ALGORITHM, new WSDigestValidator(){
            BASE64Encoder _encoder = null;

            public boolean validate(String digest, Element policyNode) {
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.entry(TRACE_COMPONENT, "validate", new Object[]{digest, policyNode});
                }
                if (digest == null || policyNode == null) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getDigest", false);
                    }
                    return false;
                }
                if (this._encoder == null) {
                    this._encoder = new BASE64Encoder();
                }
                byte[] calcDigest = null;
                DigestUtil anUtil = null;
                anUtil = DigestUtilFactory.getInstance();
                try {
                    OMElement signedInfo = XMLUtils.toOM(policyNode);
                    calcDigest = anUtil.getDigest(signedInfo);
                }
                catch (Throwable e) {
                    FFDCFilter.processException(e, "com.ibm.ws.wspolicy.DefaultPolicyDigest.getDigest", "101", this);
                    if (TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "A problem occurred calculating the digest for a referenced policy");
                    }
                    throw new RuntimeException(e);
                }
                String encode = this._encoder.encodeBuffer(calcDigest).trim();
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getDigest", "digest[" + encode + "]");
                }
                return encode.equals(digest);
            }
        });
        SimpleFactoryConfiguration sfc = new SimpleFactoryConfiguration(new AssertionProcessor[0]){

            @Override
            public DataModelFactory getDataModelFactory() {
                return dmf;
            }

            @Override
            public Map<String, WSDigestValidator> getWSDigestValidators() {
                return validators;
            }
        };
        List<AssertionProcessor> domains = sfc.getAssertionProcessors();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyassertionprocessor");
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "Found " + elements.length + " extensions for " + "com.ibm.wspolicy.main.ibmwspolicy-qos-wspolicyassertionprocessor");
        }
        boolean found = elements.length > 0;
        ArrayList<WSPolicyAssertionProcessor> extensions = new ArrayList<WSPolicyAssertionProcessor>();
        if (found) {
            this.addExtensions(extensions, elements);
        } else {
            elements = registry.getConfigurationElementsFor("com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyassertionprocessor");
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Found " + elements.length + " extensions for " + "com.ibm.wsfp.thinclient.ibmwspolicy-qos-wspolicyassertionprocessor");
            }
            this.addExtensions(extensions, elements);
        }
        try {
            for (WSPolicyAssertionProcessor assertionProcessor : extensions) {
                this.processDomainInformation(assertionProcessor);
                domains.add(new WASAssertionProcessor(dmf, assertionProcessor));
            }
        }
        catch (WSPolicyException pe) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry CTOR caught Exception", pe);
            }
            FFDCFilter.processException((Throwable)pe, "com.ibm.ws.wspolicy.domain.DefaultPolicyProviderRegistry", "298", this);
        }
        Iterator daIter = Service.providers(WSPolicyAssertionProcessor.class);
        while (daIter != null && daIter.hasNext()) {
            try {
                WSPolicyAssertionProcessor assertionProcessor;
                assertionProcessor = (WSPolicyAssertionProcessor)daIter.next();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry", "UnitTestAssertionProcessor found " + assertionProcessor.getClass().getName());
                }
                this.processDomainInformation(assertionProcessor);
                domains.add(new WASAssertionProcessor(dmf, assertionProcessor));
            }
            catch (ServiceConfigurationError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.DefaultPolicyProviderRegistry.DefaultPolicyProviderRegistry", "160", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry", "PolicyDomain class could not be found " + e.toString());
            }
            catch (NoClassDefFoundError e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.DefaultPolicyProviderRegistry.DefaultPolicyProviderRegistry", "166", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry", "PolicyDomain class could not be found " + e.toString());
            }
            catch (WSPolicyException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.DefaultPolicyProviderRegistry.DefaultPolicyProviderRegistry", "224", this);
                if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry", "Duplicate Domain information found " + e.toString());
            }
        }
        try {
            this._wspf = WSPolicyFactory.newInstance(sfc);
            this._dmu = this._wspf.createDataModelUtility();
        }
        catch (ConfigurationException ce) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "DefaultPolicyProviderRegistry CTOR caught Exception", ce);
            }
            FFDCFilter.processException((Throwable)ce, "com.ibm.ws.wspolicy.domain.DefaultPolicyProviderRegistry", "347", this);
            throw new RuntimeException(ce);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "DefaultPolicyProviderRegistry CTOR");
        }
    }

    private boolean anyDuplicateSupportedQNames(List<QName> qNames) throws WSPolicyException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "anyDuplicateSupportedQNames", new Object[]{qNames});
        }
        boolean result = false;
        Iterator<QName> iter = qNames.iterator();
        QName qName = null;
        while (iter.hasNext()) {
            qName = iter.next();
            if (!this._assertionProcessorQNames.containsKey(qName)) continue;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Duplicate QName found in supported list " + qName.toString());
            }
            throw new WSPolicyException();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "anyDuplicateSupportedQNames", new Object[]{result});
        }
        return result;
    }

    @Override
    public WSPolicyAssertionProcessor findSupportingWSPolicyProcessor(QName assertionQN) {
        WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(assertionQN);
        return processor;
    }

    public boolean hasMergeBehavior(QName qName) {
        return this._behaviorMergeQNames.contains(qName);
    }

    @Override
    public boolean hasSupportBehavior(QName qName) {
        return this._behaviorSupportQNames.contains(qName);
    }

    @Override
    public WSPolicyFactory getWSPolicyFactory() {
        return this._wspf;
    }

    public WSPolicyAssertionProcessor getWSPolicyProcessor(Assertion assertion) {
        QName qn = assertion.getAssertionName();
        WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(qn);
        return processor;
    }

    public WSPolicyAssertionProcessor getWSPolicyProcessor(com.ibm.wspolicy.datamodel.Assertion assertion) {
        QName qn = assertion.getName();
        WSPolicyAssertionProcessor processor = this._assertionProcessorQNames.get(qn);
        return processor;
    }

    public void setWSPolicyProcessor(QName qn, WSPolicyAssertionProcessor processor) {
        this._assertionProcessorQNames.put(qn, processor);
    }

    public boolean hasScopeServiceBehavior(QName qName) {
        return this.behaviorScopeServiceQNames.contains(qName);
    }

    public boolean hasScopeEndpointBehavior(QName qName) {
        return this.behaviorScopeEndpointQNames.contains(qName);
    }

    public boolean hasScopeOperationBehavior(QName qName) {
        return this.behaviorScopeOperationQNames.contains(qName);
    }

    public boolean hasScopeMessageBehavior(QName qName) {
        return this.behaviorScopeMessageQNames.contains(qName);
    }

    @Override
    public List<com.ibm.wspolicy.datamodel.Assertion> getAssertionsForPolicyTypeFromAlternative(String policyType, PolicyProcessor.Alternative alternative) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAssertionsForPolicyTypeFromAlternative", new Object[]{policyType, alternative});
        }
        ArrayList<com.ibm.wspolicy.datamodel.Assertion> result = new ArrayList<com.ibm.wspolicy.datamodel.Assertion>();
        List<com.ibm.wspolicy.datamodel.Assertion> assertions = alternative.getAssertions();
        for (int i = 0; i < assertions.size(); ++i) {
            String namespace;
            com.ibm.wspolicy.datamodel.Assertion assertion = assertions.get(i);
            QName qName = assertion.getName();
            if (qName == null || (namespace = qName.getNamespaceURI()) == null) continue;
            String pType = this._namespace2PolicyType.get(namespace);
            if (pType != null && !"".equals(pType) && pType.equals(policyType)) {
                result.add(assertion);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "Found Assertion: " + qName.getLocalPart());
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
            Tr.debug(TRACE_COMPONENT, "Skip Assertion : " + qName.getLocalPart());
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAssertionsForPolicyTypeFromAlternative", result);
        }
        return result;
    }

    @Override
    public WSPolicyAssertionTransformer getAssertionTransformByType(String type) {
        return this._assertionProcessorsByType.get(type);
    }

    @Override
    public WSPolicyAssertionHandler getAssertionHandlerByType(String type) {
        return this._assertionProcessorsByType.get(type);
    }

    @Override
    public String getPolicyType(String namespace) {
        String result = this._namespace2PolicyType.get(namespace);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getPolicyType", result);
        }
        return result;
    }

    @Override
    public boolean isProviderVocabularyRequired(QName qn) {
        boolean result = this._providerVocabRequiredQNames.contains(qn);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isProviderVocabularyRequired", result);
        }
        return result;
    }

    private Set<String> getNamespacesFromVocab(Policy p) {
        HashSet<String> result = new HashSet<String>();
        for (QName qn : this._dmu.getVocabulary(p)) {
            result.add(qn.getNamespaceURI());
        }
        return result;
    }

    @Override
    public Set<QName> getClientCapabilitiesBucketForPolicy(Policy clientPolicy) {
        Set<String> namespacesInClientPolicy = this.getNamespacesFromVocab(clientPolicy);
        HashSet<QName> allKnownQNames = new HashSet<QName>(this._assertionProcessorQNames.keySet());
        for (String namespace : namespacesInClientPolicy) {
            Set<QName> toBeRemoved = this._clientCapabilitiesByNamespace.get(namespace);
            if (toBeRemoved == null) continue;
            allKnownQNames.removeAll(toBeRemoved);
        }
        return allKnownQNames;
    }

    @Override
    public Set<String> getAllDomainTypes() {
        return this._assertionProcessorsByType.keySet();
    }

    private void addExtensions(List<WSPolicyAssertionProcessor> extensions, IConfigurationElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            try {
                Object obj = elements[i].createExecutableExtension("class");
                if (!(obj instanceof WSPolicyAssertionProcessor)) {
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "addExtensions found non WSPolicyAssertionProcecssor", obj == null ? null : obj.getClass().getName());
                    continue;
                }
                WSPolicyAssertionProcessor wspap = (WSPolicyAssertionProcessor)obj;
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "registering WSPolicyAssertionProcessor " + wspap.getClass().getName());
                }
                extensions.add(wspap);
                continue;
            }
            catch (Throwable e) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "addExtensions caught Exception", e);
                }
                FFDCFilter.processException(e, "com.ibm.ws.wspolicy.domain.DefaultPolicyProviderRegistry", "635", this);
            }
        }
    }
}

