/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.WSPolicyIncompatiblePolicyAttachments;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyReference;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public class WSDLNodeWrapper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSDLNodeWrapper.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    WSPolicyFactory _wspf;
    Policy _emptyPolicy;
    ElementExtensible _node = null;
    List<Policy> _policyList = new ArrayList<Policy>();
    Policy _policyAtNode = null;
    List<String> _policySetWrapperNames = new ArrayList<String>();
    Definition _def = null;

    public WSDLNodeWrapper(WSPolicyFactory wspf, ElementExtensible node, Definition owningDefinition) {
        this._node = node;
        this._def = owningDefinition;
        this._wspf = wspf;
        this._emptyPolicy = this._wspf.createDataModelFactory().createPolicy();
    }

    public void addPolicy(Policy policy, String policySetWrapperName) {
        if (!this._policySetWrapperNames.contains(policySetWrapperName)) {
            this._policyList.add(policy);
            this._policyAtNode = policy;
            this._policySetWrapperNames.add(policySetWrapperName);
        }
    }

    public void resolvePolicy() throws WSPolicyIncompatiblePolicyAttachments, WSPolicyInternalException {
        if (this._policyList.size() > 1) {
            Policy policyA = this._policyList.remove(0);
            Policy policyB = this._policyList.remove(0);
            Policy policyC = null;
            if (policyA != null || policyB != null) {
                if (policyA == null) {
                    policyA = this._emptyPolicy;
                }
                if (policyB == null) {
                    policyB = this._emptyPolicy;
                }
                PolicyProcessor pp = this._wspf.createWSPolicyProcessor();
                try {
                    Iterable<PolicyProcessor.Alternative> intersectedAlts = pp.intersect(policyA, policyB, false);
                    policyC = pp.createPolicy(intersectedAlts);
                }
                catch (PolicyReferenceException e) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "intersectAndMerge caught Exception ", e);
                    }
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "116", this);
                    throw new WSPolicyInternalException(e);
                }
                if (policyC == null) {
                    WSPolicyIncompatiblePolicyAttachments wspipa = new WSPolicyIncompatiblePolicyAttachments(new Object[]{policyA, policyB});
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "resolvePolicy", wspipa);
                    }
                    FFDCFilter.processException((Throwable)wspipa, "com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper.resolvePolicy", "123", this);
                    throw wspipa;
                }
            }
            this._policyList.add(0, policyC);
            this.resolvePolicy();
        }
        if (this._policyList.size() > 0) {
            this._policyAtNode = this._policyList.get(0);
        }
    }

    public ElementExtensible getWSDLNode() {
        return this._node;
    }

    public void decorateWSDL(Definition def, String uri) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "decorateWSDL");
        }
        if (this._policyAtNode != null && this._node != null) {
            String uriStr = UUID.randomUUID().toString();
            this._policyAtNode.getOtherAttributes().put(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"), uriStr);
            ExtensibilityElement ee = InternalUtils.createExtensibilityElement(this._wspf, this._policyAtNode);
            if (this._def != null) {
                this._def.addExtensibilityElement(ee);
            } else {
                def.addExtensibilityElement(ee);
            }
            PolicyReference policyRef = this._wspf.createDataModelFactory().createPolicyReference();
            policyRef.setURI("#" + uriStr);
            ExtensibilityElement ee2 = InternalUtils.createExtensibilityElement(this._wspf, policyRef);
            this._node.addExtensibilityElement(ee2);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "decorateWSDL");
        }
    }
}

