/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.BindingAggregator;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeAggregator;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyIncorrectScopePointAttachment;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionHandler;
import com.ibm.ws.wspolicy.domain.WSPolicyTransform;
import com.ibm.wspolicy.datamodel.All;
import com.ibm.wspolicy.datamodel.Assertion;
import com.ibm.wspolicy.datamodel.ExactlyOne;
import com.ibm.wspolicy.datamodel.Operator;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.xml.ElementReader;
import com.ibm.wspolicy.xml.ElementReaderException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetWrapper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicySetWrapper.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private final String _policySetName;
    private final String _bindingName;
    private final String _bindingScope;
    private final List<PolicyElement> _peList;
    private final List<List<Integer>> _attachList;
    private static WSPolicyTransform _transformer = null;
    private static final PolicyProviderRegistry _ppr = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry();

    public PolicySetWrapper(String policySetName, String bindingName, String bindingScope, String pathName, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException, ElementReaderException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicySetWrapper CTOR", new Object[]{policySetName, bindingName});
        }
        this._policySetName = policySetName;
        this._bindingName = bindingName;
        this._bindingScope = bindingScope;
        this._peList = new ArrayList<PolicyElement>();
        this._attachList = new ArrayList<List<Integer>>();
        List types = null;
        try {
            types = PolicySetAttachmentsImpl.getTypesForPolicySet(this._policySetName);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.exit(TRACE_COMPONENT, "exception getting types for PolicySet", new Object[]{this._policySetName, e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "120", this);
            throw new WSPolicyInternalException();
        }
        if (types == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR - no policyTypes in policySet");
            }
            return;
        }
        ClassLoader appCL = this.getClass().getClassLoader();
        ClassLoader systemCL = this.getClass().getClassLoader();
        PolicySetConfiguration psCfg = PolicyTypeAggregator.getPolicySetConfiguration(systemCL, policySetName, types);
        psCfg.setPolicyTypeConfiguration("attachmentType", "application");
        BindingAggregator.getCustomBinding(pathName, bindingName, appCL, systemCL, psCfg, types, "application", bindingScope);
        this.init(psCfg, uri);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR");
        }
    }

    public PolicySetWrapper(PolicySetConfiguration psCfg, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException, ElementReaderException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicySetWrapper CTOR", new Object[]{psCfg, uri});
        }
        this._policySetName = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.POLICY_NAME_KEY");
        this._bindingName = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_NAME_KEY");
        this._bindingScope = (String)psCfg.getPolicyTypeConfiguration("com.ibm.ws.policyset.BINDING_SCOPE_KEY");
        this._peList = new ArrayList<PolicyElement>();
        this._attachList = new ArrayList<List<Integer>>();
        this.init(psCfg, uri);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicySetWrapper CTOR");
        }
    }

    public void init(PolicySetConfiguration psCfg, String uri) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException, WSPolicyBindingsException, TransformationException, ElementReaderException {
        _transformer = WSPolicyInternalFactory.singleton.createPolicyTransform();
        Set<String> allTypes = _ppr.getAllDomainTypes();
        Iterator<String> typeIterator = allTypes.iterator();
        HashMap<String, Object> transformOptions = new HashMap<String, Object>();
        transformOptions.put("com.ibm.ws.wspolicy.PolicySetConfiguration", psCfg);
        transformOptions.put("com.ibm.ws.wspolicy.URI", uri);
        while (typeIterator.hasNext()) {
            Integer attachPt;
            Iterator<Integer> it;
            WSPolicyIncorrectScopePointAttachment wspispa;
            List<Integer> otherAttachList;
            Assertion otherAssertion;
            Iterator<Assertion> iter;
            List<Assertion> v;
            ExactlyOne eo;
            List<Integer> tempAttachList;
            Assertion assertion;
            String policyType = typeIterator.next();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "init processing policyType", new Object[]{policyType});
            }
            if (policyType.equals("HTTPTransport") || policyType.equals("SSLTransport") || policyType.equals("JMSTransport") || policyType.equals("WSAddressing")) {
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "skipping policyType", new Object[]{policyType});
                continue;
            }
            Policy mainPolicy = null;
            Policy inputPolicy = null;
            Policy outputPolicy = null;
            WSPolicyAssertionHandler wspap = _ppr.getAssertionHandlerByType(policyType);
            if (wspap == null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "unable to obtain the assertion processor for policyType ", policyType);
                }
                WSPolicyInternalException wspie = new WSPolicyInternalException();
                FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "163", this);
                throw wspie;
            }
            PolicyInputStreamHolder psih = _transformer.transformForPublish(transformOptions, policyType);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Processing policies ", new Object[]{psih.getMain(), psih.getInput(), psih.getOutput()});
            }
            ElementReader<InputStream> er = _ppr.getWSPolicyFactory().getReader(InputStream.class);
            if (psih.getMain() != null) {
                mainPolicy = (Policy)er.read(psih.getMain());
            }
            if (psih.getInput() != null) {
                inputPolicy = (Policy)er.read(psih.getInput());
            }
            if (psih.getOutput() != null) {
                outputPolicy = (Policy)er.read(psih.getOutput());
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "policies after merge of type ", new Object[]{mainPolicy, inputPolicy, outputPolicy});
            }
            List<PolicyElement> peList = null;
            if (mainPolicy != null) {
                peList = this.getWrappedAssertions(mainPolicy);
                for (PolicyElement pe : peList) {
                    assertion = null;
                    tempAttachList = null;
                    if (pe instanceof Assertion) {
                        assertion = (Assertion)pe;
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                        }
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                    } else if (pe instanceof ExactlyOne) {
                        eo = (ExactlyOne)pe;
                        v = PolicySetWrapper.recursiveReturnChildAssertionsForPolicyElement(eo);
                        if (v.isEmpty()) {
                            throw new WSPolicyInternalException();
                        }
                        iter = v.iterator();
                        assertion = iter.next();
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                        if (tempAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                            }
                            throw new WSPolicyInternalException();
                        }
                        while (iter.hasNext()) {
                            otherAssertion = iter.next();
                            otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getName());
                            if (otherAttachList == null) {
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getName());
                                }
                                throw new WSPolicyInternalException();
                            }
                            tempAttachList.retainAll(otherAttachList);
                        }
                    }
                    if (tempAttachList == null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(mainPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "295", this);
                        throw wspispa;
                    }
                    if (!(tempAttachList.contains(2) || tempAttachList.contains(3) || tempAttachList.contains(1) || tempAttachList.contains(0))) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion in main policy not have cannot be attached to an Endpoint, Service or Operation Policy Subject", assertion.getName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(mainPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "305", this);
                        throw wspispa;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "attachList ", new Object[]{tempAttachList.toString()});
                    }
                    it = tempAttachList.iterator();
                    while (it.hasNext()) {
                        attachPt = it.next();
                        if (!this.isMessageSubject(attachPt)) continue;
                        it.remove();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "after attachList ", new Object[]{tempAttachList.toString()});
                    }
                    this._peList.add(pe);
                    this._attachList.add(tempAttachList);
                }
            }
            if (inputPolicy != null) {
                peList = this.getWrappedAssertions(inputPolicy);
                for (PolicyElement pe : peList) {
                    assertion = null;
                    tempAttachList = null;
                    if (pe instanceof Assertion) {
                        assertion = (Assertion)pe;
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                        }
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                    } else if (pe instanceof ExactlyOne) {
                        eo = (ExactlyOne)pe;
                        v = PolicySetWrapper.recursiveReturnChildAssertionsForPolicyElement(eo);
                        if (v.isEmpty()) {
                            throw new WSPolicyInternalException();
                        }
                        iter = v.iterator();
                        assertion = iter.next();
                        tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                        if (tempAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                            }
                            throw new WSPolicyInternalException();
                        }
                        while (iter.hasNext()) {
                            otherAssertion = iter.next();
                            otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getName());
                            if (otherAttachList == null) {
                                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                    Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getName());
                                }
                                throw new WSPolicyInternalException();
                            }
                            tempAttachList.retainAll(otherAttachList);
                        }
                    }
                    if (tempAttachList == null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(inputPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "375", this);
                        throw wspispa;
                    }
                    if (!tempAttachList.contains(4)) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion in input policy cannot be attached to the bindingInput", assertion.getName());
                        }
                        wspispa = new WSPolicyIncorrectScopePointAttachment(inputPolicy);
                        FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "381", this);
                        throw wspispa;
                    }
                    it = tempAttachList.iterator();
                    while (it.hasNext()) {
                        attachPt = it.next();
                        if (attachPt.equals(4)) continue;
                        it.remove();
                    }
                    this._peList.add(pe);
                    this._attachList.add(tempAttachList);
                }
            }
            if (outputPolicy == null) continue;
            peList = this.getWrappedAssertions(outputPolicy);
            for (PolicyElement pe : peList) {
                assertion = null;
                tempAttachList = null;
                if (pe instanceof Assertion) {
                    assertion = (Assertion)pe;
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Processing assertion ", new Object[]{assertion});
                    }
                    tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                } else if (pe instanceof ExactlyOne) {
                    eo = (ExactlyOne)pe;
                    v = PolicySetWrapper.recursiveReturnChildAssertionsForPolicyElement(eo);
                    if (v.isEmpty()) {
                        throw new WSPolicyInternalException();
                    }
                    iter = v.iterator();
                    assertion = iter.next();
                    tempAttachList = wspap.getAssertionAttachPoints(assertion.getName());
                    if (tempAttachList == null) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                        }
                        throw new WSPolicyInternalException();
                    }
                    while (iter.hasNext()) {
                        otherAssertion = iter.next();
                        otherAttachList = wspap.getAssertionAttachPoints(otherAssertion.getName());
                        if (otherAttachList == null) {
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", otherAssertion.getName());
                            }
                            throw new WSPolicyInternalException();
                        }
                        tempAttachList.retainAll(otherAttachList);
                    }
                }
                if (tempAttachList == null) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "assertion does not have any defined attach points", assertion.getName());
                    }
                    wspispa = new WSPolicyIncorrectScopePointAttachment(outputPolicy);
                    FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "442", this);
                    throw wspispa;
                }
                if (!tempAttachList.contains(5)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "assertion in output policy cannot be attached to the bindingOutput", assertion.getName());
                    }
                    wspispa = new WSPolicyIncorrectScopePointAttachment(outputPolicy);
                    FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.PolicySetWrapper.CTOR", "448", this);
                    throw wspispa;
                }
                it = tempAttachList.iterator();
                while (it.hasNext()) {
                    attachPt = it.next();
                    if (attachPt.equals(5)) continue;
                    it.remove();
                }
                this._peList.add(pe);
                this._attachList.add(tempAttachList);
            }
        }
    }

    private List<PolicyElement> getWrappedAssertions(Operator oper) {
        List<PolicyElement> result = null;
        if (oper instanceof ExactlyOne) {
            List<PolicyElement> children = oper.getChildren();
            if (children.size() == 1) {
                PolicyElement child = children.get(0);
                if (child instanceof Operator) {
                    result = this.getWrappedAssertions((Operator)child);
                } else if (child instanceof Assertion) {
                    result = new ArrayList();
                    result.add(child);
                }
            }
            if (result == null) {
                result = new ArrayList();
                result.add(oper);
            }
        } else if (oper instanceof All || oper instanceof Policy) {
            result = new ArrayList<PolicyElement>();
            List<PolicyElement> children = oper.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                PolicyElement child = children.get(i);
                if (child instanceof Assertion) {
                    result.add(child);
                    continue;
                }
                if (!(child instanceof Operator)) continue;
                result.addAll(this.getWrappedAssertions((Operator)child));
            }
        }
        return result;
    }

    private boolean isMessageSubject(int attachpoint) {
        if (attachpoint == 4 || attachpoint == 5) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "isMessageSubject", new Object[]{true});
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isMessageSubject", new Object[]{false});
        }
        return false;
    }

    public String getName() {
        String name = this._policySetName + "/" + this._bindingName + "/" + this._bindingScope;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getName", new Object[]{name});
        }
        return name;
    }

    public List<PolicyElement> getPolicyElementList() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicyElementList", new Object[]{this._policySetName, this._bindingName});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicyElementList", new Object[]{this._peList});
        }
        return this._peList;
    }

    public List<List<Integer>> getAttachPointList() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAttachPointList", new Object[]{this._policySetName, this._bindingName});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAttachPointList", new Object[]{this._attachList});
        }
        return this._attachList;
    }

    public static List<Assertion> recursiveReturnChildAssertionsForPolicyElement(PolicyElement pe) {
        ArrayList<Assertion> result = new ArrayList<Assertion>();
        PolicySetWrapper.populateAssertionList(pe, result);
        return result;
    }

    public static void populateAssertionList(PolicyElement pe, List<Assertion> assertions) {
        if (pe instanceof Assertion) {
            assertions.add((Assertion)pe);
        } else if (pe instanceof Operator) {
            Operator op = (Operator)pe;
            for (PolicyElement p : op.getChildren()) {
                PolicySetWrapper.populateAssertionList(p, assertions);
            }
        }
    }
}

