/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.attachment;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.EmptyPolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetAttachmentsImpl;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.webservices.exception.WSDLPostProcessingException;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.wspolicy.TransformationException;
import com.ibm.ws.wspolicy.WSPolicyBindingsException;
import com.ibm.ws.wspolicy.WSPolicyIncompatiblePolicyAttachments;
import com.ibm.ws.wspolicy.WSPolicyIncorrectScopePointAttachment;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelperFactory;
import com.ibm.ws.wspolicy.attachment.PolicySetWrapper;
import com.ibm.ws.wspolicy.attachment.WSDLNodeWrapper;
import com.ibm.ws.wspolicy.attachment.WSDLPostProcessorExtended;
import com.ibm.ws.wspolicy.domain.PolicyProviderRegistry;
import com.ibm.ws.wspolicy.utils.InternalUtils;
import com.ibm.ws.wspolicy.utils.PSWrapperTreeNode;
import com.ibm.ws.wspolicy.utils.WSDLTreeNode;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.datamodel.PolicyElement;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetAttachment;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetBinding;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.PolicySetReference;
import com.ibm.xmlns.prod.websphere._200605.policysetattachment.Resource;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSPolicyServiceControlReference;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLElement;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultWSDLPostProcessorImpl implements WSDLPostProcessorExtended
{
    singleton;

    private static final TraceComponent TRACE_COMPONENT;

    @Override
    public void postProcessWSDL(Definition definition, Map parameters) throws WSDLPostProcessingException {
        String cuName;
        String appName = (String)parameters.get("APP_NAME_KEY");
        String modName = (String)parameters.get("MODULE_NAME_KEY");
        QName svcName = (QName)parameters.get("SERVICE_NAME_KEY");
        AxisService axisService = (AxisService)parameters.get("AXIS_SERVICE_KEY");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "postProcessWSDL", new Object[]{appName, modName, svcName});
        }
        if (axisService != null && (cuName = (String)axisService.getParameterValue("com.ibm.ws.wspolicy.PolicyConstants.Axis2Service_CUName_Key")) != null && !cuName.equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "Non-null CU name " + cuName + ", policy will not be attached to WSDL");
            }
            return;
        }
        if (appName == null || modName == null || svcName == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "policy will not be attached to WSDL: null input paramater: ", new Object[]{appName, modName, svcName});
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{svcName});
            return;
        }
        if (appName.endsWith(".ear")) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "truncating");
            }
            appName = appName.substring(0, appName.lastIndexOf(".ear"));
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "truncated to ", new Object[]{appName});
            }
        }
        WSPolicyServiceControlReference scRef = null;
        try {
            FileLocator locator = FileLocatorFactory.getFileLocator();
            String path = locator.getAttachmentPath(appName, "wsPolicyServiceControl.xml");
            String policySetAttachmentPath = locator.getAttachmentPath(appName, "policyAttachments.xml");
            WSPolicyServiceControlHelper scHelper = WSPolicyServiceControlHelperFactory.createHelper(path, policySetAttachmentPath);
            String resourceRef = "WebService:/" + modName + ":" + svcName;
            scRef = scHelper.getWSPolicyServiceControlReferenceInherited(resourceRef);
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "policy will not be attached to WSDL: postProcessWSDL caught Exception ", e);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{svcName});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "140", this);
            return;
        }
        if (scRef == null || !scRef.isExportPolicySetConfigurationInWSDL().booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "policy will not be attached to WSDL");
            }
            return;
        }
        try {
            this.postProcessWSDL(definition, appName, modName, svcName, axisService, null);
        }
        catch (WSPolicyInternalException wspie) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "WSDL cannot be annotated : preventing publish ", wspie);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{svcName});
            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "198", this);
            throw new WSDLPostProcessingException(wspie);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "postProcessWSDL");
        }
    }

    @Override
    public void postProcessWSDL(Definition definition, String appName, String modName, QName wsdlSvcQName, AxisService axisService, String uri) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "postProcessWSDL", new Object[]{appName, modName, wsdlSvcQName, uri});
        }
        PolicyProviderRegistry ppr = WSPolicyInternalFactory.singleton.createPolicyProviderRegistry();
        WSPolicyFactory wspf = ppr.getWSPolicyFactory();
        Service wsdlService = null;
        wsdlService = definition.getService(wsdlSvcQName);
        try {
            if (wsdlService == null) {
                Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{wsdlSvcQName});
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "postProcessWSDL could not find service with QName ", wsdlSvcQName);
                }
                return;
            }
            ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassLoader.getSystemClassLoader();
                }
            });
            PolicySetUtil psu = PolicySetUtil.getInstance(cl);
            PSWrapperTreeNode baseNode = new PSWrapperTreeNode("");
            String wsdlSvcName = wsdlSvcQName.toString();
            ArrayList<WSDLTreeNode> leafNodes = new ArrayList<WSDLTreeNode>();
            ArrayList<String> operationNameList = new ArrayList<String>();
            WSDLTreeNode wsdlServiceTreeNode = this.createCompleteWSDLTreeNodeTree(wspf, definition, wsdlService, wsdlSvcName, leafNodes, operationNameList);
            uri = this.updateWSDLURIs(wsdlService, uri);
            Map prefix2namespace = definition.getNamespaces();
            if (!prefix2namespace.containsValue("http://www.w3.org/ns/ws-policy") && !prefix2namespace.containsKey("wsp")) {
                definition.addNamespace("wsp", "http://www.w3.org/ns/ws-policy");
            }
            if (!prefix2namespace.containsValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd") && !prefix2namespace.containsKey("wsu")) {
                definition.addNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            }
            if (axisService != null) {
                QName axisServiceQName = Axis2Utils.getServiceQName(axisService);
                AxisConfiguration axisCfg = axisService.getAxisConfiguration();
                HashMap axisCfgServices = axisCfg.getServices();
                Set axisServiceEntrySet = axisCfgServices.entrySet();
                Iterator entrySetIterator = axisServiceEntrySet.iterator();
                String resourceKey = "WebService:/";
                if (modName != null) {
                    resourceKey = resourceKey + modName + ":";
                }
                resourceKey = resourceKey + wsdlSvcName;
                while (entrySetIterator.hasNext()) {
                    AxisService as = (AxisService)entrySetIterator.next().getValue();
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "got service name from AxisConfiguration ", as.getName());
                    }
                    if (!axisServiceQName.equals(Axis2Utils.getServiceQName(as))) continue;
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "service name matches ", as.getName());
                    }
                    Iterator operationIter = as.getOperations();
                    while (operationIter.hasNext()) {
                        AxisOperation axisOper = (AxisOperation)operationIter.next();
                        QName axisOperQName = axisOper.getName();
                        if (!operationNameList.contains(axisOperQName.getLocalPart())) continue;
                        PolicySetConfiguration psCfg = (PolicySetConfiguration)Axis2Utils.getPolicySet(axisOper);
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                            Tr.exit(TRACE_COMPONENT, "service classloader ", as.getClassLoader());
                        }
                        PolicySetWrapper psWrapper = new PolicySetWrapper(psCfg, uri);
                        String operationResourceKey = resourceKey + "/" + Axis2Utils.getPortName(as) + "/" + axisOperQName.getLocalPart();
                        PolicyResource policyResource = new PolicyResource(operationResourceKey);
                        PSWrapperTreeNode currentNode = this.createTreeNode(baseNode, policyResource, modName, wsdlSvcName);
                        currentNode.setPolicySetWrapper(psWrapper);
                    }
                }
            } else {
                leafNodes.clear();
                PolicySetAttachments psas = null;
                try {
                    psas = psu.getAttachments(appName);
                }
                catch (Exception e) {
                    WSPolicyInternalException wspie = new WSPolicyInternalException(e);
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "185", this);
                    throw wspie;
                }
                if (psas instanceof EmptyPolicySetAttachmentsImpl) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "postProcessWSDL - no policy to attach");
                    }
                    return;
                }
                PolicySetAttachmentsImpl psasImpl = (PolicySetAttachmentsImpl)psas;
                PolicySetAttachment psa = psasImpl.getAttachments();
                List<PolicySetReference> referenceList = psa.getPolicySetReference();
                for (PolicySetReference reference : referenceList) {
                    String policySetName = reference.getName();
                    List<Resource> resourceList = reference.getResource();
                    for (Resource resource : resourceList) {
                        PolicyResource policyResource = new PolicyResource(resource);
                        PSWrapperTreeNode currentNode = this.createTreeNode(baseNode, policyResource, modName, wsdlSvcName);
                        if (currentNode == null) continue;
                        String psBindingName = null;
                        String psBindingScope = null;
                        PolicySetBinding psBinding = reference.getPolicySetBinding();
                        String pathName = null;
                        if (psBinding != null) {
                            psBindingName = psBinding.getName();
                            psBindingScope = psBinding.getScope();
                            FileLocator locator = FileLocatorFactory.getFileLocator();
                            String path = locator.getAttachmentPath(appName, "policyAttachments.xml");
                            pathName = locator.getParent(path);
                        }
                        PolicySetWrapper wrapper = new PolicySetWrapper(policySetName, psBindingName, psBindingScope, pathName, uri);
                        currentNode.setPolicySetWrapper(wrapper);
                    }
                }
            }
            PolicySetWrapper applicationPSWrapper = baseNode.getPolicySetWrapper();
            PSWrapperTreeNode moduleNode = baseNode.getChildNode(modName);
            WSDLNodeWrapper wsdlServiceNodeWrapper = new WSDLNodeWrapper(wspf, wsdlService, this.getOwningDefinition(definition, wsdlService));
            wsdlServiceTreeNode.addWSDLNodeWrapper(wsdlServiceNodeWrapper, 0);
            if (moduleNode != null) {
                PSWrapperTreeNode serviceNode;
                PolicySetWrapper modulePSWrapper;
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "moduleNode found", new Object[]{modName});
                }
                if ((modulePSWrapper = moduleNode.getPolicySetWrapper()) == null) {
                    modulePSWrapper = applicationPSWrapper;
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "looking for serviceNode with name", new Object[]{wsdlSvcName});
                }
                if ((serviceNode = moduleNode.getChildNode(wsdlSvcName)) != null) {
                    boolean hasChildren;
                    PolicySetWrapper servicePSWrapper;
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "serviceNode found", new Object[]{wsdlSvcName});
                    }
                    if ((servicePSWrapper = serviceNode.getPolicySetWrapper()) == null) {
                        servicePSWrapper = modulePSWrapper;
                    }
                    if (hasChildren = serviceNode.hasAnyChildren()) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "service has children");
                        }
                        Map wsdlPorts = wsdlService.getPorts();
                        Set wsdlPortSet = wsdlPorts.entrySet();
                        for (Map.Entry wsdlPortEntry : wsdlPortSet) {
                            String wsdlPortName = (String)wsdlPortEntry.getKey();
                            Port wsdlPort = (Port)wsdlPortEntry.getValue();
                            WSDLTreeNode wsdlEndpointTreeNode = wsdlServiceTreeNode.getChildNode(wsdlPortName);
                            PSWrapperTreeNode portNode = serviceNode.getChildNode(wsdlPortName);
                            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "portNodename, portNode ", new Object[]{wsdlPortName, portNode});
                            }
                            Binding wsdlBinding = wsdlPort.getBinding();
                            if (portNode != null) {
                                boolean portHasChildren;
                                PolicySetWrapper portPSWrapper = portNode.getPolicySetWrapper();
                                if (portPSWrapper == null) {
                                    portPSWrapper = servicePSWrapper;
                                }
                                if (portHasChildren = portNode.hasAnyChildren()) {
                                    List bindingOperations = wsdlBinding.getBindingOperations();
                                    for (BindingOperation bo : bindingOperations) {
                                        String boName = bo.getName();
                                        WSDLTreeNode wsdlboTreeNode = wsdlEndpointTreeNode.getChildNode(boName);
                                        PSWrapperTreeNode opNode = portNode.getChildNode(boName);
                                        if (opNode == null) {
                                            if (portPSWrapper != null) {
                                                leafNodes.add(wsdlboTreeNode);
                                            }
                                            wsdlboTreeNode.tagTreeWithPolicySets(portPSWrapper);
                                            continue;
                                        }
                                        PolicySetWrapper opPSWrapper = opNode.getPolicySetWrapper();
                                        if (opPSWrapper == null) {
                                            opPSWrapper = portPSWrapper;
                                        }
                                        if (opPSWrapper != null) {
                                            leafNodes.add(wsdlboTreeNode);
                                        }
                                        wsdlboTreeNode.tagTreeWithPolicySets(opPSWrapper);
                                    }
                                    continue;
                                }
                                if (portPSWrapper != null) {
                                    leafNodes.add(wsdlEndpointTreeNode);
                                }
                                wsdlEndpointTreeNode.tagTreeWithPolicySets(portPSWrapper);
                                continue;
                            }
                            if (servicePSWrapper != null) {
                                leafNodes.add(wsdlEndpointTreeNode);
                            }
                            wsdlEndpointTreeNode.tagTreeWithPolicySets(servicePSWrapper);
                        }
                    } else {
                        if (servicePSWrapper != null) {
                            leafNodes.add(wsdlServiceTreeNode);
                        }
                        wsdlServiceTreeNode.tagTreeWithPolicySets(servicePSWrapper);
                    }
                } else {
                    if (modulePSWrapper != null) {
                        leafNodes.add(wsdlServiceTreeNode);
                    }
                    wsdlServiceTreeNode.tagTreeWithPolicySets(modulePSWrapper);
                }
            } else {
                if (applicationPSWrapper != null) {
                    leafNodes.add(wsdlServiceTreeNode);
                }
                wsdlServiceTreeNode.tagTreeWithPolicySets(applicationPSWrapper);
            }
            if (leafNodes.size() > 0) {
                Iterator leafIterator = leafNodes.iterator();
                boolean verificationRequired = false;
                while (leafIterator.hasNext()) {
                    WSDLTreeNode node = (WSDLTreeNode)leafIterator.next();
                    verificationRequired |= this.processPolicyForBranch(wspf, node);
                }
                if (verificationRequired) {
                    wsdlServiceTreeNode.resolveWSDL();
                }
                wsdlServiceTreeNode.decorateWSDL(definition, uri);
            }
        }
        catch (WSPolicyInternalException wspie) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", wspie);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{wsdlSvcQName});
            FFDCFilter.processException((Throwable)wspie, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "513", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (TransformationException te) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", te);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1200", new Object[]{wsdlSvcQName, te.getAspect()});
            FFDCFilter.processException((Throwable)te, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "519", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (WSPolicyIncompatiblePolicyAttachments wspipa) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", wspipa);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1200", new Object[]{wsdlSvcQName, wspipa.getAspect()});
            FFDCFilter.processException((Throwable)wspipa, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "525", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (WSPolicyIncorrectScopePointAttachment wspispa) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", wspispa);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1201", new Object[]{wsdlSvcQName, wspispa.getAspect()});
            FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "531", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (WSPolicyBindingsException wsbe) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", wsbe);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1200", new Object[]{wsdlSvcQName, wsbe.getCause()});
            FFDCFilter.processException((Throwable)wsbe, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "538", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (RuntimeException rte) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", rte);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{wsdlSvcQName});
            FFDCFilter.processException((Throwable)rte, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "544", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        catch (ElementReaderException e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "postProcessWSDL caught exception ", e);
            }
            Tr.warning(TRACE_COMPONENT, "CWPOL1251", new Object[]{wsdlSvcQName});
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.postProcessWSDL", "548", this);
            this.spikeWSDL(wspf, definition, wsdlService);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "postProcessWSDL output ", definition);
        }
    }

    @Override
    public void registerExtensions(ExtensionRegistry registry) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "registerExtensions", new Object[]{registry});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "registerExtensions");
        }
    }

    private boolean processPolicyForBranch(WSPolicyFactory wspf, WSDLTreeNode wsdlTreeNode) throws WSPolicyIncorrectScopePointAttachment, WSPolicyInternalException {
        int i;
        int currentPolicySubject = wsdlTreeNode.getPolicySubject();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "processPolicyForBranch", new Object[]{currentPolicySubject});
        }
        boolean verificationRequired = false;
        WSDLTreeNode highestNodeToAttach = wsdlTreeNode.highestNodeWithNoDuplicatePolicySets(wsdlTreeNode);
        int highestNodeToAttachPolicySubject = highestNodeToAttach.getPolicySubject();
        PolicySetWrapper psWrapper = wsdlTreeNode.getLeafPolicySetWrapper();
        List<PolicyElement> peList = psWrapper.getPolicyElementList();
        List<List<Integer>> attachList = psWrapper.getAttachPointList();
        Policy[] policyArray = new Policy[6];
        for (i = 0; i < peList.size(); ++i) {
            PolicyElement pe = peList.get(i);
            List<Integer> attachPoints = attachList.get(i);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "processPolicy element", new Object[]{pe, attachPoints.toString()});
            }
            int attachPointFound = -1;
            int lowestAttachPointFound = -1;
            for (Integer attachPoint : attachPoints) {
                int policySubject = WSDLTreeNode.attachPoint2PolicySubject(attachPoint);
                if (policySubject > lowestAttachPointFound) {
                    lowestAttachPointFound = attachPoint;
                }
                if (policySubject < highestNodeToAttachPolicySubject) continue;
                attachPointFound = attachPoint;
                break;
            }
            if (attachPointFound == -1) {
                if (lowestAttachPointFound > -1) {
                    verificationRequired = true;
                    attachPointFound = lowestAttachPointFound;
                } else {
                    WSPolicyIncorrectScopePointAttachment wspispa = new WSPolicyIncorrectScopePointAttachment(pe);
                    FFDCFilter.processException((Throwable)wspispa, "com.ibm.ws.wspolicy.attachment.DefaultWSDLPostProcessorImpl.processPolicyForBranch", "486", this);
                    throw wspispa;
                }
            }
            if (policyArray[attachPointFound] == null) {
                policyArray[attachPointFound] = wspf.createDataModelFactory().createPolicy();
            }
            policyArray[attachPointFound].getChildren().add(pe);
        }
        for (i = 0; i < 6; ++i) {
            wsdlTreeNode.addPolicy(policyArray[i], i, psWrapper.getName());
        }
        return verificationRequired;
    }

    private PSWrapperTreeNode createTreeNode(PSWrapperTreeNode treeNode, PolicyResource policyResource, String matchModuleName, String matchServiceName) {
        String opName;
        String eptName;
        String svcName;
        String modName = policyResource.getModuleName();
        if (modName == null) {
            return treeNode;
        }
        if (!modName.equals(matchModuleName)) {
            return null;
        }
        PSWrapperTreeNode modNode = treeNode.getChildNode(modName);
        if (modNode == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "create new Module PSWrapper", new Object[]{modName});
            }
            modNode = new PSWrapperTreeNode(modName);
            treeNode.addChild(modNode);
        }
        if ((svcName = policyResource.getServiceName()) == null) {
            return modNode;
        }
        if (!svcName.equals(matchServiceName)) {
            return null;
        }
        PSWrapperTreeNode svcNode = modNode.getChildNode(svcName);
        if (svcNode == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "create new Service PSWrapper", new Object[]{svcName});
            }
            svcNode = new PSWrapperTreeNode(svcName);
            modNode.addChild(svcNode);
        }
        if ((eptName = policyResource.getEndpointName()) == null) {
            return svcNode;
        }
        PSWrapperTreeNode eptNode = svcNode.getChildNode(eptName);
        if (eptNode == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "create new Endpoint PSWrapper", new Object[]{eptName});
            }
            eptNode = new PSWrapperTreeNode(eptName);
            svcNode.addChild(eptNode);
        }
        if ((opName = policyResource.getOperationName()) == null) {
            return eptNode;
        }
        PSWrapperTreeNode opNode = eptNode.getChildNode(opName);
        if (opNode == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "create new Operation PSWrapper", new Object[]{opName});
            }
            opNode = new PSWrapperTreeNode(opName);
            eptNode.addChild(opNode);
        }
        return opNode;
    }

    private void spikeWSDL(WSPolicyFactory wspf, Definition wsdlDefinition, Service wsdlService) throws WSPolicyInternalException {
        Policy spikedPolicy = wspf.createDataModelFactory().createPolicy();
        spikedPolicy.getChildren().add(wspf.createDataModelFactory().createExactlyOne());
        if (wsdlService != null) {
            ExtensibilityElement ee = InternalUtils.createExtensibilityElement(wspf, spikedPolicy);
            wsdlService.addExtensibilityElement(ee);
        } else {
            Map serviceMap = wsdlDefinition.getServices();
            for (Service service : serviceMap.values()) {
                ExtensibilityElement ee = InternalUtils.createExtensibilityElement(wspf, spikedPolicy);
                service.addExtensibilityElement(ee);
            }
        }
    }

    private void removeExternalPolicies(WSDLElement wsdlElement) {
        QName elementType;
        Iterator EEIter = wsdlElement.getExtensibilityElements().iterator();
        while (EEIter.hasNext()) {
            ExtensibilityElement EE = (ExtensibilityElement)EEIter.next();
            elementType = EE.getElementType();
            if (elementType == null || !"http://www.w3.org/ns/ws-policy".equals(elementType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(elementType.getNamespaceURI())) continue;
            EEIter.remove();
        }
        Iterator EAIter = wsdlElement.getExtensionAttributes().keySet().iterator();
        while (EAIter.hasNext()) {
            elementType = (QName)EAIter.next();
            if (elementType == null || !"http://www.w3.org/ns/ws-policy".equals(elementType.getNamespaceURI()) && !"http://schemas.xmlsoap.org/ws/2004/09/policy".equals(elementType.getNamespaceURI())) continue;
            EAIter.remove();
        }
    }

    private WSDLTreeNode createCompleteWSDLTreeNodeTree(WSPolicyFactory wspf, Definition definition, Service wsdlService, String wsdlSvcName, List<WSDLTreeNode> leafNodes, List<String> operationNameList) {
        this.removeExternalPolicies(wsdlService);
        WSDLTreeNode wsdlServiceTreeNode = new WSDLTreeNode(wsdlSvcName, 0);
        Definition serviceOwningDef = this.getOwningDefinition(definition, wsdlService);
        WSDLNodeWrapper wsdlServiceNodeWrapper = new WSDLNodeWrapper(wspf, wsdlService, serviceOwningDef);
        wsdlServiceTreeNode.addWSDLNodeWrapper(wsdlServiceNodeWrapper, 0);
        Map wsdlPorts = wsdlService.getPorts();
        Set wsdlPortSet = wsdlPorts.entrySet();
        for (Map.Entry wsdlPortEntry : wsdlPortSet) {
            String wsdlPortName = (String)wsdlPortEntry.getKey();
            Port wsdlPort = (Port)wsdlPortEntry.getValue();
            this.removeExternalPolicies(wsdlPort);
            WSDLTreeNode wsdlEndpointTreeNode = new WSDLTreeNode(wsdlPortName, 1);
            WSDLNodeWrapper wsdlPortNodeWrapper = new WSDLNodeWrapper(wspf, wsdlPort, serviceOwningDef);
            wsdlEndpointTreeNode.addWSDLNodeWrapper(wsdlPortNodeWrapper, 1);
            wsdlServiceTreeNode.addChild(wsdlEndpointTreeNode);
            Binding wsdlBinding = wsdlPort.getBinding();
            this.removeExternalPolicies(wsdlBinding);
            Definition bindingOwningDef = this.getOwningDefinition(definition, wsdlBinding);
            WSDLNodeWrapper wsdlBindingNodeWrapper = new WSDLNodeWrapper(wspf, wsdlBinding, bindingOwningDef);
            wsdlEndpointTreeNode.addWSDLNodeWrapper(wsdlBindingNodeWrapper, 2);
            List bindingOperations = wsdlBinding.getBindingOperations();
            for (BindingOperation bindingOperation : bindingOperations) {
                BindingOutput output;
                this.removeExternalPolicies(bindingOperation);
                String boName = bindingOperation.getName();
                WSDLTreeNode wsdlboTreeNode = new WSDLTreeNode(boName, 2);
                WSDLNodeWrapper wsdlOperationNodeWrapper = new WSDLNodeWrapper(wspf, bindingOperation, bindingOwningDef);
                wsdlboTreeNode.addWSDLNodeWrapper(wsdlOperationNodeWrapper, 3);
                wsdlEndpointTreeNode.addChild(wsdlboTreeNode);
                leafNodes.add(wsdlboTreeNode);
                operationNameList.add(boName);
                WSDLTreeNode wsdlMessageTreeNode = null;
                BindingInput input = bindingOperation.getBindingInput();
                if (input != null) {
                    this.removeExternalPolicies(input);
                    wsdlMessageTreeNode = new WSDLTreeNode(input.getName(), 3);
                    wsdlboTreeNode.addChild(wsdlMessageTreeNode);
                    WSDLNodeWrapper bindingInputNodeWrapper = new WSDLNodeWrapper(wspf, input, bindingOwningDef);
                    wsdlMessageTreeNode.addWSDLNodeWrapper(bindingInputNodeWrapper, 4);
                }
                if ((output = bindingOperation.getBindingOutput()) != null) {
                    if (wsdlMessageTreeNode == null) {
                        wsdlMessageTreeNode = new WSDLTreeNode(output.getName(), 3);
                    }
                    this.removeExternalPolicies(output);
                    WSDLNodeWrapper bindingOutputNodeWrapper = new WSDLNodeWrapper(wspf, output, bindingOwningDef);
                    wsdlMessageTreeNode.addWSDLNodeWrapper(bindingOutputNodeWrapper, 5);
                }
                Map faults = bindingOperation.getBindingFaults();
                Set faultSet = faults.entrySet();
                for (Map.Entry faultEntry : faultSet) {
                    BindingFault fault = (BindingFault)faultEntry.getValue();
                    this.removeExternalPolicies(fault);
                }
            }
            PortType wsdlPortType = wsdlBinding.getPortType();
            this.removeExternalPolicies(wsdlPortType);
            List ops = wsdlPortType.getOperations();
            for (Operation wsdlOperation : ops) {
                Output opOutput;
                this.removeExternalPolicies(wsdlOperation);
                Input opInput = wsdlOperation.getInput();
                if (opInput != null) {
                    this.removeExternalPolicies(opInput);
                }
                if ((opOutput = wsdlOperation.getOutput()) != null) {
                    this.removeExternalPolicies(opOutput);
                }
                Map faults = wsdlOperation.getFaults();
                Set faultSet = faults.entrySet();
                for (Map.Entry faultEntry : faultSet) {
                    Fault fault = (Fault)faultEntry.getValue();
                    this.removeExternalPolicies(fault);
                }
            }
        }
        return wsdlServiceTreeNode;
    }

    private String updateWSDLURIs(Service wsdlService, String uri) {
        Map wsdlPorts = wsdlService.getPorts();
        Set wsdlPortSet = wsdlPorts.entrySet();
        Iterator wsdlPortIterator = wsdlPortSet.iterator();
        String uriFound = null;
        block0: while (wsdlPortIterator.hasNext() && uriFound == null) {
            Map.Entry wsdlPortEntry = wsdlPortIterator.next();
            Port wsdlPort = (Port)wsdlPortEntry.getValue();
            List extElem = wsdlPort.getExtensibilityElements();
            for (ExtensibilityElement element : extElem) {
                ExtensibilityElement address;
                if (element instanceof SOAPAddress) {
                    address = (SOAPAddress)element;
                    if (uri == null) {
                        uriFound = address.getLocationURI();
                        continue block0;
                    }
                    address.setLocationURI(uri);
                    continue;
                }
                if (!(element instanceof SOAP12Address)) continue;
                address = (SOAP12Address)element;
                if (uri == null) {
                    uriFound = address.getLocationURI();
                    continue block0;
                }
                address.setLocationURI(uri);
            }
        }
        if (uri == null) {
            uri = uriFound;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "PORTURI found ", new Object[]{uri});
        }
        return uri;
    }

    @Override
    public int getWeight() {
        return 0;
    }

    private Definition getOwningDefinition(Definition baseDefinition, Service service) {
        Map localMap = baseDefinition.getServices();
        if (localMap.containsKey(service.getQName())) {
            return baseDefinition;
        }
        Map importMap = baseDefinition.getImports();
        for (Vector imports : importMap.values()) {
            for (Import imp : imports) {
                Definition importDefinition = imp.getDefinition();
                if (importDefinition.getServices().containsKey(service.getQName())) {
                    return importDefinition;
                }
                Definition def = this.getOwningDefinition(importDefinition, service);
                if (def == null) continue;
                return def;
            }
        }
        return null;
    }

    private Definition getOwningDefinition(Definition baseDefinition, Binding binding) {
        Map localMap = baseDefinition.getBindings();
        if (localMap.containsKey(binding.getQName())) {
            return baseDefinition;
        }
        Map importMap = baseDefinition.getImports();
        for (Vector imports : importMap.values()) {
            for (Import imp : imports) {
                Definition importDefinition = imp.getDefinition();
                if (importDefinition.getBindings().containsKey(binding.getQName())) {
                    return importDefinition;
                }
                Definition def = this.getOwningDefinition(importDefinition, binding);
                if (def == null) continue;
                return def;
            }
        }
        return null;
    }

    static {
        TRACE_COMPONENT = Tr.register(DefaultWSDLPostProcessorImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    }
}

