/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.admin.service.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.admin.impl.ControlHelperImpl;
import com.ibm.ws.wspolicy.admin.service.WSPolicyServiceControlHelper;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSMexResourceEndpoint;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSPolicyServiceControl;
import com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol.WSPolicyServiceControlReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyServiceControlHelperImpl
extends ControlHelperImpl
implements WSPolicyServiceControlHelper {
    private static final TraceComponent tc = Tr.register(WSPolicyServiceControlHelperImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final String WSPOLICY_SERVICE_JAXB_PACKAGE = "com.ibm.xmlns.prod.websphere._200709.wspolicyservicecontrol";
    private WSPolicyServiceControl _serviceControl;

    public WSPolicyServiceControlHelperImpl(String fileName, String policySetAttachmentsFileName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPolicyServiceControlHelperImpl", new Object[]{fileName, policySetAttachmentsFileName});
        }
        this._fileName = fileName;
        this._policySetAttachmentsFileName = policySetAttachmentsFileName;
    }

    public WSPolicyServiceControlHelperImpl(InputStream inputStream, InputStream policySetAttachmentsInputStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPolicyServiceControlHelperImpl", new Object[]{inputStream, policySetAttachmentsInputStream});
        }
        this._inputStream = inputStream;
        this._policySetAttachmentsInputStream = policySetAttachmentsInputStream;
    }

    @Override
    public WSPolicyServiceControlReference getWSPolicyServiceControlReference(String resource) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlReference", new Object[]{resource, this});
        }
        WSPolicyServiceControlReference serviceControlReference = null;
        if (this._serviceControl == null) {
            this._serviceControl = (WSPolicyServiceControl)this.loadData(WSPOLICY_SERVICE_JAXB_PACKAGE, WSPolicyServiceControlHelperImpl.class.getClassLoader());
        }
        if (this._serviceControl != null) {
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            List<WSPolicyServiceControlReference> serviceControlReferences = this._serviceControl.getWSPolicyServiceControlReference();
            for (WSPolicyServiceControlReference controlRef : serviceControlReferences) {
                String candidateResource = controlRef.getResource();
                if (!candidateResource.endsWith("/")) {
                    candidateResource = candidateResource + "/";
                }
                if (!candidateResource.equals(resource)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found control reference");
                }
                serviceControlReference = controlRef;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlReference", serviceControlReference);
        }
        return serviceControlReference;
    }

    @Override
    public WSPolicyServiceControlReference getWSPolicyServiceControlReferenceInherited(String resource) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlReferenceInherited", new Object[]{resource, this});
        }
        WSPolicyServiceControlReference serviceControlReference = null;
        if (this._serviceControl == null) {
            this._serviceControl = (WSPolicyServiceControl)this.loadData(WSPOLICY_SERVICE_JAXB_PACKAGE, WSPolicyServiceControlHelperImpl.class.getClassLoader());
        }
        if (this._serviceControl != null) {
            List<WSPolicyServiceControlReference> serviceControlReferences = this._serviceControl.getWSPolicyServiceControlReference();
            int matchDistance = 0;
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            for (WSPolicyServiceControlReference controlRef : serviceControlReferences) {
                String candidateResource = controlRef.getResource();
                if (!candidateResource.endsWith("/")) {
                    candidateResource = candidateResource + "/";
                }
                if (!resource.startsWith(candidateResource)) continue;
                if (resource.length() == candidateResource.length()) {
                    serviceControlReference = controlRef;
                    break;
                }
                if (matchDistance >= candidateResource.length()) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a match. Dunno whether it's best though.", candidateResource);
                }
                serviceControlReference = controlRef;
                matchDistance = candidateResource.length();
            }
        }
        if (serviceControlReference != null) {
            String returnedResource = serviceControlReference.getResource();
            if (!returnedResource.endsWith("/")) {
                returnedResource = returnedResource + "/";
            }
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            if (!this.trueInheritance(resource, returnedResource)) {
                serviceControlReference = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlReferenceInherited", serviceControlReference);
        }
        return serviceControlReference;
    }

    @Override
    public Properties getWSPolicyServiceControlReferenceInheritedProperties(String resource) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlReferenceInheritedProperties", new Object[]{resource, this});
        }
        Properties referenceProperties = new Properties();
        WSPolicyServiceControlReference controlReference = this.getWSPolicyServiceControlReference(resource);
        if (controlReference != null) {
            referenceProperties = this.setupReferenceProperties(controlReference);
            referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "true");
        } else {
            controlReference = this.getWSPolicyServiceControlReferenceInherited(resource);
            if (controlReference != null) {
                referenceProperties = this.setupReferenceProperties(controlReference);
                referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "false");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlReferenceInheritedProperties", referenceProperties);
        }
        return referenceProperties;
    }

    @Override
    public List<WSPolicyServiceControlReference> getWSPolicyServiceControlReferences() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlReferences", this);
        }
        List<WSPolicyServiceControlReference> serviceControlReferences = new ArrayList<WSPolicyServiceControlReference>();
        if (this._serviceControl == null) {
            this._serviceControl = (WSPolicyServiceControl)this.loadData(WSPOLICY_SERVICE_JAXB_PACKAGE, WSPolicyServiceControlHelperImpl.class.getClassLoader());
        }
        if (this._serviceControl != null) {
            serviceControlReferences = this._serviceControl.getWSPolicyServiceControlReference();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlReferences", serviceControlReferences);
        }
        return serviceControlReferences;
    }

    @Override
    public List<Properties> getWSPolicyServiceControlReferencesProperties() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyServiceControlReferencesProperties", this);
        }
        ArrayList<Properties> referencePropertiesList = new ArrayList<Properties>();
        List<WSPolicyServiceControlReference> controlReferences = this.getWSPolicyServiceControlReferences();
        if (controlReferences != null) {
            for (WSPolicyServiceControlReference controlReference : controlReferences) {
                Properties referenceProperties = this.setupReferenceProperties(controlReference);
                referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "true");
                referencePropertiesList.add(referenceProperties);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyServiceControlReferencesProperties", referencePropertiesList);
        }
        return referencePropertiesList;
    }

    private Properties setupReferenceProperties(WSPolicyServiceControlReference controlReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setupReferenceProperties", new Object[]{controlReference, this});
        }
        Properties referenceProperties = new Properties();
        Boolean httpGetEnabled = false;
        if (controlReference.isExportPolicySetConfigurationInWSDL() != null) {
            httpGetEnabled = controlReference.isExportPolicySetConfigurationInWSDL();
        }
        Boolean wsMexEnabled = false;
        String wsMexPS = null;
        String wsMexPSB = null;
        if (controlReference.getWSMexSupported() != null) {
            wsMexEnabled = true;
            WSMexResourceEndpoint wsMexResourceEndpoint = controlReference.getWSMexSupported();
            if (wsMexResourceEndpoint.getPolicySetName() != null) {
                wsMexPS = wsMexResourceEndpoint.getPolicySetName();
            }
            if (wsMexResourceEndpoint.getPolicySetBinding() != null) {
                wsMexPSB = wsMexResourceEndpoint.getPolicySetBinding();
            }
        }
        String shareMethods = null;
        if (httpGetEnabled.booleanValue()) {
            shareMethods = PolicyConstants.HTTP_GET;
        }
        if (wsMexEnabled.booleanValue()) {
            shareMethods = shareMethods == null ? PolicyConstants.WSMEX : shareMethods + " " + PolicyConstants.WSMEX;
        }
        if (shareMethods != null) {
            referenceProperties.setProperty(PolicyConstants.SHARE_POLICY_METHODS, shareMethods);
        }
        if (wsMexPS != null) {
            referenceProperties.setProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME, wsMexPS);
        }
        if (wsMexPSB != null) {
            referenceProperties.setProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING, wsMexPSB);
        }
        referenceProperties.setProperty(PolicyConstants.RESOURCE, controlReference.getResource());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setupReferenceProperties", referenceProperties);
        }
        return referenceProperties;
    }

    @Override
    public void createWSPolicyServiceControl() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSPolicyServiceControl", this);
        }
        if (this._fileName == null) {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSPolicyServiceControl", e);
            }
            throw e;
        }
        this._serviceControl = new WSPolicyServiceControl();
        this._serviceControl.setVersion(PolicyConstants.WSPOLICY_CONTROL_VERSION);
        this.saveData(WSPOLICY_SERVICE_JAXB_PACKAGE, this._serviceControl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSPolicyServiceControl");
        }
    }

    @Override
    public void addWSPolicyServiceControlReference(String resource, boolean exportPSConfigInWSDL, boolean wsMexSupported, String wsMexPolicySetName, String wsMexPolicySetBinding) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSPolicyServiceControlReference", new Object[]{resource, exportPSConfigInWSDL, wsMexSupported, wsMexPolicySetName, wsMexPolicySetBinding, this});
        }
        if (this._serviceControl == null) {
            this._serviceControl = (WSPolicyServiceControl)this.loadData(WSPOLICY_SERVICE_JAXB_PACKAGE, WSPolicyServiceControlHelperImpl.class.getClassLoader());
        }
        if (this._serviceControl != null) {
            WSPolicyServiceControlReference controlReference = this.getWSPolicyServiceControlReference(resource);
            boolean created = false;
            if (controlReference == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "control reference is null, creating one");
                }
                created = true;
                controlReference = new WSPolicyServiceControlReference();
                if (!resource.endsWith("/")) {
                    resource = resource + "/";
                }
                controlReference.setResource(resource);
            }
            controlReference.setWSPolicyAttachmentNamespace("http://www.w3.org/ns/ws-policy");
            controlReference.setExportPolicySetConfigurationInWSDL(exportPSConfigInWSDL);
            WSMexResourceEndpoint wsMexEndpoint = null;
            if (wsMexSupported) {
                wsMexEndpoint = new WSMexResourceEndpoint();
                if (wsMexPolicySetName != null) {
                    wsMexEndpoint.setPolicySetName(wsMexPolicySetName);
                }
                if (wsMexPolicySetBinding != null) {
                    wsMexEndpoint.setPolicySetBinding(wsMexPolicySetBinding);
                }
            }
            controlReference.setWSMexSupported(wsMexEndpoint);
            if (created) {
                this._serviceControl.getWSPolicyServiceControlReference().add(controlReference);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "addWSPolicyServiceControlReference", e);
            }
            throw e;
        }
        this.saveData(WSPOLICY_SERVICE_JAXB_PACKAGE, this._serviceControl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSPolicyServiceControlReference");
        }
    }

    @Override
    public void removeWSPolicyServiceControlReference(String resource) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWSPolicyServiceControlReference", new Object[]{resource, this});
        }
        if (this._serviceControl == null) {
            this._serviceControl = (WSPolicyServiceControl)this.loadData(WSPOLICY_SERVICE_JAXB_PACKAGE, WSPolicyServiceControlHelperImpl.class.getClassLoader());
        }
        if (this._serviceControl != null) {
            WSPolicyServiceControlReference controlReference = this.getWSPolicyServiceControlReference(resource);
            if (controlReference != null) {
                this._serviceControl.getWSPolicyServiceControlReference().remove(controlReference);
                this.saveData(WSPOLICY_SERVICE_JAXB_PACKAGE, this._serviceControl);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeWSPolicyServiceControlReference", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWSPolicyServiceControlReference");
        }
    }

    @Override
    public boolean isPolicySharingEnabled(String resource) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPolicySharingEnabled", resource);
        }
        if (resource == null) {
            resource = "WebService:/";
        }
        boolean policySharing = false;
        WSPolicyServiceControlReference controlReference = this.getWSPolicyServiceControlReferenceInherited(resource);
        if (controlReference != null) {
            if (controlReference.isExportPolicySetConfigurationInWSDL() != null && controlReference.isExportPolicySetConfigurationInWSDL().booleanValue()) {
                policySharing = true;
            } else if (controlReference.getWSMexSupported() != null) {
                policySharing = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPolicySharingEnabled", policySharing);
        }
        return policySharing;
    }
}

