/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.admin.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelper;
import com.ibm.ws.policyset.admin.PolicySetAttachmentHelperFactory;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class ControlHelperImpl {
    private static final TraceComponent tc = Tr.register(ControlHelperImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    protected String _fileName;
    protected String _policySetAttachmentsFileName;
    protected InputStream _inputStream;
    protected InputStream _policySetAttachmentsInputStream;
    protected PolicySetAttachmentHelper _psaHelper = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadData(final String jaxbPackage, final ClassLoader cl) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadData", new Object[]{cl, this});
        }
        Object control = null;
        try {
            if (this._inputStream == null) {
                if (this._fileName != null) {
                    this._inputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public FileInputStream run() throws FileNotFoundException {
                            return new FileInputStream(ControlHelperImpl.this._fileName);
                        }
                    });
                } else {
                    IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{null, this._fileName}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadData", e);
                    }
                    throw e;
                }
            }
            control = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws JAXBException {
                    JAXBContext jc = JAXBContext.newInstance((String)jaxbPackage, (ClassLoader)cl);
                    Unmarshaller um = jc.createUnmarshaller();
                    return um.unmarshal(ControlHelperImpl.this._inputStream);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof JAXBException) {
                FFDCFilter.processException((Throwable)e, this.getClass() + ".loadData", "115", this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadData", e);
                }
                throw (JAXBException)((Object)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "loadData", e);
            }
        }
        finally {
            block22: {
                try {
                    if (this._inputStream != null) {
                        this._inputStream.close();
                    }
                }
                catch (IOException ioe) {
                    FFDCFilter.processException((Throwable)ioe, this.getClass() + ".loadData", "119", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "loadData finally", ioe);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadData", control);
        }
        return control;
    }

    protected void saveData(String jaxbPackage, Object control) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "saveData", new Object[]{jaxbPackage, control, this});
        }
        OutputStream outputStream = null;
        try {
            if (this._fileName == null) {
                IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "saveData", e);
                }
                throw e;
            }
            outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                @Override
                public OutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(ControlHelperImpl.this._fileName);
                }
            });
            JAXBContext jc = JAXBContext.newInstance((String)jaxbPackage);
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(control, outputStream);
            outputStream.close();
        }
        catch (JAXBException e) {
            FFDCFilter.processException((Throwable)e, this.getClass() + ".saveData", "216", this);
            if (outputStream != null) {
                outputStream.close();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "saveData", (Object)e);
            }
            throw e;
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, this.getClass() + ".saveData", "223", this);
            if (outputStream != null) {
                outputStream.close();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "saveData", e);
            }
            throw e;
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, this.getClass() + ".saveData", "173", this);
            FileNotFoundException fnfe = (FileNotFoundException)e.getCause();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "saveData", fnfe);
            }
            throw fnfe;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "saveData");
        }
    }

    protected boolean trueInheritance(String receivedResource, String returnedResource) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "trueInheritance", new Object[]{receivedResource, returnedResource, this});
        }
        boolean inheritance = false;
        if (receivedResource.equals(returnedResource)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit(tc, "No inheritance found", true);
            }
            return true;
        }
        if (this._policySetAttachmentsFileName == null && this._policySetAttachmentsInputStream == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.exit(tc, "Policy set attachment file is null, inheritance is valid by default", true);
            }
            return true;
        }
        PolicyResource returnedPR = new PolicyResource(returnedResource);
        if (returnedPR.getServiceName() != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Inheritance is valid since returned resource contains service");
            }
            inheritance = true;
        } else {
            PolicyResource requestedPR = new PolicyResource(receivedResource);
            String serviceResource = null;
            serviceResource = requestedPR.getEndpointName() != null ? receivedResource.substring(0, receivedResource.indexOf(requestedPR.getEndpointName())) : receivedResource;
            if (this._psaHelper == null) {
                this._psaHelper = this._policySetAttachmentsFileName != null ? PolicySetAttachmentHelperFactory.createHelper(this._policySetAttachmentsFileName) : PolicySetAttachmentHelperFactory.createHelper(this._policySetAttachmentsInputStream);
            }
            if (this._psaHelper.getIdForPolicySetAttachment(serviceResource) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inheritance is invalid since only app level wspolicy exists but service level policy set attachment exists");
                }
                inheritance = false;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Inheritance is valid since only app level wspolicy exists but no service level policy set attachment exists");
                }
                inheritance = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "trueInheritance", inheritance);
        }
        return inheritance;
    }
}

