/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.admin.client.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.wspolicy.PolicyConstants;
import com.ibm.ws.wspolicy.admin.client.WSPolicyClientControlHelper;
import com.ibm.ws.wspolicy.admin.impl.ControlHelperImpl;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.KeyValuePair;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.ProviderPolicyAcquisition;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.WSPolicyClientControl;
import com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol.WSPolicyClientControlReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSPolicyClientControlHelperImpl
extends ControlHelperImpl
implements WSPolicyClientControlHelper {
    private static final TraceComponent tc = Tr.register(WSPolicyClientControlHelperImpl.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final String WSPOLICY_CLIENT_JAXB_PACKAGE = "com.ibm.xmlns.prod.websphere._200709.wspolicyclientcontrol";
    private WSPolicyClientControl _clientControl;

    public WSPolicyClientControlHelperImpl(String fileName, String policySetAttachmentsFileName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPolicyClientControlHelperImpl", new Object[]{fileName, policySetAttachmentsFileName});
        }
        this._fileName = fileName;
        this._policySetAttachmentsFileName = policySetAttachmentsFileName;
    }

    public WSPolicyClientControlHelperImpl(InputStream inputStream, InputStream policySetAttachmentsInputStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "WSPolicyClientControlHelperImpl", new Object[]{inputStream, policySetAttachmentsInputStream});
        }
        this._inputStream = inputStream;
        this._policySetAttachmentsInputStream = policySetAttachmentsInputStream;
    }

    @Override
    public WSPolicyClientControlReference getWSPolicyClientControlReference(String resource) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlReference", new Object[]{resource, this});
        }
        WSPolicyClientControlReference clientControlReference = null;
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl != null) {
            resource = WSPolicyClientControlHelperImpl.generalizeResource(resource);
            List<WSPolicyClientControlReference> clientControlReferences = this._clientControl.getWSPolicyClientControlReference();
            for (WSPolicyClientControlReference controlRef : clientControlReferences) {
                String candidateResource = controlRef.getResource();
                if (!(candidateResource = WSPolicyClientControlHelperImpl.generalizeResource(candidateResource)).equals(resource)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found control reference");
                }
                clientControlReference = controlRef;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlReference", clientControlReference);
        }
        return clientControlReference;
    }

    @Override
    public WSPolicyClientControlReference getWSPolicyClientControlReferenceInherited(String resource) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlReferenceInherited", new Object[]{resource, this});
        }
        WSPolicyClientControlReference clientControlReference = null;
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl != null) {
            List<WSPolicyClientControlReference> clientControlReferences = this._clientControl.getWSPolicyClientControlReference();
            int matchDistance = 0;
            resource = WSPolicyClientControlHelperImpl.generalizeResource(resource);
            for (WSPolicyClientControlReference controlRef : clientControlReferences) {
                String candidateResource = controlRef.getResource();
                if (!resource.startsWith(candidateResource = WSPolicyClientControlHelperImpl.generalizeResource(candidateResource))) continue;
                if (resource.length() == candidateResource.length()) {
                    clientControlReference = controlRef;
                    break;
                }
                if (matchDistance >= candidateResource.length()) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found a match. Dunno whether it's best though.", candidateResource);
                }
                clientControlReference = controlRef;
                matchDistance = candidateResource.length();
            }
        }
        if (clientControlReference != null) {
            String returnedResource = clientControlReference.getResource();
            if (!returnedResource.endsWith("/")) {
                returnedResource = returnedResource + "/";
            }
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            if (!this.trueInheritance(resource, returnedResource)) {
                clientControlReference = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlReferenceInherited", clientControlReference);
        }
        return clientControlReference;
    }

    @Override
    public Properties getWSPolicyClientControlReferenceInheritedProperties(String resource) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlReferenceInheritedProperties", new Object[]{resource, this});
        }
        Properties referenceProperties = new Properties();
        WSPolicyClientControlReference controlReference = this.getWSPolicyClientControlReference(resource);
        if (controlReference != null) {
            referenceProperties = this.setupReferenceProperties(controlReference);
            referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "true");
        } else {
            controlReference = this.getWSPolicyClientControlReferenceInherited(resource);
            if (controlReference != null) {
                referenceProperties = this.setupReferenceProperties(controlReference);
                referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "false");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlReferenceInheritedProperties", referenceProperties);
        }
        return referenceProperties;
    }

    @Override
    public List<WSPolicyClientControlReference> getWSPolicyClientControlReferences() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlReferences", this);
        }
        List<WSPolicyClientControlReference> clientControlReferences = null;
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl != null) {
            clientControlReferences = this._clientControl.getWSPolicyClientControlReference();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlReferences", clientControlReferences);
        }
        return clientControlReferences;
    }

    @Override
    public List<Properties> getWSPolicyClientControlReferencesProperties() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyClientControlReferencesProperties", this);
        }
        ArrayList<Properties> referencePropertiesList = new ArrayList<Properties>();
        List<WSPolicyClientControlReference> controlReferences = this.getWSPolicyClientControlReferences();
        if (controlReferences != null) {
            for (WSPolicyClientControlReference controlReference : controlReferences) {
                Properties referenceProperties = this.setupReferenceProperties(controlReference);
                referenceProperties.setProperty(PolicyConstants.DIRECT_SETTING, "true");
                referencePropertiesList.add(referenceProperties);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyClientControlReferencesProperties", referencePropertiesList);
        }
        return referencePropertiesList;
    }

    private Properties setupReferenceProperties(WSPolicyClientControlReference controlReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setupReferenceProperties", new Object[]{controlReference, this});
        }
        Properties referenceProperties = new Properties();
        List<ProviderPolicyAcquisition> acquisitions = controlReference.getProviderPolicyAcquisition();
        if (acquisitions != null) {
            String acquisitionMethods = "";
            for (ProviderPolicyAcquisition acquisition : acquisitions) {
                if ("com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL".equals(acquisition.getPolicyAcquisitionClass())) {
                    if (acquisitionMethods.length() > 0) {
                        acquisitionMethods = acquisitionMethods + " ";
                    }
                    acquisitionMethods = acquisitionMethods + PolicyConstants.HTTP_GET;
                    if (controlReference.getResource().equals("WebService:/")) continue;
                    String endpointUri = null;
                    List<KeyValuePair> params = acquisition.getParameters();
                    for (KeyValuePair param : params) {
                        if (!"policyURI".equals(param.getKey())) continue;
                        endpointUri = param.getValue();
                        break;
                    }
                    if (endpointUri == null) continue;
                    referenceProperties.setProperty(PolicyConstants.HTTP_GET_TARGET_URI, endpointUri);
                    continue;
                }
                if (!"com.ibm.ws.wspolicy.acquisition.AcquireViaMex".equals(acquisition.getPolicyAcquisitionClass())) continue;
                if (acquisitionMethods.length() > 0) {
                    acquisitionMethods = acquisitionMethods + " ";
                }
                acquisitionMethods = acquisitionMethods + PolicyConstants.WSMEX;
                String mexPolicyName = null;
                String mexBindingName = null;
                List<KeyValuePair> params = acquisition.getParameters();
                for (KeyValuePair param : params) {
                    if ("policyName".equals(param.getKey())) {
                        mexPolicyName = param.getValue();
                    }
                    if ("bindingName".equals(param.getKey())) {
                        mexBindingName = param.getValue();
                    }
                    if (mexPolicyName == null || mexBindingName == null) continue;
                    break;
                }
                if (mexPolicyName != null) {
                    referenceProperties.setProperty(PolicyConstants.WS_MEX_POLICY_SET_NAME, mexPolicyName);
                }
                if (mexBindingName == null) continue;
                referenceProperties.setProperty(PolicyConstants.WS_MEX_POLICY_SET_BINDING, mexBindingName);
            }
            if (acquisitionMethods.length() > 0) {
                referenceProperties.setProperty(PolicyConstants.ACQUIRE_PROVIDER_POLICY_METHODS, acquisitionMethods);
            }
        }
        referenceProperties.setProperty(PolicyConstants.RESOURCE, controlReference.getResource());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setupReferenceProperties", referenceProperties);
        }
        return referenceProperties;
    }

    @Override
    public void createWSPolicyClientControl() throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createWSPolicyClientControl", this);
        }
        if (this._fileName == null) {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "createWSPolicyClientControl", e);
            }
            throw e;
        }
        this._clientControl = new WSPolicyClientControl();
        this._clientControl.setVersion(PolicyConstants.WSPOLICY_CONTROL_VERSION);
        this.saveData(WSPOLICY_CLIENT_JAXB_PACKAGE, this._clientControl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createWSPolicyClientControl");
        }
    }

    @Override
    public void addWSPolicyClientControlReferenceHTTPGET(String resource, String httpGetTargetURI, boolean replaceAcquisition) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSPolicyClientControlReferenceHTTPGET", new Object[]{resource, httpGetTargetURI, replaceAcquisition, this});
        }
        ProviderPolicyAcquisition acquisition = new ProviderPolicyAcquisition();
        acquisition.setPolicyAcquisitionClass("com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL");
        if (httpGetTargetURI != null) {
            KeyValuePair httpURI = new KeyValuePair();
            httpURI.setKey("policyURI");
            httpURI.setValue(httpGetTargetURI);
            acquisition.getParameters().add(httpURI);
        }
        this.addWSPolicyClientControlReference(resource, acquisition, replaceAcquisition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSPolicyClientControlReferenceHTTPGET");
        }
    }

    @Override
    public void addWSPolicyClientControlReferenceWSMex11(String resource, String policySetName, String policySetBinding, boolean replaceAcquisition) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSPolicyClientControlReferenceWSMex11", new Object[]{resource, policySetName, policySetBinding, replaceAcquisition, this});
        }
        ProviderPolicyAcquisition acquisition = new ProviderPolicyAcquisition();
        acquisition.setPolicyAcquisitionClass("com.ibm.ws.wspolicy.acquisition.AcquireViaMex");
        if (policySetName != null) {
            KeyValuePair policyName = new KeyValuePair();
            policyName.setKey("policyName");
            policyName.setValue(policySetName);
            acquisition.getParameters().add(policyName);
        }
        if (policySetBinding != null) {
            KeyValuePair bindingName = new KeyValuePair();
            bindingName.setKey("bindingName");
            bindingName.setValue(policySetBinding);
            acquisition.getParameters().add(bindingName);
        }
        this.addWSPolicyClientControlReference(resource, acquisition, replaceAcquisition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSPolicyClientControlReferenceWSMex11");
        }
    }

    private void addWSPolicyClientControlReference(String resource, ProviderPolicyAcquisition acquisition, boolean replaceAcquisition) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addWSPolicyClientControlReference", new Object[]{resource, acquisition, replaceAcquisition, this});
        }
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl != null) {
            WSPolicyClientControlReference controlReference = this.getWSPolicyClientControlReference(resource);
            boolean created = false;
            if (controlReference == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "control reference is null, creating one");
                }
                created = true;
                controlReference = new WSPolicyClientControlReference();
                if (!resource.endsWith("/")) {
                    resource = resource + "/";
                }
                controlReference.setResource(resource);
            }
            if (acquisition != null) {
                if (replaceAcquisition) {
                    controlReference.getProviderPolicyAcquisition().clear();
                }
                controlReference.getProviderPolicyAcquisition().add(acquisition);
            }
            if (created) {
                this._clientControl.getWSPolicyClientControlReference().add(controlReference);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{null, this._fileName}, "CWPOL0030"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "addWSPolicyClientControlReference", e);
            }
            throw e;
        }
        this.saveData(WSPOLICY_CLIENT_JAXB_PACKAGE, this._clientControl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addWSPolicyClientControlReference");
        }
    }

    @Override
    public void removeWSPolicyClientControlReference(String resource) throws JAXBException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeWSPolicyClientControlReference", new Object[]{resource, this});
        }
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl != null) {
            WSPolicyClientControlReference controlReference = this.getWSPolicyClientControlReference(resource);
            if (controlReference != null) {
                this._clientControl.getWSPolicyClientControlReference().remove(controlReference);
                this.saveData(WSPOLICY_CLIENT_JAXB_PACKAGE, this._clientControl);
            }
        } else {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeWSPolicyClientControlReference", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeWSPolicyClientControlReference");
        }
    }

    @Override
    public boolean isProviderPolicyEnabled() throws JAXBException, IOException {
        List<WSPolicyClientControlReference> references;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProviderPolicyEnabled");
        }
        if ((references = this.getWSPolicyClientControlReferences()) != null) {
            for (WSPolicyClientControlReference reference : references) {
                List<ProviderPolicyAcquisition> ppAcqs = reference.getProviderPolicyAcquisition();
                if (ppAcqs == null) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isProviderPolicyEnabled", true);
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderPolicyEnabled", false);
        }
        return false;
    }

    @Override
    public boolean isProviderPolicyEnabled(String resource) throws Exception {
        List<ProviderPolicyAcquisition> ppAcqs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProviderPolicyEnabled", resource);
        }
        if (resource == null) {
            resource = "WebService:/";
        }
        boolean providerEnabled = false;
        WSPolicyClientControlReference reference = this.getWSPolicyClientControlReferenceInherited(resource);
        if (reference != null && (ppAcqs = reference.getProviderPolicyAcquisition()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isProviderPolicyEnabled", true);
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderPolicyEnabled", providerEnabled);
        }
        return providerEnabled;
    }

    @Override
    public String getWSDLFileLocation(String resource) throws Exception {
        List<ProviderPolicyAcquisition> ppAcqs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSDLFileLocation", resource);
        }
        if (resource == null) {
            resource = "WebService:/";
        }
        String fileLocation = null;
        WSPolicyClientControlReference reference = this.getWSPolicyClientControlReferenceInherited(resource);
        if (reference != null && (ppAcqs = reference.getProviderPolicyAcquisition()) != null) {
            for (ProviderPolicyAcquisition ppAcq : ppAcqs) {
                String acquireClass;
                if (ppAcq == null || !(acquireClass = ppAcq.getPolicyAcquisitionClass()).equals("com.ibm.ws.wspolicy.acquisition.AcquireViaFile")) continue;
                List<KeyValuePair> params = ppAcq.getParameters();
                for (KeyValuePair param : params) {
                    if (!"policyURI".equals(param.getKey())) continue;
                    fileLocation = param.getValue();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getWSDLFileLocation", fileLocation);
                    }
                    return fileLocation;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSDLFileLocation", fileLocation);
        }
        return fileLocation;
    }

    @Override
    public boolean isProviderPolicyAcquisitionViaMex(String resource) throws Exception {
        List<ProviderPolicyAcquisition> ppAcqs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProviderPolicyAcquisitionViaMex", resource);
        }
        if (resource == null) {
            resource = "WebService:/";
        }
        boolean isMex = false;
        WSPolicyClientControlReference reference = this.getWSPolicyClientControlReferenceInherited(resource);
        if (reference != null && (ppAcqs = reference.getProviderPolicyAcquisition()) != null) {
            for (ProviderPolicyAcquisition ppAcq : ppAcqs) {
                String acquireClass;
                if (ppAcq == null || !(acquireClass = ppAcq.getPolicyAcquisitionClass()).equals("com.ibm.ws.wspolicy.acquisition.AcquireViaMex")) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isProviderPolicyAcquisitionViaMex", true);
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderPolicyAcquisitionViaMex", isMex);
        }
        return isMex;
    }

    @Override
    public boolean isProviderPolicyAcquisitionViaHTTPGET(String resource) throws Exception {
        List<ProviderPolicyAcquisition> ppAcqs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isProviderPolicyAcquisitionViaHTTPGET", resource);
        }
        if (resource == null) {
            resource = "WebService:/";
        }
        boolean isWSDL = false;
        WSPolicyClientControlReference reference = this.getWSPolicyClientControlReferenceInherited(resource);
        if (reference != null && (ppAcqs = reference.getProviderPolicyAcquisition()) != null) {
            for (ProviderPolicyAcquisition ppAcq : ppAcqs) {
                String acquireClass;
                if (ppAcq == null || !(acquireClass = ppAcq.getPolicyAcquisitionClass()).equals("com.ibm.ws.wspolicy.acquisition.AcquireViaQWSDL")) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isProviderPolicyAcquisitionViaHTTPGET", true);
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isProviderPolicyAcquisitionViaHTTPGET", isWSDL);
        }
        return isWSDL;
    }

    @Override
    public void refreshClientControlReference(String resource) throws JAXBException, IOException, DatatypeConfigurationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshClientControlReference", resource);
        }
        if (this._clientControl == null) {
            this._clientControl = (WSPolicyClientControl)this.loadData(WSPOLICY_CLIENT_JAXB_PACKAGE, WSPolicyClientControlHelperImpl.class.getClassLoader());
        }
        if (this._clientControl == null) {
            IllegalArgumentException e = new IllegalArgumentException(nls.getFormattedMessage("CWPOL0030", new Object[]{this._fileName}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "addWSPolicyClientControlReference", e);
            }
            throw e;
        }
        WSPolicyClientControlReference controlReference = this.getWSPolicyClientControlReference(resource);
        GregorianCalendar gregorianCal = new GregorianCalendar();
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCal);
        controlReference.setLastRefreshRequested(calendar);
        this.saveData(WSPOLICY_CLIENT_JAXB_PACKAGE, this._clientControl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshClientControlReference");
        }
    }

    private static String generalizeResource(String resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generalizeResource", resource);
        }
        if (!resource.endsWith("/")) {
            resource = resource + "/";
        }
        String updatedResource = resource;
        PolicyResource policyResource = new PolicyResource(resource);
        String moduleName = policyResource.getModuleName();
        if (moduleName != null) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(resource.substring(0, resource.indexOf(moduleName)));
            strBuf.append(resource.substring(resource.indexOf(moduleName) + moduleName.length() + 1));
            updatedResource = strBuf.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resource contains module name");
                Tr.debug(tc, "Resource without moduleName is: " + updatedResource);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generalizeResource", updatedResource);
        }
        return updatedResource;
    }

    @Override
    public String getFileName() {
        return this._fileName;
    }

    @Override
    public void setLocale(Locale locale) {
    }
}

