/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.acquisition;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.wsdl.xml.WSDLLocator;
import org.apache.axiom.om.util.Base64;
import org.xml.sax.InputSource;

public class PolicyAwareWSDLLocator
implements WSDLLocator {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyAwareWSDLLocator.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    URI _addressURI;
    String _lastImportLocation = "";
    String _baseURLString = "";
    Properties _httpProps = null;

    public PolicyAwareWSDLLocator(String address, Properties httpProps) throws URISyntaxException {
        this._httpProps = httpProps;
        this._addressURI = new URI(address);
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "close called");
        }
    }

    public InputSource getBaseInputSource() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getBaseInputSourcee called");
        }
        URI uri = null;
        try {
            uri = this._addressURI;
            URLConnection urlConnection = this.getURLConnectionForAddress(uri);
            Object insObj = urlConnection.getContent();
            URL theURLused = urlConnection.getURL();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "the URL used from connection is ", theURLused);
            }
            this._baseURLString = theURLused.toString();
            if (!(insObj instanceof InputStream)) {
                throw new WSPolicyInternalException("URL connection did not return an InputStream");
            }
            InputStream ins = (InputStream)insObj;
            InputSource inputSource = new InputSource(ins);
            return inputSource;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getBaseURI exception", e);
            }
            return null;
        }
    }

    public String getBaseURI() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getBaseURI called", new Object[]{this._baseURLString, this._addressURI});
        }
        return this._baseURLString;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getImportInputSource called", new Object[]{parentLocation, importLocation});
        }
        try {
            URI parentURI = new URI(parentLocation);
            URI importURI = parentURI.resolve(importLocation);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "the importURI calculated is ", importURI.toString());
            }
            URLConnection urlConnection = this.getURLConnectionForAddress(importURI);
            Object insObj = urlConnection.getContent();
            URL theURLused = urlConnection.getURL();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "the URL used from connection is ", theURLused);
            }
            this._lastImportLocation = theURLused.toString();
            if (!(insObj instanceof InputStream)) {
                throw new WSPolicyInternalException("URL connection did not return an InputStream");
            }
            InputStream ins = (InputStream)insObj;
            InputSource inputSource = new InputSource(ins);
            return inputSource;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getBaseURI exception", e);
            }
            return null;
        }
    }

    public String getLatestImportURI() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getLatestImportURI called", this._lastImportLocation);
        }
        return this._lastImportLocation;
    }

    private URLConnection getURLConnectionForAddress(URI address) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getURLConnectionForAddress called", new Object[]{this._httpProps, address});
        }
        if (this._httpProps == null) {
            return address.toURL().openConnection();
        }
        URLConnection urlConnection = null;
        String userid = this._httpProps.getProperty("outRequestBasicAuth:userid");
        String password = this._httpProps.getProperty("outRequestBasicAuth:password");
        String proxyHost = this._httpProps.getProperty("outRequestProxy:host");
        String proxyPort = this._httpProps.getProperty("outRequestProxy:port");
        String proxyUser = this._httpProps.getProperty("outRequestProxy:userid");
        String proxyPassword = this._httpProps.getProperty("outRequestProxy:password");
        if (proxyHost != null && proxyPort != null && proxyHost.trim().length() > 0 && proxyPort.trim().length() > 0) {
            try {
                int portInt = Integer.parseInt(proxyPort);
                InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, portInt);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getURLConnectionForAddress using proxy ", proxy);
                }
                urlConnection = address.toURL().openConnection(proxy);
                if (proxyUser != null && proxyPassword != null && !"".equals(proxyUser) && !"".equals(proxyPassword)) {
                    StringBuffer basicAuthData = new StringBuffer(proxyUser);
                    basicAuthData.append(":").append(proxyPassword);
                    int lastindex = basicAuthData.length();
                    basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
                    urlConnection.addRequestProperty("Proxy-Authorization", basicAuthData.insert(0, "Basic ").toString());
                }
            }
            catch (NumberFormatException e) {
                urlConnection = address.toURL().openConnection();
            }
        } else {
            urlConnection = address.toURL().openConnection();
        }
        if (userid != null && password != null && !"".equals(userid) && !"".equals(password)) {
            StringBuffer basicAuthData = new StringBuffer(userid);
            basicAuthData.append(":").append(password);
            int lastindex = basicAuthData.length();
            basicAuthData.replace(0, lastindex, Base64.encode(basicAuthData.toString().getBytes()));
            urlConnection.addRequestProperty("Authorization", basicAuthData.insert(0, "Basic ").toString());
        }
        return urlConnection;
    }
}

