/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.acquisition;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.WSPolicyInvalidMexConfig;
import com.ibm.ws.wspolicy.acquisition.PolicyAwareWSDLLocator;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcquireViaQWSDL
implements PolicyProvider {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AcquireViaQWSDL.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    @Override
    public Definition getProviderPolicy(Map<String, ?> parameters) throws WSPolicyException {
        Definition result;
        Properties httpProps;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderPolicy");
        }
        String suffix = "";
        String endpointURI = (String)parameters.get("policyURI");
        if (endpointURI == null) {
            MessageContext mc = (MessageContext)parameters.get("messageContext");
            EndpointReference epr = mc.getTo();
            endpointURI = epr != null ? epr.getAddress() : (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
            if (endpointURI == null) {
                throw new WSPolicyInternalException("Unable to determine endpoint for qwsdl request");
            }
            suffix = "?WSDL";
            String overrideSuffix = (String)parameters.get("overrideSuffix");
            if (overrideSuffix != null) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getProviderPolicy overrideSuffix '" + overrideSuffix + "'");
                }
                suffix = overrideSuffix;
            }
        }
        String wsdlAddr = endpointURI.trim() + suffix;
        try {
            httpProps = this.getHttpProperties(parameters);
        }
        catch (WSPolicyInternalException e) {
            String controlPath;
            Object mcObj = parameters.get("messageContext");
            if (mcObj != null && mcObj instanceof MessageContext) {
                MessageContext mc = (MessageContext)mcObj;
                controlPath = this.getBindingRootDirForApplication(mc.getAxisService()) + "/wsPolicyClientControl.xml";
            } else {
                controlPath = null;
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0030", new Object[]{wsdlAddr, controlPath}, null), e);
        }
        try {
            result = this.aquireViaHTTP(wsdlAddr, httpProps);
        }
        catch (WSDLException e) {
            if (e.getCause() instanceof WSPolicyException) {
                throw (WSPolicyException)e.getCause();
            }
            if ("OTHER_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0000", new Object[]{wsdlAddr, e}, null), e);
            }
            if ("CONFIGURATION_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyInternalException(e);
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlAddr}, null), e);
        }
        catch (URISyntaxException e) {
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlAddr}, null), e);
        }
        catch (Exception e) {
            throw new WSPolicyInternalException(e);
        }
        return result;
    }

    private Properties getHttpProperties(Map<String, ?> parameters) throws WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHttpProperties");
        }
        String policySetName = (String)parameters.get("policyName");
        String bindingName = (String)parameters.get("bindingName");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getHttpProperties pset/binding ", new Object[]{policySetName, bindingName});
        }
        PolicySetConfiguration psConfig = null;
        Object mcObj = parameters.get("messageContext");
        if (mcObj == null || !(mcObj instanceof MessageContext)) {
            return null;
        }
        MessageContext MC = (MessageContext)mcObj;
        if (policySetName == null) {
            AxisOperation axisOp = MC.getAxisOperation();
            if (axisOp == null) {
                return null;
            }
            Parameter param = axisOp.getParameter("WASAxis2PolicySet");
            if (param == null) {
                return null;
            }
            Object psConfigObj = param.getValue();
            if (psConfigObj == null || !(psConfigObj instanceof PolicySetConfiguration)) {
                return null;
            }
            psConfig = (PolicySetConfiguration)psConfigObj;
        } else {
            AxisService as = MC.getAxisService();
            ClassLoader appCL = this.getClass().getClassLoader();
            ClassLoader systemCL = this.getClass().getClassLoader();
            String rootDir = this.getBindingRootDirForApplication(as);
            boolean isClient = true;
            try {
                psConfig = WSPolicyInternalFactory.singleton.getWSPolicyConfigPluginHelper().resolvePolicySetAndBindingForMex(policySetName, bindingName, appCL, systemCL, true, rootDir);
            }
            catch (WSPolicyInvalidMexConfig wspimc) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getHttpProperties", wspimc);
                }
                throw new WSPolicyInternalException("Unable to process custom policySet/binding for http get");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getHttpProperties post getPS ", psConfig);
            }
        }
        Properties result = this.obtainHttpFromPolicySet(psConfig);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHttpProperties", new Object[]{result});
        }
        return result;
    }

    private Properties obtainHttpFromPolicySet(PolicySetConfiguration psConfig) {
        Properties result = null;
        Object httpObj = psConfig.getPolicyTypeBinding("HTTP_BINDING");
        if (httpObj == null || !(httpObj instanceof Properties)) {
            return null;
        }
        result = (Properties)httpObj;
        return result;
    }

    private String getBindingRootDirForApplication(AxisService as) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBindingRootDirForApplication", new Object[]{as});
        }
        Parameter appNameParam = as.getAxisConfiguration().getParameter("ApplicationName");
        String appName = (String)appNameParam.getValue();
        FileLocator fileLoc = FileLocatorFactory.getFileLocator();
        String fileToFind = "wsPolicyClientControl.xml";
        String _applicationPath = fileLoc.getAttachmentPath(appName, "wsPolicyClientControl.xml");
        String rootDir = _applicationPath.substring(0, _applicationPath.length() - "wsPolicyClientControl.xml".length() - 1);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBindingRootDirForApplication", rootDir);
        }
        return rootDir;
    }

    private Definition aquireViaHTTP(final String wsdlAddr, final Properties httpProps) throws WSDLException, WSPolicyInternalException, URISyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "aquireViaHTTP");
        }
        Definition def = null;
        try {
            WSDLReader wsdlReader = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLReader>(){

                @Override
                public WSDLReader run() throws WSDLException {
                    return WSDLFactory.newInstance().newWSDLReader();
                }
            });
            wsdlReader.setFeature("javax.wsdl.verbose", TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled());
            final WSDLReader wsdlReaderFinal = wsdlReader;
            def = AccessController.doPrivileged(new PrivilegedExceptionAction<Definition>(){

                @Override
                public Definition run() throws WSDLException, URISyntaxException {
                    PolicyAwareWSDLLocator wsdlLoc = new PolicyAwareWSDLLocator(wsdlAddr, httpProps);
                    return wsdlReaderFinal.readWSDL(wsdlLoc);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof WSDLException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "aquireViaHTTP", e);
                }
                throw (WSDLException)e;
            }
            if (e instanceof URISyntaxException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "aquireViaHTTP", e);
                }
                throw (URISyntaxException)e;
            }
            if (e instanceof RuntimeException) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "aquireViaHTTP", e);
                }
                throw (RuntimeException)e;
            }
            e = new WSPolicyInternalException(e);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "aquireViaHTTP", e);
            }
            throw (WSPolicyInternalException)e;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "aquireViaHTTP", def);
        }
        return def;
    }
}

