/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.acquisition;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.FileLocator;
import com.ibm.ws.policyset.runtime.FileLocatorFactory;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationImpl;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.WSPolicyInternalFactory;
import com.ibm.ws.wspolicy.WSPolicyInvalidMexConfig;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import com.ibm.ws.wspolicy.policyset.PolicySetConfigurationWrapper;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.dom.factory.OMDOMFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.client.MexClient;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.TransportUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcquireViaMex
implements PolicyProvider {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AcquireViaMex.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    @Override
    public Definition getProviderPolicy(Map<String, ?> parameters) throws WSPolicyException {
        Definition def;
        WSDLReader wsdlReader;
        String nsPrefix;
        String nsURI;
        String nsPrefix2;
        OMNamespace omns;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderPolicy", new Object[]{this});
        }
        MessageContext mc = (MessageContext)parameters.get("messageContext");
        String policySetName = (String)parameters.get("policyName");
        String bindingName = (String)parameters.get("bindingName");
        String addToOpString = (String)parameters.get("addToOperation");
        String addToSvcString = (String)parameters.get("addToService");
        boolean addToOp = true;
        boolean addToSvc = false;
        if (addToOpString != null) {
            addToOp = addToOpString.equalsIgnoreCase("true");
        }
        if (addToSvcString != null) {
            addToSvc = addToSvcString.equalsIgnoreCase("true");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getProviderPolicy using policySet::bindingName :" + policySetName + "::" + bindingName + ": add to op:svc " + addToOp + ":" + addToSvc);
        }
        String address = null;
        EndpointReference epr = mc.getTo();
        if (epr == null) {
            address = (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
            if (address == null) {
                throw new WSPolicyInternalException("Cannot obtain target address");
            }
            epr = new EndpointReference(address);
        } else {
            address = epr.getAddress();
            if (address == null || address.equals("")) {
                address = (String)mc.getProperty("javax.xml.ws.service.endpoint.address");
                if (address == null) {
                    throw new WSPolicyInternalException("Cannot obtain target address");
                }
                epr.setAddress(address);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getProviderPolicy " + (mc.getAxisService() == null ? "(null)" : mc.getAxisService()) + " " + (mc.getAxisOperation().getName() == null ? "(null)" : mc.getAxisOperation().getName()));
        }
        AxisOperation orig_op = mc.getOperationContext().getAxisOperation();
        Parameter orig_param = orig_op.getParameter("WASAxis2PolicySet");
        PolicySetConfigurationWrapper pscw = (PolicySetConfigurationWrapper)orig_param.getValue();
        ConfigurationContext ctx = null;
        ctx = mc.getConfigurationContext();
        OMElement method = null;
        MexClient serviceClient = null;
        try {
            serviceClient = new MexClient(ctx, null);
            serviceClient.getAxisService().addParameter("Sandesha2UnreliableMessage", Boolean.TRUE.toString());
            Options options = new Options();
            serviceClient.setOptions(options);
            options.setTo(epr);
            options.setAction("http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request");
            options.setProperty("disableAddressingForOutMessages", Boolean.FALSE);
            PolicySetConfiguration psc = this.addPolicyToMexOp(serviceClient.getAxisService(), policySetName, bindingName, addToOp, addToSvc);
            this.cloneTransportConfigForMex(pscw, psc);
            method = serviceClient.setupGetMetadataRequest("http://schemas.xmlsoap.org/wsdl/", null);
        }
        catch (AxisFault af) {
            throw new WSPolicyInternalException(af);
        }
        catch (WSPolicyInvalidMexConfig imc) {
            String nlsStr = null;
            int partType = imc.getInvalidPartType();
            switch (partType) {
                case 1: {
                    nlsStr = nls.getFormattedMessage("CWPOL0010", new Object[]{address, imc.getPolicySetName()}, null);
                    break;
                }
                case 2: {
                    nlsStr = nls.getFormattedMessage("CWPOL0011", new Object[]{address, imc.getBindingsName()}, null);
                    break;
                }
                default: {
                    nlsStr = nls.getFormattedMessage("CWPOL0012", new Object[]{address, imc.getPolicySetName(), imc.getBindingsName()}, null);
                }
            }
            throw new WSPolicyFormattedException(nlsStr, imc);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getProviderPolicy issuing mex request.. ");
        }
        OMElement mexMetadata = null;
        try {
            mexMetadata = serviceClient.sendReceive(method);
        }
        catch (AxisFault af) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getProviderPolicy", af);
            }
            FFDCFilter.processException((Throwable)af, "com.ibm.ws.wspolicy.acquisition.AcquireViaMex.getProviderPolicy", "144", this);
            String eaddress = epr == null ? "(null epr)" : epr.getAddress();
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0002", new Object[]{eaddress, af}, null), af);
        }
        finally {
            try {
                MessageContext responseMC;
                if (serviceClient.getServiceContext().getLastOperationContext() != null && (responseMC = serviceClient.getServiceContext().getLastOperationContext().getMessageContext("In")) != null) {
                    TransportUtils.detachInputStream(responseMC);
                }
            }
            catch (AxisFault af) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "getProviderPolicy", af);
                }
                FFDCFilter.processException((Throwable)af, "com.ibm.ws.wspolicy.acquisition.AcquireViaMex.getProviderPolicy", "214", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getProviderPolicy after mex request.. ");
        }
        if (mexMetadata == null) {
            String eaddress = epr == null ? "(null epr)" : epr.getAddress();
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0002", new Object[]{eaddress, null}, null), null);
        }
        OMElement mexMetadataSection = mexMetadata.getFirstElement();
        if (mexMetadataSection == null) {
            String eaddress = epr == null ? "(null epr)" : epr.getAddress();
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0002", new Object[]{eaddress, null}, null), null);
        }
        OMElement wsdlDefinitions = mexMetadataSection.getFirstElement();
        if (wsdlDefinitions == null) {
            String eaddress = epr == null ? "(null epr)" : epr.getAddress();
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0002", new Object[]{eaddress, null}, null), null);
        }
        HashMap<String, String> namespaces = new HashMap<String, String>();
        Iterator iter = mexMetadata.getAllDeclaredNamespaces();
        while (iter.hasNext()) {
            omns = (OMNamespace)iter.next();
            nsPrefix2 = omns.getPrefix();
            nsURI = omns.getNamespaceURI();
            namespaces.put(nsPrefix2, nsURI);
        }
        iter = mexMetadataSection.getAllDeclaredNamespaces();
        while (iter.hasNext()) {
            omns = (OMNamespace)iter.next();
            nsPrefix2 = omns.getPrefix();
            nsURI = omns.getNamespaceURI();
            namespaces.put(nsPrefix2, nsURI);
        }
        HashMap<String, String> namespacesinwsdl = new HashMap<String, String>();
        Iterator iter2 = wsdlDefinitions.getAllDeclaredNamespaces();
        while (iter2.hasNext()) {
            OMNamespace omns2 = (OMNamespace)iter2.next();
            nsPrefix = omns2.getPrefix();
            String nsURI2 = omns2.getNamespaceURI();
            namespacesinwsdl.put(nsPrefix, nsURI2);
        }
        for (Map.Entry entry : namespaces.entrySet()) {
            nsPrefix = (String)entry.getKey();
            if (namespacesinwsdl.get(nsPrefix) != null) continue;
            wsdlDefinitions.declareNamespace((String)entry.getValue(), nsPrefix);
        }
        Iterator typesIter = wsdlDefinitions.getChildrenWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "types"));
        while (typesIter.hasNext()) {
            Object obj = typesIter.next();
            if (!(obj instanceof OMElement)) continue;
            OMElement type = (OMElement)obj;
            Iterator typeChildIter = type.getChildren();
            while (typeChildIter.hasNext()) {
                typeChildIter.next();
                typeChildIter.remove();
            }
        }
        Element documentElement = (Element)((Object)ElementHelper.importOMElement(wsdlDefinitions, new OMDOMFactory()));
        try {
            wsdlReader = WSDLFactory.newInstance().newWSDLReader();
        }
        catch (WSDLException wsdle) {
            throw new WSPolicyInternalException(wsdle);
        }
        wsdlReader.setFeature("javax.wsdl.verbose", TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled());
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(documentElement.toString().getBytes());
            InputSource is = new InputSource(bais);
            String wsdlAddr = address.trim() + (address.trim().toLowerCase().endsWith("?wsdl") ? "" : "?wsdl");
            def = wsdlReader.readWSDL(wsdlAddr, is);
        }
        catch (WSDLException e) {
            if (e.getCause() instanceof WSPolicyException) {
                throw (WSPolicyException)e.getCause();
            }
            if ("OTHER_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0002", new Object[]{address, e}, null), e);
            }
            if ("CONFIGURATION_ERROR".equals(e.getFaultCode())) {
                throw new WSPolicyInternalException(e);
            }
            throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{address}, null), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderPolicy", def);
        }
        return def;
    }

    private PolicySetConfiguration addPolicyToMexOp(AxisService as, String policyName, String bindingName, boolean addToOp, boolean addToSvc) throws WSPolicyInvalidMexConfig, AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addPolicyToMexOp ", new Object[]{as, (policyName == null ? "(null)" : policyName) + " " + (bindingName == null ? "(null)" : bindingName)});
        }
        PolicySetConfiguration psc = null;
        if (policyName != null) {
            ClassLoader appCL = this.getClass().getClassLoader();
            ClassLoader systemCL = this.getClass().getClassLoader();
            String rootDir = this.getBindingRootDirForApplication(as);
            boolean isClient = true;
            psc = WSPolicyInternalFactory.singleton.getWSPolicyConfigPluginHelper().resolvePolicySetAndBindingForMex(policyName, bindingName, appCL, systemCL, true, rootDir);
        } else {
            psc = new PolicySetConfigurationImpl();
        }
        if (!addToOp && !addToSvc) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addPolicyToMexOp configured not to add.");
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addPolicyToMexOp", psc);
            }
            return psc;
        }
        if (addToSvc) {
            Parameter svc_param = new Parameter();
            svc_param.setName("WASAxis2PolicySet");
            svc_param.setValue(psc);
            as.addParameter(svc_param);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addPolicyToMexOp found & configured policy for anonOutInOp's service");
            }
        }
        if (addToOp) {
            Iterator iter = as.getOperations();
            while (iter.hasNext()) {
                AxisOperation ao = (AxisOperation)iter.next();
                if (!ao.getName().toString().equals(MexClient.ANON_OUT_IN_OP.toString())) continue;
                AxisOperation mex_op = ao;
                Parameter mex_param = new Parameter();
                mex_param.setName("WASAxis2PolicySet");
                mex_param.setValue(psc);
                mex_op.addParameter(mex_param);
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "addPolicyToMexOp found & configured policy for anonOutInOp");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPolicyToMexOp", psc);
        }
        return psc;
    }

    private void cloneTransportConfigForMex(PolicySetConfigurationWrapper pscw, PolicySetConfiguration psConfig) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cloneTransportConfigForMex");
        }
        if (pscw != null && psConfig != null) {
            Properties typeSSL = (Properties)pscw.getPolicyTypeConfiguration("SSL_POLICY");
            Properties bindSSL = (Properties)pscw.getPolicyTypeBinding("SSL_BINDING");
            psConfig.setPolicyTypeConfiguration("SSL_POLICY", typeSSL);
            psConfig.setPolicyTypeBinding("SSL_BINDING", bindSSL);
            Properties typeHTTP = (Properties)pscw.getPolicyTypeConfiguration("HTTP_POLICY");
            Properties bindHTTP = (Properties)pscw.getPolicyTypeBinding("HTTP_BINDING");
            psConfig.setPolicyTypeConfiguration("HTTP_POLICY", typeHTTP);
            psConfig.setPolicyTypeBinding("HTTP_BINDING", bindHTTP);
        } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addPolicyToMexOp called with a null parm, ignoring.");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPolicyToMexOp");
        }
    }

    private String getBindingRootDirForApplication(AxisService as) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBindingRootDirForApplication", new Object[]{as});
        }
        Parameter appNameParam = as.getAxisConfiguration().getParameter("ApplicationName");
        String appName = (String)appNameParam.getValue();
        FileLocator fileLoc = FileLocatorFactory.getFileLocator();
        String fileToFind = "wsPolicyClientControl.xml";
        String _applicationPath = fileLoc.getAttachmentPath(appName, "wsPolicyClientControl.xml");
        String rootDir = _applicationPath.substring(0, _applicationPath.length() - "wsPolicyClientControl.xml".length() - 1);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBindingRootDirForApplication", rootDir);
        }
        return rootDir;
    }
}

