/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy.acquisition;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wspolicy.WSPolicyException;
import com.ibm.ws.wspolicy.WSPolicyFormattedException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.acquisition.PolicyProvider;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcquireViaFile
implements PolicyProvider {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AcquireViaFile.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wspolicy.resources.CWPOLMessages");

    @Override
    public Definition getProviderPolicy(Map<String, ?> parameters) throws WSPolicyException {
        Definition definition;
        String wsdlLocation;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getProviderPolicy", new Object[]{this, parameters});
        }
        if ((wsdlLocation = (String)parameters.get("policyURI")) != null && wsdlLocation.length() > 0) {
            try {
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = factory.newWSDLReader();
                wsdlReader.setFeature("javax.wsdl.verbose", TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled());
                definition = wsdlReader.readWSDL(wsdlLocation);
            }
            catch (WSDLException we) {
                FFDCFilter.processException((Throwable)we, this.getClass() + ".readDefinition", "45", this);
                if (we.getCause() instanceof WSPolicyException) {
                    throw (WSPolicyException)we.getCause();
                }
                if ("OTHER_ERROR".equals(we.getFaultCode())) {
                    throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0000", new Object[]{wsdlLocation}, null), we);
                }
                if ("CONFIGURATION_ERROR".equals(we.getFaultCode())) {
                    throw new WSPolicyInternalException(we);
                }
                throw new WSPolicyFormattedException(nls.getFormattedMessage("CWPOL0005", new Object[]{wsdlLocation}, null), we);
            }
        } else {
            definition = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getProviderPolicy", definition);
        }
        return definition;
    }
}

