/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wspolicy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wspolicy.UnsupportedNamespaceException;
import com.ibm.ws.wspolicy.UnsupportedPolicyElementException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.wspolicy.PolicyReferenceException;
import com.ibm.wspolicy.datamodel.Policy;
import com.ibm.wspolicy.factory.WSPolicyFactory;
import com.ibm.wspolicy.processor.PolicyProcessor;
import com.ibm.wspolicy.xml.ElementReaderException;
import com.ibm.wspolicy.xml.ElementWriter;
import com.ibm.wspolicy.xml.ElementWriterException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class PolicyHolder {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyHolder.class, "WS-Policy", "com.ibm.ws.wspolicy.resources.CWPOLMessages");
    private Policy _input = null;
    private Policy _output = null;
    private Policy _main = null;
    private WSPolicyFactory _wspf;

    public PolicyHolder(WSPolicyFactory wspf) {
        this._wspf = wspf;
    }

    public PolicyHolder(WSPolicyFactory wspf, PolicyInputStreamHolder policyStream) throws ElementReaderException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "PolicyHolder", new Object[]{policyStream});
        }
        this._wspf = wspf;
        if (policyStream != null) {
            InputStream ins = policyStream.getMain();
            this._main = this.inputStreamToPolicy(ins);
            ins = policyStream.getInput();
            this._input = this.inputStreamToPolicy(ins);
            ins = policyStream.getOutput();
            this._output = this.inputStreamToPolicy(ins);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "PolicyHolder");
        }
    }

    public Policy getInput() {
        return this._input;
    }

    public void setInput(Policy input) {
        this._input = input;
    }

    public Policy getMain() {
        return this._main;
    }

    public void setMain(Policy neutral) {
        this._main = neutral;
    }

    public Policy getOutput() {
        return this._output;
    }

    public void setOutput(Policy output) {
        this._output = output;
    }

    public boolean isAllEmpty() throws PolicyReferenceException {
        PolicyProcessor ap = this._wspf.createWSPolicyProcessor();
        boolean result = false;
        if (ap.isPolicyEmpty(this._input) && ap.isPolicyEmpty(this._main) && ap.isPolicyEmpty(this._output)) {
            result = true;
        }
        return result;
    }

    private Policy inputStreamToPolicy(InputStream polIns) throws ElementReaderException, UnsupportedPolicyElementException, UnsupportedNamespaceException, PolicyReferenceException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "inputStreamToPolicy", new Object[]{polIns});
        }
        Policy policy = null;
        if (polIns == null) {
            policy = this._wspf.createDataModelFactory().createPolicy();
        } else {
            policy = (Policy)this._wspf.getReader(InputStream.class).read(polIns);
            if (policy == null) {
                policy = this._wspf.createDataModelFactory().createPolicy();
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "No Policy elements have been found, returning empty policy");
                }
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "inputStreamToPolicy");
        }
        return policy;
    }

    public PolicyInputStreamHolder toPolicyInputStreamHolder(boolean deNormalize) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toPolicyInputStreamHolder");
        }
        PolicyInputStreamHolder result = new PolicyInputStreamHolder();
        result.setMain(this.policyToInputStream(this._main, deNormalize));
        result.setInput(this.policyToInputStream(this._input, deNormalize));
        result.setOutput(this.policyToInputStream(this._output, deNormalize));
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toPolicyInputStreamHolder");
        }
        return result;
    }

    private InputStream policyToInputStream(Policy policy, boolean deNormalize) throws PolicyReferenceException, WSPolicyInternalException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "policyToInputStream");
        }
        try {
            ElementWriter<OutputStream> ew = this._wspf.getWriter(OutputStream.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ew.write(policy, baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "policyToInputStream");
            }
            return bais;
        }
        catch (ElementWriterException e) {
            throw new WSPolicyInternalException(e);
        }
    }
}

