/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import com.ibm.ws.wsaddressing.urimap.WebModuleData;
import com.ibm.ws.wsaddressing.urimap.WebserviceDescriptionInfo;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRPCEndpointData
implements EndpointMapService.EndpointData {
    private static TraceComponent _tc = Tr.register(JAXRPCEndpointData.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private boolean intermediaryPresent;
    private String virtualHostName;
    private String appName;
    private String modName;
    private String contextRoot;
    private QName webServiceQName;
    private String portName;
    private String address;

    JAXRPCEndpointData(WSAddressingBaseService baseService, WSAddressingBaseService.SecurityHelper sit, WSAddressingBaseService.Prefix explicitPrefix, WebModuleData wmd, WebserviceDescriptionInfo wsdi, Map.Entry<QName, String> entry) {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.entry(_tc, "JAXRPCEndpointData", new Object[]{sit, explicitPrefix, wmd, wsdi, entry});
        }
        this.appName = wmd.getApplicationName();
        this.modName = "";
        this.virtualHostName = wmd.getVirtualHostName();
        this.contextRoot = wmd.getContextRoot();
        WSAddressingBaseService.Prefix httpPrefix = baseService.getPrefix("http", this.virtualHostName);
        WSAddressingBaseService.Prefix httpsPrefix = baseService.getPrefix("https", this.virtualHostName);
        if (explicitPrefix != null && "http".equals(explicitPrefix.getProtocol())) {
            httpPrefix = explicitPrefix;
        }
        if (explicitPrefix != null && "https".equals(explicitPrefix.getProtocol())) {
            httpPrefix = explicitPrefix;
        }
        String webServiceName = wsdi.getWebserviceDescriptionName();
        QName portQName = entry.getKey();
        this.webServiceQName = new QName(portQName.getNamespaceURI(), webServiceName);
        this.portName = portQName.getLocalPart();
        String urlPattern = entry.getValue();
        boolean isHTTPS = sit.isSSLEnabled("/" + urlPattern);
        if (httpPrefix != null && !isHTTPS) {
            this.intermediaryPresent = httpPrefix.isIntermediary();
            this.address = httpPrefix + "/" + this.contextRoot + "/" + urlPattern;
        }
        if (httpsPrefix != null && isHTTPS) {
            this.intermediaryPresent = httpsPrefix.isIntermediary();
            this.address = httpsPrefix + "/" + this.contextRoot + "/" + urlPattern;
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "JAXRPCEndpointData", this);
        }
    }

    @Override
    public String getAddress() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getAddress", this.address);
        }
        return this.address;
    }

    @Override
    public String getApplicationName() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getApplicationName", this.appName);
        }
        return this.appName;
    }

    @Override
    public String getModuleName() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getModuleName", this.modName);
        }
        return this.modName;
    }

    @Override
    public String getEndpointName() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getEndpointName", this.portName);
        }
        return this.portName;
    }

    @Override
    public String getVirtualHost() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getVirtualHost", this.virtualHostName);
        }
        return this.virtualHostName;
    }

    @Override
    public QName getWebServiceName() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "getWebServiceName", this.webServiceQName);
        }
        return this.webServiceQName;
    }

    @Override
    public boolean isIntermediaryPresent() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "isIntermediaryPresent", this.intermediaryPresent);
        }
        return this.intermediaryPresent;
    }

    @Override
    public boolean isWLMable() {
        if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "isWLMable", true);
        }
        return true;
    }
}

