/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws21.server.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.jaxws21.SubmissionAddressing;
import com.ibm.ws.ffdc.FFDCFilter;
import javax.xml.ws.soap.Addressing;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.feature.ServerConfigurator;
import org.apache.axis2.jaxws.registry.ServerConfiguratorRegistry;

public class AddressingConfigurator
implements ServerConfigurator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingConfigurator.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public AddressingConfigurator() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    public void configure(EndpointDescription endpointDescription) {
        boolean w3cAddressingEnabled;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "configure", new Object[]{endpointDescription});
        }
        Addressing addressing = (Addressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://www.w3.org/2005/08/addressing/module");
        SubmissionAddressing submissionAddressing = (SubmissionAddressing)((EndpointDescriptionJava)((Object)endpointDescription)).getAnnoFeature("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        AxisService service = endpointDescription.getAxisService();
        Parameter namespace = new Parameter("WSAddressingVersion", null);
        Parameter disabled = new Parameter("disableAddressingForInMessages", "false");
        Parameter required = new Parameter("addressingRequirementParameter", "unspecified");
        if (addressing != null && submissionAddressing != null) {
            w3cAddressingEnabled = addressing.enabled();
            boolean submissionAddressingEnabled = submissionAddressing.enabled();
            if (w3cAddressingEnabled && submissionAddressingEnabled) {
                namespace.setValue(null);
                boolean w3cAddressingRequired = addressing.required();
                boolean submissionAddressingRequired = submissionAddressing.required();
                if (w3cAddressingRequired || submissionAddressingRequired) {
                    required.setValue("required");
                }
            } else if (w3cAddressingEnabled) {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue("required");
                }
            } else if (submissionAddressingEnabled) {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue("required");
                }
            } else {
                disabled.setValue("true");
            }
        } else if (addressing != null) {
            w3cAddressingEnabled = addressing.enabled();
            if (w3cAddressingEnabled) {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
                if (addressing.required()) {
                    required.setValue("required");
                }
            } else {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
            }
        } else if (submissionAddressing != null) {
            boolean submissionAddressingEnabled = submissionAddressing.enabled();
            if (submissionAddressingEnabled) {
                namespace.setValue("http://schemas.xmlsoap.org/ws/2004/08/addressing");
                if (submissionAddressing.required()) {
                    required.setValue("required");
                }
            } else {
                namespace.setValue("http://www.w3.org/2005/08/addressing");
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(nls.getString("CONFIGURATOR_ERROR_CWWAR0005"));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WS-Addressing version: " + namespace);
            Tr.debug(TRACE_COMPONENT, "WS-Addressing disabled: " + disabled);
            Tr.debug(TRACE_COMPONENT, "WS-Addressing required: " + required);
        }
        try {
            service.addParameter(namespace);
            service.addParameter(disabled);
            service.addParameter(required);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws21.server.config.AddressingConfigurator", "1:1.1:162", this);
            Tr.error(TRACE_COMPONENT, nls.getString("CONFIGURATOR_ERROR_CWWAR0005"), e);
            throw ExceptionFactory.makeWebServiceException(nls.getString("CONFIGURATOR_ERROR_CWWAR0005"), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "configure");
        }
    }

    public boolean supports(String bindingId) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "supports", new Object[]{bindingId});
        }
        boolean result = ServerConfiguratorRegistry.isSOAPBinding(bindingId);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "supports", result);
        }
        return result;
    }
}

