/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws21.factory.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.jaxws21.SubmissionEndpointReference;
import com.ibm.ws.ffdc.FFDCFilter;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.factory.JAXWSEndpointReferenceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSEndpointReferenceFactoryImpl
implements JAXWSEndpointReferenceFactory {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(JAXWSEndpointReferenceFactoryImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private JAXBContext jaxbContext;

    public JAXWSEndpointReferenceFactoryImpl() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
        }
        try {
            this.jaxbContext = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws JAXBException {
                    return JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class, SubmissionEndpointReference.class});
                }
            });
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws21.factory.impl.JAXWSEndpointReferenceFactoryImpl", "1:1.1:82", this);
            Tr.error(TRACE_COMPONENT, nls.getString("JAXBCONTEXT_CREATION_FAILED_CWWAR0015"), e);
            throw new WebServiceException(nls.getString("JAXBCONTEXT_CREATION_FAILED_CWWAR0015"), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    @Override
    public EndpointReference createEndpointReference(Source eprInfoset) throws JAXBException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", new Object[]{eprInfoset});
        }
        Unmarshaller um = this.jaxbContext.createUnmarshaller();
        EndpointReference epr = (EndpointReference)um.unmarshal(eprInfoset);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", epr);
        }
        return epr;
    }

    @Override
    public <T extends EndpointReference> String getAddressingNamespace(Class<T> clazz) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAddressingNamespace", new Object[]{clazz});
        }
        String addressingNamespace = null;
        if (W3CEndpointReference.class.isAssignableFrom(clazz)) {
            addressingNamespace = "http://www.w3.org/2005/08/addressing";
        } else if (SubmissionEndpointReference.class.isAssignableFrom(clazz)) {
            addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        } else {
            throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("PORT_NAME_NOT_FOUND_CWWAR0009", new Object[]{clazz}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAddressingNamespace", addressingNamespace);
        }
        return addressingNamespace;
    }
}

