/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws21.factory.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.wsaddressing.integration.EndpointMapService;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.factory.Axis2EndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMap;
import org.apache.axis2.jaxws.addressing.util.EndpointContextMapManager;
import org.apache.axis2.jaxws.addressing.util.EndpointKey;
import org.apache.axis2.jaxws.addressing.util.EndpointReferenceUtils;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;

public class Axis2EndpointReferenceFactoryImpl
implements Axis2EndpointReferenceFactory {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Axis2EndpointReferenceFactoryImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public Axis2EndpointReferenceFactoryImpl() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    public EndpointReference createEndpointReference(String address) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", new Object[]{address});
        }
        if (address == null) {
            throw new IllegalStateException(nls.getString("NULL_EPR_ADDRESS_CWWAR0010"));
        }
        EndpointReference epr = new EndpointReference(address);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", epr);
        }
        return epr;
    }

    public EndpointReference createEndpointReference(QName serviceName, QName endpoint) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", new Object[]{serviceName, endpoint});
        }
        EndpointKey key = new EndpointKey(serviceName, endpoint);
        EndpointContextMap map = EndpointContextMapManager.getEndpointContextMap();
        List list = (List)map.get(key);
        EndpointMapService.EndpointData data = null;
        if (list == null) {
            throw new IllegalStateException(nls.getFormattedMessage("URI_NOT_FOUND_CWWAR0011", new Object[]{serviceName, endpoint}, null));
        }
        if (list.size() == 1) {
            data = (EndpointMapService.EndpointData)list.get(0);
        } else {
            J2EEName jName;
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "createEndpointReference", "Component metadata: " + cmd);
            }
            if (cmd != null && (jName = cmd.getJ2EEName()) != null) {
                String moduleName = jName.getModule();
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "Using the module name, " + moduleName + ", to select among multiple URIs.");
                }
                for (EndpointMapService.EndpointData item : list) {
                    if (!item.getModuleName().equals(moduleName)) continue;
                    data = item;
                }
            }
            if (data == null) {
                throw ExceptionFactory.makeWebServiceException(nls.getFormattedMessage("TEMPORARY_CWWAR9999", new Object[]{"The combination of " + serviceName + " and " + endpoint + " is not unique within the application. Unable to generate a suitable URI for the endpoint."}, null));
            }
        }
        EndpointReference epr = this.createEndpointReference(data.getAddress());
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", epr);
        }
        return epr;
    }

    public EndpointReference createEndpointReference(String address, QName serviceName, QName portName, String wsdlDocumentLocation, String addressingNamespace) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReference", new Object[]{address, serviceName, portName, wsdlDocumentLocation, addressingNamespace});
        }
        EndpointReference epr = null;
        if (address != null) {
            if (serviceName == null && portName != null) {
                throw new IllegalStateException(nls.getFormattedMessage("URI_NOT_FOUND_CWWAR0011", new Object[]{serviceName, portName}, null));
            }
            epr = this.createEndpointReference(address);
        } else if (serviceName != null && portName != null) {
            epr = this.createEndpointReference(serviceName, portName);
        } else {
            Tr.error(TRACE_COMPONENT, nls.getString("NO_INFO_TO_CREATE_AN_EPR_CWWAR0012"));
            throw new IllegalStateException(nls.getString("NO_INFO_TO_CREATE_AN_EPR_CWWAR0012"));
        }
        try {
            if (serviceName != null && portName != null) {
                EndpointReferenceUtils.addService(epr, serviceName, portName, addressingNamespace);
            }
            if (wsdlDocumentLocation != null) {
                URL wsdlURL = new URL(wsdlDocumentLocation);
                WSDL4JWrapper wrapper = new WSDL4JWrapper(wsdlURL);
                if (serviceName != null) {
                    if (wrapper.getService(serviceName) == null) {
                        throw new IllegalStateException(nls.getFormattedMessage("SERVICE_NAME_NOT_FOUND_CWWAR0008", new Object[]{serviceName, wsdlDocumentLocation}, null));
                    }
                    if (portName != null) {
                        String[] ports = wrapper.getPorts(serviceName);
                        String portLocalName = portName.getLocalPart();
                        boolean found = false;
                        if (ports != null) {
                            for (String port : ports) {
                                if (!port.equals(portLocalName)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (!found) {
                            throw new IllegalStateException(nls.getFormattedMessage("PORT_NAME_NOT_FOUND_CWWAR0009", new Object[]{portName, wsdlDocumentLocation}, null));
                        }
                        EndpointReferenceUtils.addLocation(epr, portName.getNamespaceURI(), wsdlDocumentLocation, addressingNamespace);
                    }
                }
            }
        }
        catch (IllegalStateException ise) {
            FFDCFilter.processException((Throwable)ise, "com.ibm.ws.wsaddressing.jaxws21.factory.impl.Axis2EndpointReferenceFactoryImpl", "1:1.5:222", this);
            Tr.error(TRACE_COMPONENT, nls.getString("UNABLE_TO_CREATE_AN_EPR_CWWAR0013"), ise);
            throw ise;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws21.factory.impl.Axis2EndpointReferenceFactoryImpl", "1:1.5:228", this);
            Tr.error(TRACE_COMPONENT, nls.getString("UNABLE_TO_CREATE_AN_EPR_CWWAR0013"), e);
            throw ExceptionFactory.makeWebServiceException(nls.getString("UNABLE_TO_CREATE_AN_EPR_CWWAR0013"), e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReference", epr);
        }
        return epr;
    }
}

