/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.urimap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.deploy.URLPrefixMapHelper;
import com.ibm.ws.wsaddressing.integration.WSAddressingBaseService;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;

public class ExplicitPrefixLoader {
    private static final TraceComponent _tc = Tr.register(ExplicitPrefixLoader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.urimap.ExplicitPrefixLoader";

    public static WSAddressingBaseService.Prefix getExplicitPrefix(String applicationName, ModuleFile moduleFile) {
        HashMap<String, String> prefixMap;
        ExplicitPrefix result;
        block6: {
            if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
                Tr.entry(_tc, "getExplicitPrefix", new Object[]{applicationName, moduleFile});
            }
            result = null;
            URLPrefixMapHelper prefixHelper = new URLPrefixMapHelper(applicationName, moduleFile, null);
            prefixMap = null;
            try {
                prefixMap = prefixHelper.get();
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:94:1.4");
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) break block6;
                Tr.debug(_tc, "getExplicitPrefix", "Exception caught whilst accessing the Endpoint override");
            }
        }
        String httpPrefix = prefixMap.get("http");
        if (httpPrefix != null) {
            URI uri = URI.create(httpPrefix);
            result = new ExplicitPrefix(httpPrefix);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Explicit Prefix found: " + httpPrefix);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && _tc.isEntryEnabled()) {
            Tr.exit(_tc, "getExplicitPrefix", result);
        }
        return result;
    }

    private static class ExplicitPrefix
    implements WSAddressingBaseService.Prefix {
        String host;
        String port;
        String protocol;

        ExplicitPrefix(String pfx) {
            URI uri = URI.create(pfx);
            this.host = uri.getHost();
            this.port = "" + uri.getPort();
            this.protocol = uri.getScheme();
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean isIntermediary() {
            return true;
        }

        public String toString() {
            return this.protocol + "://" + this.host + ":" + this.port;
        }
    }
}

