/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeBndFileHelper;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeFileHelper;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.addressing.AddressingConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAPolicyTypeProvider
implements PolicyTypeProvider {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAPolicyTypeProvider.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private PolicyTypeBndFileHelper bindingHelper = new PolicyTypeBndFileHelper();
    private PolicyTypeFileHelper policyHelper = new PolicyTypeFileHelper();
    static Transformer usingAddressingToAddressing = null;
    static Transformer policy12to15 = null;
    static Transformer policy15to12 = null;
    static Transformer reformatUnspecified = null;
    private static QName WSDL_REQUIRED_QNAME;

    @Override
    public Properties getAttributes(String policyFileName, Properties attributes, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAttributes", new Object[]{policyFileName, attributes, context});
        }
        Properties existingAttributes = this.policyHelper.readPolicyType(policyFileName);
        Properties resultAttributes = null;
        if (attributes != null && !attributes.isEmpty()) {
            resultAttributes = new Properties();
            for (Object key : attributes.keySet()) {
                if (existingAttributes.containsKey(key)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getAttributes", "Copying attribute: " + key);
                    }
                    resultAttributes.put(key, existingAttributes.get(key));
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "getAttributes", "Attribute requested but not available: " + key);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getAttributes", "No attributes specified. Copying all of them.");
            }
            resultAttributes = existingAttributes;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAttributes", resultAttributes);
        }
        return resultAttributes;
    }

    @Override
    public Properties getBinding(String bindingFileName, Properties attributes, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getBinding", new Object[]{bindingFileName, attributes, context});
        }
        Properties existingAttributes = this.bindingHelper.readPolicyType(bindingFileName);
        Properties resultAttributes = null;
        if (attributes != null && !attributes.isEmpty()) {
            resultAttributes = new Properties();
            for (Object key : attributes.keySet()) {
                if (existingAttributes.containsKey(key)) {
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "getBinding", "Copying attribute: " + key);
                    }
                    resultAttributes.put(key, existingAttributes.get(key));
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                Tr.debug(TRACE_COMPONENT, "getBinding", "Attribute requested but not available: " + key);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "getBinding", "No attributes specified. Copying all of them.");
            }
            resultAttributes = existingAttributes;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getBinding", resultAttributes);
        }
        return resultAttributes;
    }

    @Override
    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getType", "WSAddressing");
        }
        return "WSAddressing";
    }

    @Override
    public boolean setAttributes(String policyFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setAttributes", new Object[]{policyFileName, attributes, replace, context});
        }
        boolean success = this.policyHelper.writePolicyType(policyFileName, attributes, context);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setAttributes", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "setBinding", new Object[]{bindingFileName, attributes, replace, context});
        }
        boolean success = this.bindingHelper.writePolicyType(bindingFileName, attributes, context);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "setBinding", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean validate(String policySetFileName, String policyFileName, Map context) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "validate", new Object[]{policySetFileName, policyFileName, context});
        }
        return true;
    }

    @Override
    public boolean upgradeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "upgradeBinding", new Object[]{oldBindingFilePath, newBindingFilePath, this});
        }
        byte[] bytes = WSAPolicyTypeProvider.transform(oldBindingFilePath, policy12to15);
        FileOutputStream fos = new FileOutputStream(newBindingFilePath);
        fos.write(bytes);
        fos.close();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "upgradeBinding", Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mergeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "mergeBinding", new Object[]{oldBindingFilePath, newBindingFilePath, this});
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(oldBindingFilePath);
            fos = new FileOutputStream(newBindingFilePath);
            int val = fis.read();
            while (val != -1) {
                fos.write(val);
                val = fis.read();
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "mergeBinding", Boolean.TRUE);
        }
        return true;
    }

    @Override
    public boolean upgradePolicy(String oldPolicyFilePath, String newPolicyFilePath) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "upgradePolicy", new Object[]{oldPolicyFilePath, newPolicyFilePath, this});
        }
        byte[] partialpolicy15form = WSAPolicyTypeProvider.transform(oldPolicyFilePath, policy12to15);
        byte[] policy15form = WSAPolicyTypeProvider.transform(partialpolicy15form, reformatUnspecified);
        byte[] completedtransform = WSAPolicyTypeProvider.transform(policy15form, usingAddressingToAddressing);
        WSPolicyExternalizer.Policy policy = WSPolicyExternalizer.readPolicy(new ByteArrayInputStream(completedtransform));
        WSPolicyExternalizer.writePolicy(policy, new FileOutputStream(newPolicyFilePath));
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "upgradePolicy", Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transform(String fileName, Transformer transformer) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transform", new Object[]{fileName, transformer});
        }
        byte[] result = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            result = WSAPolicyTypeProvider.transform(fis, transformer);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transform", result);
        }
        return result;
    }

    private static byte[] transform(byte[] bytes, Transformer transformer) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transform", new Object[]{bytes, transformer});
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] result = WSAPolicyTypeProvider.transform(bais, transformer);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transform", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transform(InputStream stream, Transformer transformer) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transform", new Object[]{stream, transformer});
        }
        StreamSource xmlSource = new StreamSource(stream);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Transformer transformer2 = transformer;
        synchronized (transformer2) {
            transformer.transform(xmlSource, result);
        }
        byte[] byteresult = baos.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transform", byteresult);
        }
        return byteresult;
    }

    static byte[] transformpolicy12to15(InputStream stream) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformpolicy12to15", new Object[]{stream});
        }
        byte[] byteresult = WSAPolicyTypeProvider.transform(stream, policy12to15);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformpolicy12to15", byteresult);
        }
        return byteresult;
    }

    static byte[] transformpolicy15to12(InputStream stream) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "transformpolicy15to12", new Object[]{stream});
        }
        byte[] byteresult = WSAPolicyTypeProvider.transform(stream, policy15to12);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "transformpolicy15to12", byteresult);
        }
        return byteresult;
    }

    @Override
    public InputStream downgradeBinding(InputStream bindingFileStream, Map<String, String> context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "downgradeBinding", new Object[]{bindingFileStream, context, this});
        }
        byte[] result = WSAPolicyTypeProvider.transform(bindingFileStream, policy15to12);
        ByteArrayInputStream isresult = new ByteArrayInputStream(result);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "downgradeBinding", isresult);
        }
        return isresult;
    }

    @Override
    public InputStream downgradePolicy(InputStream policyFileStream, Map<String, String> context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "downgradePolicy", new Object[]{policyFileStream, context, this});
        }
        Properties props = new PolicyTypeFileHelper().readPolicyType(policyFileStream);
        String flag = props.getProperty("usingaddressing");
        WSPolicyExternalizer.Policy policy = WSAPolicyTypeProvider.buildWSAWPolicy(flag);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WSPolicyExternalizer.writePolicy(policy, baos);
        byte[] result = WSAPolicyTypeProvider.transform(baos.toByteArray(), policy15to12);
        ByteArrayInputStream isresult = new ByteArrayInputStream(result);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "downgradePolicy", isresult);
        }
        return isresult;
    }

    @Override
    public boolean mergeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "mergeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        boolean status = false;
        if (newBindingFile != null && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "An existing binding file was passed in but we are ignoring it.");
        }
        int val = oldBindingFile.read();
        while (val != -1) {
            resultBindingFile.write(val);
            val = oldBindingFile.read();
        }
        status = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "mergeBinding", status);
        }
        return status;
    }

    @Override
    public boolean upgradeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "upgradeBinding", new Object[]{oldBindingFile, newBindingFile, resultBindingFile});
        }
        boolean status = false;
        if (newBindingFile != null && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "An existing binding file was passed in but we are ignoring it.");
        }
        byte[] bytes = WSAPolicyTypeProvider.transform(oldBindingFile, policy12to15);
        resultBindingFile.write(bytes);
        status = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "upgradeBinding", status);
        }
        return status;
    }

    @Override
    public boolean upgradePolicy(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "upgradePolicy", new Object[]{oldPolicyFile, newPolicyFile, resultPolicyFile});
        }
        boolean status = false;
        if (newPolicyFile != null && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "An existing policy file was passed in but we are ignoring it.");
        }
        byte[] partialpolicy15form = WSAPolicyTypeProvider.transform(oldPolicyFile, policy12to15);
        byte[] policy15form = WSAPolicyTypeProvider.transform(partialpolicy15form, reformatUnspecified);
        byte[] completedtransform = WSAPolicyTypeProvider.transform(policy15form, usingAddressingToAddressing);
        WSPolicyExternalizer.Policy policy = WSPolicyExternalizer.readPolicy(new ByteArrayInputStream(completedtransform));
        WSPolicyExternalizer.writePolicy(policy, resultPolicyFile);
        status = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "upgradePolicy", status);
        }
        return status;
    }

    private static WSPolicyExternalizer.Policy buildWSAWPolicy(String flag) throws WSPolicyInternalException, PolicyReferenceException {
        Assertion assertion;
        HashMap<QName, String> map;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildWSAWPolicy", flag);
        }
        ArrayList<WSPolicyExternalizer.Alternative> alternatives = new ArrayList<WSPolicyExternalizer.Alternative>();
        if ("unspecified".equals(flag)) {
            alternatives.add(WSPolicyExternalizer.createAlternative(new Assertion[0]));
        }
        if ("unspecified".equals(flag) || "optional".equals(flag)) {
            map = new HashMap<QName, String>();
            map.put(WSDL_REQUIRED_QNAME, "false");
            assertion = WSPolicyExternalizer.createAssertion(AddressingConstants.Final.WSAW_USING_ADDRESSING, map, null, false, null);
            alternatives.add(WSPolicyExternalizer.createAlternative(assertion));
        }
        if ("unspecified".equals(flag) || "required".equals(flag)) {
            map = new HashMap();
            map.put(WSDL_REQUIRED_QNAME, "true");
            assertion = WSPolicyExternalizer.createAssertion(AddressingConstants.Final.WSAW_USING_ADDRESSING, map, null, false, null);
            alternatives.add(WSPolicyExternalizer.createAlternative(assertion));
        }
        WSPolicyExternalizer.Alternative[] altsArray = new WSPolicyExternalizer.Alternative[alternatives.size()];
        altsArray = alternatives.toArray(altsArray);
        WSPolicyExternalizer.Policy policy = WSPolicyExternalizer.createPolicy(altsArray);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildWSAWPolicy", policy);
        }
        return policy;
    }

    static {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            ClassLoader cl = WSAPolicyTypeProvider.class.getClassLoader();
            InputStream xslStream = cl.getResourceAsStream("com/ibm/ws/wsaddressing/jaxws/policyset/usingaddressingtoaddressing.xsl");
            StreamSource xslSource = new StreamSource(xslStream);
            usingAddressingToAddressing = tf.newTransformer(xslSource);
            xslStream = cl.getResourceAsStream("com/ibm/ws/wsaddressing/jaxws/policyset/policy12to15.xsl");
            xslSource = new StreamSource(xslStream);
            policy12to15 = tf.newTransformer(xslSource);
            xslStream = cl.getResourceAsStream("com/ibm/ws/wsaddressing/jaxws/policyset/policy15to12.xsl");
            xslSource = new StreamSource(xslStream);
            policy15to12 = tf.newTransformer(xslSource);
            xslStream = cl.getResourceAsStream("com/ibm/ws/wsaddressing/jaxws/policyset/re-format-unspecified.xsl");
            xslSource = new StreamSource(xslStream);
            reformatUnspecified = tf.newTransformer(xslSource);
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wsaddressing.jaxws.policyset.WSAPolicyTypeProvider.<clinit>", "247");
        }
        WSDL_REQUIRED_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/", "required");
    }
}

