/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeBndFileHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class WSADefaultBindingLoader
implements BindingLoader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSADefaultBindingLoader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    PolicyTypeBndFileHelper helper = new PolicyTypeBndFileHelper();

    public void destroy() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "destroy");
        }
    }

    public String getType() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "getType", "WSAddressing");
        }
        return "WSAddressing";
    }

    public void init(Map properties) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "init");
        }
    }

    public void loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding defaultBinding, PolicySetConfiguration psConfig) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadCustom", new Object[]{appCL, sysCL, expander, input, defaultBinding, psConfig});
        }
        String wlmEprs = "unspecified";
        Properties attributes = this.helper.readPolicyType(input);
        if (attributes != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "loadCustom", "Getting value from Properties object");
            }
            wlmEprs = attributes.getProperty("preventWLM", "unspecified");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "loadCustom", "Setting preventWLM value: " + wlmEprs);
        }
        if ("unspecified".equals(wlmEprs)) {
            wlmEprs = (String)defaultBinding.getDefaultBinding("preventWLM");
        }
        if (psConfig != null) {
            psConfig.setPolicyTypeBinding("preventWLM", wlmEprs);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadCustom", wlmEprs);
        }
    }

    public void loadDefault(ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding defaultBinding) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "loadDefault", new Object[]{sysCL, expander, input, defaultBinding});
        }
        String wlmEprs = "unspecified";
        Properties attributes = this.helper.readPolicyType(input);
        if (attributes != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "loadDefault", "Getting value from Properties object");
            }
            wlmEprs = attributes.getProperty("preventWLM", "unspecified");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "loadDefault", "Setting preventWLM value: " + wlmEprs);
        }
        if (defaultBinding != null) {
            defaultBinding.setDefaultBinding("preventWLM", wlmEprs);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "loadDefault");
        }
    }
}

