/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import com.ibm.ws.wsaddressing.jaxws.policyset.PolicyTypeFileHelperBase;
import com.ibm.ws.wspolicy.PolicyReferenceException;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.lightweight.WSPolicyExternalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.addressing.AddressingConstants;

public class PolicyTypeFileHelper
extends PolicyTypeFileHelperBase
implements AddressingConstants,
Constants {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(PolicyTypeFileHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    WSPolicyExternalizer.Policy buildPolicy(Properties attributes) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "buildPolicy", attributes);
        }
        String wsaddressingFlag = "unspecified";
        String wsaMode = "WSA_BOTH";
        if (attributes != null) {
            wsaddressingFlag = attributes.getProperty("usingaddressing");
            wsaMode = attributes.getProperty("wsaMode");
        }
        ArrayList<WSPolicyExternalizer.Alternative> alternatives = new ArrayList<WSPolicyExternalizer.Alternative>();
        if ("optional".equals(wsaddressingFlag)) {
            alternatives.add(WSPolicyExternalizer.createAlternative(new Assertion[0]));
        }
        if ("optional".equals(wsaddressingFlag) || "required".equals(wsaddressingFlag)) {
            if ("WSA_BOTH".equals(wsaMode)) {
                WSPolicyExternalizer.Policy emptyNestedPolicy = WSPolicyExternalizer.createPolicy(WSPolicyExternalizer.createAlternative(new Assertion[0]));
                Assertion emptyAddressing = WSPolicyExternalizer.createAssertion(Constants.ADDRESSING_ASSERTION_QNAME, null, null, false, emptyNestedPolicy);
                alternatives.add(WSPolicyExternalizer.createAlternative(emptyAddressing));
            }
            if ("WSA_BOTH".equals(wsaMode) || "WSA_SYNC".equals(wsaMode)) {
                Assertion anonymousAssertion = WSPolicyExternalizer.createAssertion(Constants.ANONYMOUSRESPONSES_ASSERTION_QNAME, null, null, false, null);
                WSPolicyExternalizer.Policy syncNestedPolicy = WSPolicyExternalizer.createPolicy(WSPolicyExternalizer.createAlternative(anonymousAssertion));
                Assertion syncAddressing = WSPolicyExternalizer.createAssertion(Constants.ADDRESSING_ASSERTION_QNAME, null, null, false, syncNestedPolicy);
                alternatives.add(WSPolicyExternalizer.createAlternative(syncAddressing));
            }
            if ("WSA_BOTH".equals(wsaMode) || "WSA_ASYNC".equals(wsaMode)) {
                Assertion nonanonymousAssertion = WSPolicyExternalizer.createAssertion(Constants.NONANONYMOUSRESPONSES_ASSERTION_QNAME, null, null, false, null);
                WSPolicyExternalizer.Policy asyncNestedPolicy = WSPolicyExternalizer.createPolicy(WSPolicyExternalizer.createAlternative(nonanonymousAssertion));
                Assertion asyncAddressing = WSPolicyExternalizer.createAssertion(Constants.ADDRESSING_ASSERTION_QNAME, null, null, false, asyncNestedPolicy);
                alternatives.add(WSPolicyExternalizer.createAlternative(asyncAddressing));
            }
        }
        WSPolicyExternalizer.Alternative[] alts = new WSPolicyExternalizer.Alternative[alternatives.size()];
        WSPolicyExternalizer.Policy policy = WSPolicyExternalizer.createPolicy(alternatives.toArray(alts));
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "buildPolicy", policy);
        }
        return policy;
    }

    Properties processPolicy(WSPolicyExternalizer.Policy policy) throws PolicyReferenceException, WSPolicyInternalException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processPolicy", policy);
        }
        String wsaddressingFlag = "unspecified";
        String wsaMode = "WSA_BOTH";
        if (policy != null) {
            boolean emptyAlternativeFound = false;
            boolean requiredAlternativeFound = false;
            boolean emptyNestedFound = false;
            boolean syncNestedFound = false;
            boolean asyncNestedFound = false;
            for (WSPolicyExternalizer.Alternative a : policy) {
                Iterator assertions = a.iterator();
                if (!assertions.hasNext()) {
                    emptyAlternativeFound = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "Empty Alternative encountered. Ignoring");
                    continue;
                }
                while (assertions.hasNext()) {
                    Assertion assertion = (Assertion)assertions.next();
                    if (Constants.ADDRESSING_ASSERTION_QNAME.equals(assertion.getAssertionName())) {
                        requiredAlternativeFound = true;
                        WSPolicyExternalizer.NestingAssertion na = (WSPolicyExternalizer.NestingAssertion)assertion;
                        WSPolicyExternalizer.Policy np = na.getNestedPolicy();
                        for (WSPolicyExternalizer.Alternative nestedAlternative : np) {
                            Iterator nestedAssertions = nestedAlternative.iterator();
                            if (!nestedAssertions.hasNext()) {
                                emptyNestedFound = true;
                                continue;
                            }
                            boolean syncNestedFoundLocal = false;
                            boolean asyncNestedFoundLocal = false;
                            while (nestedAssertions.hasNext()) {
                                Assertion nestedAssertion = (Assertion)nestedAssertions.next();
                                if (Constants.ANONYMOUSRESPONSES_ASSERTION_QNAME.equals(nestedAssertion.getAssertionName())) {
                                    syncNestedFoundLocal = true;
                                    continue;
                                }
                                if (!Constants.NONANONYMOUSRESPONSES_ASSERTION_QNAME.equals(nestedAssertion.getAssertionName())) continue;
                                asyncNestedFoundLocal = true;
                            }
                            if (syncNestedFoundLocal && asyncNestedFoundLocal) {
                                if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                                Tr.debug(TRACE_COMPONENT, "Invalid WS-A Policy. Both AnonymousReponses and NonAnonymousResponses present in a single alternative.");
                                continue;
                            }
                            if (syncNestedFoundLocal) {
                                syncNestedFound = syncNestedFoundLocal;
                            }
                            if (!asyncNestedFoundLocal) continue;
                            asyncNestedFound = asyncNestedFoundLocal;
                        }
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "Unsupported Assertion being read");
                }
            }
            wsaddressingFlag = emptyAlternativeFound && requiredAlternativeFound ? "optional" : (requiredAlternativeFound ? "required" : "unspecified");
            if (emptyNestedFound || syncNestedFound && asyncNestedFound) {
                wsaMode = "WSA_BOTH";
            } else if (syncNestedFound) {
                wsaMode = "WSA_SYNC";
            } else if (asyncNestedFound) {
                wsaMode = "WSA_ASYNC";
            } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "No nested policy found.");
            }
        }
        Properties resultProperties = new Properties();
        resultProperties.put("usingaddressing", wsaddressingFlag);
        resultProperties.put("wsaMode", wsaMode);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processPolicy", resultProperties);
        }
        return resultProperties;
    }

    boolean validateAttributesForWrite(Properties attributes) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "validateAttributesForWrite", new Object[]{attributes, this});
        }
        if (attributes != null) {
            String wsaddressingFlag = null;
            String wsaMode = null;
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                if ("usingaddressing".equals(entry.getKey())) {
                    wsaddressingFlag = (String)entry.getValue();
                    continue;
                }
                if ("wsaMode".equals(entry.getKey())) {
                    wsaMode = (String)entry.getValue();
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "validateAttributesForWrite", "Unrecognised attribute:" + entry.getKey() + " . Returning false");
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "validateAttributesForWrite", Boolean.FALSE);
                }
                return false;
            }
            if (wsaddressingFlag == null) {
                attributes.setProperty("usingaddressing", "unspecified");
            }
            if (wsaMode == null) {
                attributes.setProperty("wsaMode", "WSA_BOTH");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "validateAttributesForWrite", Boolean.TRUE);
        }
        return true;
    }
}

