/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axis2.addressing.RelatesTo;

public class RelationshipConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(RelationshipConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    protected static RelatesTo toAxis2(Relationship ibmRelationship) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{ibmRelationship});
        }
        RelatesTo axis2RelatesTo = null;
        if (ibmRelationship != null) {
            URI relatesTo = ibmRelationship.getURI();
            URI relationshipType = ibmRelationship.getRelationshipType();
            String value = null;
            if (relatesTo != null) {
                value = relatesTo.toString();
            }
            String type = null;
            if (relationshipType != null) {
                type = relationshipType.toString();
            }
            axis2RelatesTo = new RelatesTo(value, type);
            ArrayList<OMAttribute> omattrs = AttributedURIConverter.getAxis2Attributes(ibmRelationship);
            if (!omattrs.isEmpty()) {
                axis2RelatesTo.setExtensibilityAttributes(omattrs);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", axis2RelatesTo);
        }
        return axis2RelatesTo;
    }

    protected static Relationship fromAxis2(RelatesTo axis2RelatesTo) throws SOAPException, URISyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{axis2RelatesTo});
        }
        Relationship ibmRelationship = null;
        if (axis2RelatesTo != null) {
            String value = axis2RelatesTo.getValue();
            String type = axis2RelatesTo.getRelationshipType();
            URI relatesTo = null;
            if (value != null) {
                relatesTo = new URI(value);
            }
            URI relationshipType = null;
            if (type != null) {
                relationshipType = new URI(type);
            }
            ibmRelationship = WSAddressingFactory.createRelationship(relatesTo);
            ibmRelationship.setRelationshipType(relationshipType);
            ArrayList omattrs = axis2RelatesTo.getExtensibilityAttributes();
            HashMap<Name, String> ibmattrs = AttributedURIConverter.getIBMAttributes(omattrs);
            for (Map.Entry<Name, String> entry : ibmattrs.entrySet()) {
                ibmRelationship.addAttribute(entry.getKey(), entry.getValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", ibmRelationship);
        }
        return ibmRelationship;
    }
}

