/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.AttributedURI;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyAttributedURIImpl
implements AttributedURI {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(LazyAttributedURIImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    AttributedURI _auri;
    String _uriString;
    ArrayList<OMAttribute> _attributes;
    boolean isConstructed = false;

    public LazyAttributedURIImpl(String uri, ArrayList<OMAttribute> attributes) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "LazyAttributedURIImpl", new Object[]{uri, attributes});
        }
        this._uriString = uri;
        this._attributes = attributes;
        if (uri == null) {
            throw new IllegalArgumentException("Null URI not permitted.");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "LazyAttributedURIImpl");
        }
    }

    private void construct() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "construct", this);
        }
        try {
            this._auri = (AttributedURI)AttributedURIConverter.fromAxis2(this._uriString);
            if (this._attributes != null) {
                HashMap<Name, String> ibmattrs = AttributedURIConverter.getIBMAttributes(this._attributes);
                for (Map.Entry<Name, String> entry : ibmattrs.entrySet()) {
                    this._auri.addAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, this.getClass() + ".construct()", "1:73:1.2", this);
            if (TRACE_COMPONENT.isErrorEnabled()) {
                Tr.error(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 string to an IBM attributed URI.", e);
            }
            throw new WebServiceException(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), (Throwable)e);
        }
        this.isConstructed = true;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "construct");
        }
    }

    @Override
    public SOAPElement getSOAPElement(SOAPElement arg0) throws SOAPException {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getSOAPElement(arg0);
    }

    @Override
    public URI getURI() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getURI();
    }

    @Override
    public void setURI(URI arg0) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._auri.setURI(arg0);
    }

    @Override
    public void addAttribute(Name arg0, String arg1) {
        if (!this.isConstructed) {
            this.construct();
        }
        this._auri.addAttribute(arg0, arg1);
    }

    @Override
    public Iterator getAttributeNames() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getAttributeNames();
    }

    @Override
    public String getAttributeValue(Name arg0) {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.getAttributeValue(arg0);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new LazyAttributedURIImpl(this._uriString, this._attributes);
    }

    public boolean equals(Object o) {
        if (o instanceof LazyAttributedURIImpl) {
            LazyAttributedURIImpl other = (LazyAttributedURIImpl)o;
            if (!this.isConstructed) {
                this.construct();
            }
            if (!other.isConstructed) {
                other.construct();
            }
            return this._auri.equals(other._auri);
        }
        if (o instanceof AttributedURI) {
            if (!this.isConstructed) {
                this.construct();
            }
            return this._auri.equals(o);
        }
        return false;
    }

    public int hashCode() {
        if (!this.isConstructed) {
            this.construct();
        }
        return this._auri.hashCode();
    }
}

