/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.jaxws.message.factory.SAAJConverterFactory;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.registry.FactoryRegistry;

public class EndpointReferenceConverter
extends com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static SAAJConverter saajConverter = null;
    private static OMFactory omFactory = null;
    private static QName eprType = null;

    protected static org.apache.axis2.addressing.EndpointReference toAxis2(EndpointReference ibmEPR) throws SOAPException, WebServiceException, AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{ibmEPR});
        }
        org.apache.axis2.addressing.EndpointReference axis2EPR = null;
        if (ibmEPR != null) {
            SOAPFactory ibmSOAPFactory = new SOAPFactory();
            SOAPElement se = ibmSOAPFactory.createElement("epr");
            ibmEPR.getSOAPElement(se);
            OMElement ome = saajConverter.toOM(se);
            axis2EPR = EndpointReferenceHelper.fromOM(ome);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", axis2EPR);
        }
        return axis2EPR;
    }

    protected static EndpointReference fromAxis2(org.apache.axis2.addressing.EndpointReference axis2EPR, String addressingNamespace) throws SOAPException, WebServiceException, AxisFault, EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{axis2EPR, addressingNamespace});
        }
        EndpointReference ibmEPR = null;
        if (axis2EPR != null) {
            SOAPFactory ibmSOAPFactory = new SOAPFactory();
            SOAPElement se = ibmSOAPFactory.createElement("epr");
            OMElement ome = EndpointReferenceHelper.toOM(omFactory, axis2EPR, eprType, addressingNamespace);
            se = saajConverter.toSAAJ(ome, se, ibmSOAPFactory);
            ibmEPR = EndpointReferenceManager.createEndpointReference(se);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", ibmEPR);
        }
        return ibmEPR;
    }

    protected EndpointReference createEndpointReferenceFromOMElementImpl(OMElement omelement) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", omelement);
        }
        EndpointReference ibmEPR = null;
        if (omelement == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", "OMElement null, throwing EndpointReferenceCreationException");
            }
            throw new EndpointReferenceCreationException(nls.getString("NULL_OMELEMENT_CWWAR0109"));
        }
        QName elementName = omelement.getQName();
        if (elementName == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", "OMElement QName was null, throwing EndpointReferenceCreationException");
            }
            throw new EndpointReferenceCreationException(nls.getString("NULL_QNAME_CWWAR0110"));
        }
        try {
            SOAPFactory ibmSOAPFactory = new SOAPFactory();
            SOAPElement se = ibmSOAPFactory.createElement(elementName);
            se = saajConverter.toSAAJ(omelement, se, ibmSOAPFactory);
            ibmEPR = EndpointReferenceManager.createEndpointReference(se);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter", "1:137:1.12", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", "Exception caught and re-thrown: " + e.getMessage());
            }
            throw new EndpointReferenceCreationException(e);
        }
        catch (WebServiceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter", "1:142:1.12", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", "Exception caught and re-thrown: " + e.getMessage());
            }
            throw new EndpointReferenceCreationException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElementImpl", ibmEPR);
        }
        return ibmEPR;
    }

    protected OMElement serializeEndpointReferenceImpl(EndpointReference epr, QName qname) throws WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "serializeEndpointReferenceImpl", new Object[]{epr, qname});
        }
        if (epr == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "serializeEndpointReferenceImpl", "EndpointReference null, throwing MessageException");
            }
            throw new WebServiceException(nls.getString("NULL_EPR_CWWAR0111"));
        }
        if (qname == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "serializeEndpointReferenceImpl", "QName null, throwing MessageException");
            }
            throw new WebServiceException(nls.getString("NULL_QNAME_CWWAR0110"));
        }
        OMElement ome = null;
        try {
            SOAPFactory ibmSOAPFactory = new SOAPFactory();
            SOAPElement se = ibmSOAPFactory.createElement(qname);
            epr.getSOAPElement(se);
            ome = saajConverter.toOM(se);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter", "1:183:1.12", this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "serializeEndpointReferenceImpl", "Exception caught and re-thrown: " + e.getMessage());
            }
            throw new WebServiceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serializeEndpointReferenceImpl", ome);
        }
        return ome;
    }

    static {
        try {
            saajConverter = ((SAAJConverterFactory)FactoryRegistry.getFactory(SAAJConverterFactory.class)).getSAAJConverter();
            omFactory = OMAbstractFactory.getOMFactory();
            eprType = new QName("namespace", "epr", "prefix");
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter.<static>", "1:201:1.12");
        }
    }
}

