/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.wsaddressing.AttributedType;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedURIConverter {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AttributedURIConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static OMFactory omFactory = null;

    private AttributedURIConverter() {
    }

    protected static String toAxis2(AttributedURI ibmAttributedURI) {
        URI uri;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "toAxis2", new Object[]{ibmAttributedURI});
        }
        String axis2String = null;
        if (ibmAttributedURI != null && (uri = ibmAttributedURI.getURI()) != null) {
            axis2String = uri.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "toAxis2", axis2String);
        }
        return axis2String;
    }

    protected static ArrayList<OMAttribute> getAxis2Attributes(AttributedType ibmAttributedURI) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAxis2Attributes", new Object[]{ibmAttributedURI});
        }
        ArrayList<OMAttribute> axis2Attrs = new ArrayList<OMAttribute>();
        Iterator attrNames = ibmAttributedURI.getAttributeNames();
        while (attrNames.hasNext()) {
            Name attrName = (Name)attrNames.next();
            String value = ibmAttributedURI.getAttributeValue(attrName);
            OMNamespace namespace = omFactory.createOMNamespace(attrName.getURI(), attrName.getPrefix());
            OMAttribute oma = omFactory.createOMAttribute(attrName.getLocalName(), namespace, value);
            axis2Attrs.add(oma);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAxis2Attributes", axis2Attrs);
        }
        return axis2Attrs;
    }

    protected static HashMap<Name, String> getIBMAttributes(ArrayList<OMAttribute> axis2Attrs) throws SOAPException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAxis2Attributes", new Object[]{axis2Attrs});
        }
        SOAPFactory ibmSOAPFactory = new SOAPFactory();
        HashMap<Name, String> ibmAttrs = new HashMap<Name, String>();
        if (axis2Attrs != null && !axis2Attrs.isEmpty()) {
            for (OMAttribute oma : axis2Attrs) {
                Name name = null;
                OMNamespace omnamespace = oma.getNamespace();
                name = omnamespace != null ? ibmSOAPFactory.createName(oma.getLocalName(), oma.getNamespace().getPrefix(), oma.getNamespace().getNamespaceURI()) : ibmSOAPFactory.createName(oma.getLocalName());
                ibmAttrs.put(name, oma.getAttributeValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAxis2Attributes", ibmAttrs);
        }
        return ibmAttrs;
    }

    protected static AttributedURI fromAxis2(String axis2String) throws URISyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "fromAxis2", new Object[]{axis2String});
        }
        AttributedURI ibmAttributedURI = null;
        if (axis2String != null) {
            URI uri = new URI(axis2String);
            ibmAttributedURI = WSAddressingFactory.createAttributedURI(uri);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "fromAxis2", ibmAttributedURI);
        }
        return ibmAttributedURI;
    }

    static {
        try {
            omFactory = OMAbstractFactory.getOMFactory();
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter.<static>", "1:150:1.7");
        }
    }
}

