/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws.converters;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import com.ibm.ws.wsaddressing.jaxws.JaxwsReferenceParameterReader;
import com.ibm.ws.wsaddressing.jaxws.converters.AttributedURIConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyAttributedURIImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.LazyEndpointReferenceImpl;
import com.ibm.ws.wsaddressing.jaxws.converters.RelationshipSetConverter;
import com.ibm.ws.wsaddressing.jaxws.converters.WSAContextMigrator;
import com.ibm.ws.wsaddressing.jaxws21.client.config.AddressingConfigurator;
import com.ibm.ws.wsaddressing.jaxws21.factory.impl.Axis2EndpointReferenceFactoryImpl;
import com.ibm.ws.wsaddressing.jaxws21.factory.impl.JAXWSEndpointReferenceFactoryImpl;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.addressing.factory.Axis2EndpointReferenceFactory;
import org.apache.axis2.jaxws.addressing.factory.JAXWSEndpointReferenceFactory;
import org.apache.axis2.jaxws.registry.ClientConfiguratorRegistry;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.ThreadContextMigrator;
import org.apache.axis2.util.Utils;

public class AddressingPropertiesMigrator
implements ThreadContextMigrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.wsaddressing.jaxws.CWWARMessages");
    private static final TraceComponent TRACE_COMPONENT = Tr.register(AddressingPropertiesMigrator.class, "WS-Addressing", "com.ibm.ws.wsaddressing.jaxws.CWWARMessages");

    public AddressingPropertiesMigrator() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "<init>");
            Tr.exit(TRACE_COMPONENT, "<init>", this);
        }
    }

    public void migrateContextToThread(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migrateContextToThread", new Object[]{messageContext});
        }
        if (JavaUtils.isTrueExplicitly(messageContext.getProperty("IsAddressingProcessed"))) {
            this.convertAxis2ToIbm(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migrateContextToThread");
        }
    }

    public void cleanupThread(MessageContext messageContext) {
        AxisOperation axisOperation;
        String mep;
        int mepConstant;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cleanupThread", new Object[]{messageContext});
        }
        if ((mepConstant = Utils.getAxisSpecifMEPConstant(mep = (axisOperation = messageContext.getAxisOperation()).getMessageExchangePattern())) == 10 || mepConstant == 12 || mepConstant == 13 || mepConstant == 11) {
            JaxwsReferenceParameterReader.removeThreadLocalMessageContext();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "cleanupThread");
        }
    }

    public void migrateThreadToContext(MessageContext messageContext) throws AxisFault {
        AxisOperation axisOperation;
        String mep;
        int mepConstant;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "migrateThreadToContext", new Object[]{messageContext});
        }
        if ((mepConstant = Utils.getAxisSpecifMEPConstant(mep = (axisOperation = messageContext.getAxisOperation()).getMessageExchangePattern())) == 12 || mepConstant == 13 || mepConstant == 11) {
            if (JavaUtils.isFalseExplicitly(messageContext.getProperty("disableAddressingForOutMessages"))) {
                WSAContextMigrator.WSAProperties props = this.getServerSideProperties(messageContext);
                this.convertIbmToAxis2(messageContext, props);
            }
        } else {
            WSAClientConfig config2 = this.getWSAClientConfig(messageContext);
            if (config2.sendAddressing) {
                if (config2.isAsync) {
                    messageContext.getOptions().setUseSeparateListener(true);
                } else {
                    messageContext.getOptions().setUseSeparateListener(false);
                }
                this.checkEPRRelatedProperties(messageContext, config2.properties, mepConstant);
                this.convertIbmToAxis2(messageContext, config2.properties);
            }
            messageContext.setProperty("disableAddressingForOutMessages", !config2.sendAddressing);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "migrateThreadToContext");
        }
    }

    private WSAContextMigrator.WSAProperties getServerSideProperties(MessageContext responseContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getServerSideProperties", new Object[]{responseContext, this});
        }
        MessageContext requestContext = responseContext.getOperationContext().getMessageContext("In");
        WSAContextMigrator.WSAProperties props = new WSAContextMigrator.WSAProperties();
        if (requestContext != null) {
            props.destinationEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(requestContext, "com.ibm.websphere.wsaddressing.destinationEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            props.fromEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.fromEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            props.replyToEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.replyToEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            props.faultToEPR = (com.ibm.ws.wsaddressing.integration.EndpointReference)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.faultToEPR", com.ibm.ws.wsaddressing.integration.EndpointReference.class);
            props.action = (AttributedURI)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.action", AttributedURI.class);
            props.messageID = (AttributedURI)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.messageId", AttributedURI.class);
            props.version = (String)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.OutboundNamespace", String.class);
            props.relationships = (Set)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.relationshipSet", Set.class);
            props.addMustUnderstand = (Boolean)this.getProperty(requestContext, "com.ibm.wsspi.wsaddressing.mustunderstand", Boolean.class);
        }
        if (props.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getServerSideProperties", null);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getServerSideProperties", props);
        }
        return props;
    }

    private Object getProperty(MessageContext context, String propertyName, Class clazz) {
        Object object = context.getProperty(propertyName);
        if (object != null && !clazz.isInstance(object)) {
            throw new WebServiceException(nls.getFormattedMessage("INCORRECT_IBM_TYPE_CWWAR0101", new Object[]{propertyName, clazz, object.getClass()}, null));
        }
        return object;
    }

    public void cleanupContext(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "cleanupContext", new Object[]{messageContext});
            Tr.exit(TRACE_COMPONENT, "cleanupContext");
        }
    }

    private void convertAxis2EPRToIbmEPR(EndpointReference axis2EPR, String propertyName, MessageContext messageContext, String addressingNamespace) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2EPRToIbmEPR", new Object[]{axis2EPR, propertyName, messageContext, addressingNamespace});
        }
        if (axis2EPR != null) {
            LazyEndpointReferenceImpl ibmepr = new LazyEndpointReferenceImpl(axis2EPR, addressingNamespace);
            messageContext.setProperty(propertyName, ibmepr);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2EPRToIbmEPR");
        }
    }

    private void convertAxis2ActionToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2ActionToIbmAttributedURI", new Object[]{messageContext});
        }
        String axis2String = messageContext.getWSAAction();
        ArrayList axis2attrs = (ArrayList)messageContext.getProperty("actionAttributes");
        if (axis2String != null) {
            LazyAttributedURIImpl ivmauri = new LazyAttributedURIImpl(axis2String, axis2attrs);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.Action", ivmauri);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2ActionToIbmAttributedURI");
        }
    }

    private void convertAxis2MessageIDToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2MessageIDToIbmAttributedURI", new Object[]{messageContext});
        }
        String axis2String = messageContext.getMessageID();
        ArrayList axis2attrs = (ArrayList)messageContext.getProperty("messageidAttributes");
        if (axis2String != null) {
            LazyAttributedURIImpl ivmauri = new LazyAttributedURIImpl(axis2String, axis2attrs);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID", ivmauri);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2MessageIDToIbmAttributedURI");
        }
    }

    private void convertAxis2ToEPRToIbmAttributedURI(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2StringToIbmAttributedURI", new Object[]{messageContext});
        }
        String axis2String = null;
        ArrayList axis2attrs = null;
        EndpointReference axis2EPR = messageContext.getTo();
        if (axis2EPR != null) {
            axis2String = axis2EPR.getAddress();
            axis2attrs = axis2EPR.getAddressAttributes();
        }
        if (axis2String != null) {
            LazyAttributedURIImpl ivmauri = new LazyAttributedURIImpl(axis2String, axis2attrs);
            messageContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.To", ivmauri);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2StringToIbmAttributedURI");
        }
    }

    private void convertAxis2RelatesToArrayToIbmRelationshipSet(String propertyName, MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2RelatesToArrayToIbmRelationshipSet", new Object[]{propertyName, messageContext});
        }
        RelatesTo[] axis2RelatesToArray = messageContext.getRelationships();
        Set ibmRelationshipSet = null;
        if (axis2RelatesToArray != null) {
            try {
                ibmRelationshipSet = RelationshipSetConverter.fromAxis2Lazy(axis2RelatesToArray);
                messageContext.setProperty(propertyName, ibmRelationshipSet);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass() + ".convertAxis2RelatesToArrayToIbmRelationshipSet", "1:355:1.44", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an Axis2 relateTo array to an IBM relationship set.", e);
                }
                throw new AxisFault(nls.getString("RELATIONSHIP_CONVERSION_ERROR_CWWAR0106"), e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2RelatesToArrayToIbmRelationshipSet");
        }
    }

    private void convertAxis2ToIbm(MessageContext messageContext) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertAxis2ToIbm", new Object[]{messageContext});
        }
        Object object = messageContext.getProperty("WSAddressingVersion");
        String addressingNamespace = null;
        if (object != null && !(object instanceof String)) {
            throw new AxisFault(nls.getFormattedMessage("INCORRECT_AXIS2_TYPE_CWWAR0107", new Object[]{"WSAddressingVersion", String.class, object.getClass()}, null));
        }
        addressingNamespace = (String)object;
        messageContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", object);
        this.convertAxis2EPRToIbmEPR(messageContext.getFrom(), "com.ibm.wsspi.wsaddressing.inbound.FromEPR", messageContext, addressingNamespace);
        this.convertAxis2EPRToIbmEPR(messageContext.getReplyTo(), "com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", messageContext, addressingNamespace);
        this.convertAxis2EPRToIbmEPR(messageContext.getFaultTo(), "com.ibm.wsspi.wsaddressing.inbound.FaultToEPR", messageContext, addressingNamespace);
        this.convertAxis2ActionToIbmAttributedURI(messageContext);
        this.convertAxis2MessageIDToIbmAttributedURI(messageContext);
        this.convertAxis2ToEPRToIbmAttributedURI(messageContext);
        this.convertAxis2RelatesToArrayToIbmRelationshipSet("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet", messageContext);
        AxisOperation axisOperation = messageContext.getAxisOperation();
        String mep = axisOperation.getMessageExchangePattern();
        int mepConstant = Utils.getAxisSpecifMEPConstant(mep);
        if (mepConstant == 10 || mepConstant == 12 || mepConstant == 13 || mepConstant == 11) {
            JaxwsReferenceParameterReader.setThreadLocalMessageContext(messageContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertAxis2ToIbm");
        }
    }

    private void convertIbmToAxis2(MessageContext messageContext, WSAContextMigrator.WSAProperties props) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "convertIbmToAxis2", new Object[]{messageContext});
        }
        if (props != null) {
            Object version;
            try {
                EndpointReference axis2EPR = null;
                if (props.destinationEPR != null) {
                    axis2EPR = EndpointReferenceConverter.toAxis2(props.destinationEPR);
                    messageContext.setTo(axis2EPR);
                    messageContext.setProperty("WSAddressingVersion", props.destinationEPR.getNamespace());
                }
                if (props.replyToEPR != null) {
                    axis2EPR = EndpointReferenceConverter.toAxis2(props.replyToEPR);
                    messageContext.setReplyTo(axis2EPR);
                }
                if (props.faultToEPR != null) {
                    axis2EPR = EndpointReferenceConverter.toAxis2(props.faultToEPR);
                    messageContext.setFaultTo(axis2EPR);
                }
                if (props.fromEPR != null) {
                    axis2EPR = EndpointReferenceConverter.toAxis2(props.fromEPR);
                    messageContext.setFrom(axis2EPR);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass() + ".convertIbmToAxis2", "1:435:1.44", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM endpoint reference to an Axis2 endpoint reference.", e);
                }
                throw new AxisFault(nls.getString("EPR_CONVERSION_ERROR_CWWAR0102"), e);
            }
            try {
                ArrayList<OMAttribute> omattrs;
                String axis2String;
                if (props.action != null) {
                    axis2String = AttributedURIConverter.toAxis2(props.action);
                    omattrs = AttributedURIConverter.getAxis2Attributes(props.action);
                    String soapAction = null;
                    Boolean useSoapAction = (Boolean)messageContext.getProperty("javax.xml.ws.soap.http.soapaction.use");
                    if (useSoapAction != null && useSoapAction.booleanValue()) {
                        soapAction = (String)messageContext.getProperty("javax.xml.ws.soap.http.soapaction.uri");
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction from MessageContext property: " + soapAction);
                        }
                    }
                    if (soapAction == null) {
                        soapAction = messageContext.getSoapAction();
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction from MessageContext method: " + soapAction);
                        }
                    }
                    if (!(soapAction == null || "".equals(soapAction.trim()) || axis2String == null || "".equals(axis2String.trim()) || messageContext.isServerSide() || axis2String.trim().equals(soapAction.trim()))) {
                        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "SOAPAction and wsa:Action do not match. SOAPAction: " + soapAction + ", wsa:Action: " + axis2String);
                        }
                        throw new AxisFault(nls.getFormattedMessage("ACTION_MISMATCH_CWWAR0105", new Object[]{soapAction, axis2String}, null));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "Setting wsa:Action: " + axis2String);
                    }
                    messageContext.setWSAAction(axis2String);
                    messageContext.setProperty("actionAttributes", omattrs);
                }
                if (props.messageID != null) {
                    axis2String = AttributedURIConverter.toAxis2(props.messageID);
                    omattrs = AttributedURIConverter.getAxis2Attributes(props.messageID);
                    messageContext.setMessageID(axis2String);
                    messageContext.setProperty("messageidAttributes", omattrs);
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, this.getClass() + ".convertIbmToAxis2", "1:494:1.44", this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM attributed URI to an Axis2 string.", e);
                }
                throw new AxisFault(nls.getString("URI_CONVERSION_ERROR_CWWAR0104"), e);
            }
            if (props.relationships != null) {
                try {
                    RelatesTo[] axis2RelatesToArray = RelationshipSetConverter.toAxis2(props.relationships);
                    messageContext.setRelationships(axis2RelatesToArray);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, this.getClass() + ".convertIbmToAxis2", "1:508:1.44", this);
                    if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "A problem occurred during conversion from an IBM relationship set to an Axis2 relatesTo array.", e);
                    }
                    throw new AxisFault(nls.getString("RELATIONSHIP_CONVERSION_ERROR_CWWAR0106"), e);
                }
            }
            if ((version = messageContext.getProperty("WSAddressingVersion")) != null && props.version != null && !version.equals(props.version)) {
                throw new AxisFault(nls.getFormattedMessage("NAMESPACE_MISMATCH_CWWAR0108", new Object[]{props.version, "com.ibm.wsspi.wsaddressing.OutboundNamespace", version, "com.ibm.websphere.wsaddressing.destinationEPR"}, null));
            }
            if (props.version != null) {
                messageContext.setProperty("WSAddressingVersion", props.version);
            }
            if (props.addMustUnderstand != null) {
                messageContext.setProperty("addMustUnderstandToAddressingHeaders", props.addMustUnderstand);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "convertIbmToAxis2");
        }
    }

    private void checkEPRRelatedProperties(MessageContext messageContext, WSAContextMigrator.WSAProperties props, int mepConstant) throws AxisFault {
        boolean is2way;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "checkEPRRelatedProperties", new Object[]{messageContext});
        }
        boolean bl = is2way = mepConstant == 16 || mepConstant == 17 || mepConstant == 15;
        if (props != null && is2way) {
            com.ibm.ws.wsaddressing.integration.EndpointReference faultTo;
            com.ibm.ws.wsaddressing.integration.EndpointReference replyTo;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Performing epr check on: ReplyTo");
            }
            if ((replyTo = (com.ibm.ws.wsaddressing.integration.EndpointReference)props.replyToEPR) != null) {
                if (messageContext.getOptions().isUseSeparateListener()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
                if (!replyTo.validate()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
                if (!replyTo.isAnonymousURI()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.replyToEPR"}, null));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Performing epr check on: FaultTo");
            }
            if ((faultTo = (com.ibm.ws.wsaddressing.integration.EndpointReference)props.faultToEPR) != null) {
                if (messageContext.getOptions().isUseSeparateListener()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
                if (!faultTo.validate()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
                if (!faultTo.isAnonymousURI()) {
                    throw new AxisFault(nls.getFormattedMessage("UNAVAILABLE_PROPERTY_CWWAR0100", new Object[]{"com.ibm.wsspi.wsaddressing.faultToEPR"}, null));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "checkEPRRelatedProperties");
        }
    }

    private WSAClientConfig getWSAClientConfig(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSAClientConfig", new Object[]{messageContext, this});
        }
        WSAClientConfig result = new WSAClientConfig();
        Boolean addressingDisabled = (Boolean)messageContext.getProperty("disableAddressingForOutMessages");
        boolean configuredForAsyncByProperty = messageContext.getOptions().isUseSeparateListener();
        String addressingFlagFromWSDL = this.getAddressingFlagFromWSDL(messageContext.getAxisOperation());
        String wsaddressingFlagFromPolicySet = "unspecified";
        String wsaMode = null;
        PolicySetConfiguration policySet = this.getPolicySetConfiguration(messageContext);
        if (policySet != null) {
            wsaddressingFlagFromPolicySet = (String)policySet.getPolicyTypeConfiguration(Constants.POLICY_TYPE_CONFIGURATION_KEY);
            wsaMode = (String)policySet.getPolicyTypeConfiguration("wsaMode");
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addressingFlagFromWSDL=" + addressingFlagFromWSDL + " wsaddressingFlagFromPolicySet=" + wsaddressingFlagFromPolicySet + " wsaMode=" + wsaMode + " configuredForAsyncByProperty=" + configuredForAsyncByProperty);
        }
        if (addressingFlagFromWSDL == null) {
            addressingFlagFromWSDL = "unspecified";
        }
        if (wsaddressingFlagFromPolicySet == null) {
            wsaddressingFlagFromPolicySet = "unspecified";
        }
        result.properties = (WSAContextMigrator.WSAProperties)messageContext.getProperty(WSAContextMigrator.WSAProperties.WSA_PROPERTIES);
        boolean bl = result.isAsync = wsaMode != null && !"WSA_BOTH".equals(wsaMode) ? "WSA_ASYNC".equals(wsaMode) : configuredForAsyncByProperty;
        if (configuredForAsyncByProperty && "WSA_SYNC".equals(wsaMode) && TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "useAsyncMEP property overridden by PolicySet/WS-Policy 'Synchronous Only' configuration.");
        }
        if (addressingDisabled == null) {
            result.sendAddressing = result.isAsync || result.properties != null || !"unspecified".equals(addressingFlagFromWSDL) || !"unspecified".equals(wsaddressingFlagFromPolicySet);
        } else {
            boolean bl2 = result.sendAddressing = result.isAsync || result.properties != null || !"unspecified".equals(wsaddressingFlagFromPolicySet) || addressingDisabled == false;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSAClientConfig", result);
        }
        return result;
    }

    private PolicySetConfiguration getPolicySetConfiguration(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getPolicySetConfiguration", new Object[]{messageContext, this});
        }
        Parameter configParam = messageContext.getParameter("WASAxis2PolicySet");
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "PolicySet configParam: " + configParam);
        }
        PolicySetConfiguration policySet = null;
        if (configParam != null && configParam.getValue() != null) {
            policySet = (PolicySetConfiguration)configParam.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getPolicySetConfiguration", policySet);
        }
        return policySet;
    }

    private String getAddressingFlagFromWSDL(AxisDescription ad) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getAddressingFlagFromWSDL", new Object[]{ad});
        }
        String addressingFlagFromWSDL = AddressingHelper.getAddressingRequirementParemeterValue(ad);
        Parameter param = ad.getParameter("originalWSDLConfig");
        if (param != null) {
            addressingFlagFromWSDL = (String)param.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getAddressingFlagFromWSDL", addressingFlagFromWSDL);
        }
        return addressingFlagFromWSDL;
    }

    static {
        JAXWSEndpointReferenceFactoryImpl jaxwsEPRFactory = new JAXWSEndpointReferenceFactoryImpl();
        FactoryRegistry.setFactory(JAXWSEndpointReferenceFactory.class, jaxwsEPRFactory);
        Axis2EndpointReferenceFactoryImpl axis2EPRFactory = new Axis2EndpointReferenceFactoryImpl();
        FactoryRegistry.setFactory(Axis2EndpointReferenceFactory.class, axis2EPRFactory);
        AddressingConfigurator clientConfigurator = new AddressingConfigurator();
        ClientConfiguratorRegistry.setConfigurator("http://www.w3.org/2005/08/addressing/module", clientConfigurator);
        ClientConfiguratorRegistry.setConfigurator("http://schemas.xmlsoap.org/ws/2004/08/addressing", clientConfigurator);
    }

    private class WSAClientConfig {
        public boolean sendAddressing;
        public boolean isAsync;
        public WSAContextMigrator.WSAProperties properties;

        private WSAClientConfig() {
        }

        public String toString() {
            return "sendAddressing=" + this.sendAddressing + " isAsync=" + this.isAsync + " properties=" + this.properties;
        }
    }
}

