/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.ws.wsaddressing.jaxws.Constants;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.TargetResolver;

public class WSATargetResolver
implements TargetResolver {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSATargetResolver.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public WSATargetResolver() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "WSATargetResolver<init>");
        }
    }

    public void resolveTarget(MessageContext messageContext) {
        OMElement vHostRefParam;
        EndpointReference wsaTo;
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "resolveTarget", messageContext);
        }
        if ((wsaTo = messageContext.getTo()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "No wsa:To EPR found so no Routing Information");
            }
            return;
        }
        Map referenceParameters = wsaTo.getAllReferenceParameters();
        if (referenceParameters == null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "No ReferenceParameters so no Routing Information");
            }
            return;
        }
        OMElement intermediaryPresentElement = (OMElement)referenceParameters.get(Constants.INTERMEDIARY_PRESENT_QNAME);
        if (intermediaryPresentElement != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "resolveTarget", "IntermediaryPresent element found. No properties added.");
            }
            return;
        }
        OMElement riRefParam = (OMElement)referenceParameters.get(Constants.ROUTING_INFORMATION_QNAME);
        if (riRefParam != null) {
            OMElement routingElement;
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "resolveTarget", "RoutingInformation reference parameter found");
            }
            if ((routingElement = riRefParam.getFirstElement()) != null) {
                QName elementQName = routingElement.getQName();
                String textContent = routingElement.getText();
                if (textContent != null) {
                    textContent = textContent.trim();
                }
                if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "resolveTarget", "Child of RoutingInformation reference parameter found: " + elementQName + " " + textContent);
                }
                Object identity = UCFRoutingHelper.getClusterIdentityFromString(textContent);
                if (Constants.AFFINITY_ROUTING_KEY.equals(elementQName)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "HA");
                    }
                } else if (Constants.WLM_ROUTING_KEY.equals(elementQName)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "WLM");
                    }
                } else if (Constants.FRAGILE_ROUTING_KEY.equals(elementQName)) {
                    if (identity != null) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.identity", identity);
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "Fragile");
                    } else if ("Fragile".equals(textContent)) {
                        messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.routingType", "Fragile");
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "resolveTarget", "Child of RoutingInformation reference parameter not recognised.");
                }
            }
        }
        if ((vHostRefParam = (OMElement)referenceParameters.get(Constants.VIRTUAL_HOST_QNAME)) != null) {
            String textContext = vHostRefParam.getText();
            if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "resolveTarget", "VirtualHostName ReferenceParameter found. Value: '" + textContext + "'");
            }
            if (textContext != null && !"".equals(textContext.trim())) {
                messageContext.setProperty("com.ibm.ws.wsaddressing.jaxws.destinationEPR.virtualHostName", textContext.trim());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "resolveTarget");
        }
    }
}

