/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.jaxws;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;

public abstract class EndpointReferenceConverter {
    private static EndpointReferenceConverter _delegatedHelper = null;
    private static final String CONCRETE_HELPER_CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.converters.EndpointReferenceConverter";
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.jaxws.EndpointReferenceConverter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(EndpointReferenceConverter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public static EndpointReference createEndpointReferenceFromOMElement(OMElement omelement) throws EndpointReferenceCreationException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "createEndpointReferenceFromOMElement", omelement);
        }
        EndpointReference epr = _delegatedHelper.createEndpointReferenceFromOMElementImpl(omelement);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "createEndpointReferenceFromOMElement", epr);
        }
        return epr;
    }

    protected abstract EndpointReference createEndpointReferenceFromOMElementImpl(OMElement var1) throws EndpointReferenceCreationException;

    public static OMElement serializeEndpointReference(EndpointReference epr, QName qname) throws WebServiceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "serializeEndpointReference", new Object[]{epr, qname});
        }
        OMElement ome = _delegatedHelper.serializeEndpointReferenceImpl(epr, qname);
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "serializeEndpointReference", ome);
        }
        return ome;
    }

    protected abstract OMElement serializeEndpointReferenceImpl(EndpointReference var1, QName var2) throws WebServiceException;

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new " + CONCRETE_HELPER_CLASSNAME + " instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:401:1.12");
    }

    static {
        try {
            _delegatedHelper = (EndpointReferenceConverter)Class.forName(CONCRETE_HELPER_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            EndpointReferenceConverter.traceAndFFDCException(e);
        }
    }
}

