/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.integration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.integration.EndpointMap;
import com.ibm.ws.wsaddressing.integration.ReferenceParameterReader;

public abstract class Registry {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.integration.Registry";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(Registry.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    protected static final Registry _registry;
    private static final String IMPL_CLASSNAME = "com.ibm.ws.wsaddressing.integration.RegistryImpl";

    private static void traceAndFFDCException(Exception e) {
        String exceptionName = e.getClass().getName();
        String exceptionMessage = e.getMessage();
        String message = "Caught a " + exceptionName + ": " + exceptionMessage + " when trying to create a new concrete Registry instance within a static initializer";
        Tr.warning(TRACE_COMPONENT, message);
        FFDCFilter.processException(e, CLASSNAME, "1:74:1.3");
    }

    public static ReferenceParameterReader getCombinedReferenceParameterReader() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCombinedReferenceParameterReader");
        }
        ReferenceParameterReader result = _registry.getCombinedReferenceParameterReaderImpl();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCombinedReferenceParameterReader", result);
        }
        return result;
    }

    public static void addReferenceParameterReader(ReferenceParameterReader rpr) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameterReader");
        }
        _registry.addReferenceParameterReaderImpl(rpr);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameterReader");
        }
    }

    public static void removeReferenceParameterReader(ReferenceParameterReader rpr) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeReferenceParameterReader");
        }
        _registry.removeReferenceParameterReaderImpl(rpr);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeReferenceParameterReader");
        }
    }

    abstract ReferenceParameterReader getCombinedReferenceParameterReaderImpl();

    abstract void addReferenceParameterReaderImpl(ReferenceParameterReader var1);

    abstract void removeReferenceParameterReaderImpl(ReferenceParameterReader var1);

    public static EndpointMap getCombinedEndpointMap() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getCombinedEndpointMap");
        }
        EndpointMap result = _registry.getCombinedEndpointMapImpl();
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getCombinedEndpointMap", result);
        }
        return result;
    }

    public static void addEndpointMap(EndpointMap map) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addEndpointMap");
        }
        _registry.addEndpointMapImpl(map);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEndpointMap");
        }
    }

    public static void removeEndpointMap(EndpointMap map) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeEndpointMap");
        }
        _registry.removeEndpointMapImpl(map);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeEndpointMap");
        }
    }

    abstract EndpointMap getCombinedEndpointMapImpl();

    abstract void addEndpointMapImpl(EndpointMap var1);

    abstract void removeEndpointMapImpl(EndpointMap var1);

    static {
        Registry r = null;
        try {
            r = (Registry)Class.forName(IMPL_CLASSNAME).newInstance();
        }
        catch (InstantiationException e) {
            Registry.traceAndFFDCException(e);
        }
        catch (IllegalAccessException e) {
            Registry.traceAndFFDCException(e);
        }
        catch (ClassNotFoundException e) {
            Registry.traceAndFFDCException(e);
        }
        _registry = r;
    }
}

