/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.integration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.ReferenceParameterCreationException;
import com.ibm.ws.wsaddressing.integration.ReferenceParameterReader;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;

public class CombinedReferenceParameterReader
implements ReferenceParameterReader {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(CombinedReferenceParameterReader.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private ArrayList readers = new ArrayList();

    public String getReferenceParameterFromMessageContext(QName name) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", name);
        }
        String result = null;
        Iterator iter = this.readers.iterator();
        while (iter.hasNext() && result == null) {
            ReferenceParameterReader rpr = (ReferenceParameterReader)iter.next();
            result = rpr.getReferenceParameterFromMessageContext(name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromMessageContext", result);
        }
        return result;
    }

    public SOAPElement getSOAPElementReferenceParameterFromMessageContext(QName name) throws ReferenceParameterCreationException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", name);
        }
        SOAPElement result = null;
        Iterator iter = this.readers.iterator();
        while (iter.hasNext() && result == null) {
            ReferenceParameterReader rpr = (ReferenceParameterReader)iter.next();
            result = rpr.getSOAPElementReferenceParameterFromMessageContext(name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getSOAPElementReferenceParameterFromMessageContext", result);
        }
        return result;
    }

    public void addReferenceParameterReader(ReferenceParameterReader rpr) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameterReader", rpr);
        }
        this.readers.add(rpr);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameterReader");
        }
    }

    public void removeReferenceParameterReader(ReferenceParameterReader rpr) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "removeReferenceParameterReader", rpr);
        }
        this.readers.remove(rpr);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "removeReferenceParameterReader");
        }
    }
}

