/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.DestinationUnreachableException;
import com.ibm.ws.wsaddressing.InvalidMultipleElementException;
import com.ibm.ws.wsaddressing.handlers.ActionSpecifier;
import com.ibm.ws.wsaddressing.handlers.MAPReader;
import com.ibm.ws.wsaddressing.handlers.MAPWriter;
import com.ibm.ws.wsaddressing.handlers.UsingAddressingHelper;
import com.ibm.ws.wsaddressing.handlers.WSACommonHandler;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.webservices.rpc.handler.RPCContext;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.EndpointReferenceManager;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class WSAddressingClientHandler
extends WSACommonHandler {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(WSAddressingClientHandler.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private boolean wsAddressingDisabled = false;

    public boolean handleRequest(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleRequest", jaxRpcMsgContext);
        }
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "WSA Disabled, return true;");
            }
            return true;
        }
        SOAPMessageContext soapMessageContext = null;
        if (!(jaxRpcMsgContext instanceof SOAPMessageContext)) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "No SoapMessageContext, return true;");
            }
            return true;
        }
        soapMessageContext = (SOAPMessageContext)jaxRpcMsgContext;
        WSAOutboundProperties wsaOutboundProperties = new WSAOutboundProperties();
        boolean wsaPropertyExists = wsaOutboundProperties.setMessageContext(jaxRpcMsgContext);
        boolean shouldSendWSAddressingBasedOnWSDL = UsingAddressingHelper.shouldSendWSAddressingBasedOnWSDL(jaxRpcMsgContext);
        if (!wsaPropertyExists && !shouldSendWSAddressingBasedOnWSDL) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "handleRequest", "Addressing not mandated and no WSA properties set - WSA handler exiting early. ");
            }
            jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.disabled", Boolean.TRUE);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest: [true]");
            }
            return true;
        }
        wsaOutboundProperties.setupWSAProperties();
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that wsaPropertyExists = " + wsaPropertyExists);
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that shouldSendWSAddressingBasedOnWSDL = " + shouldSendWSAddressingBasedOnWSDL);
            Tr.debug(TRACE_COMPONENT, "handleRequest", "WSAddressing handler determined that WSA is enabled for this message");
        }
        AttributedURI wsaAction = wsaOutboundProperties.getWsaddressingAction();
        RPCContext rpcContext = (RPCContext)((Object)jaxRpcMsgContext);
        ActionSpecifier actionSpecifier = new ActionSpecifier(rpcContext);
        String soapAction = rpcContext.getSOAPActionURI();
        if (wsaAction == null) {
            wsaAction = actionSpecifier.getActionForInputMessageFromWSDL();
            wsaOutboundProperties.setWsaddressingAction(wsaAction);
        }
        if (wsaAction == null) {
            throw new JAXRPCException("Unable to establish a value for the mandatory WS-Addressing [action] MAP. Either specify the [action]using the WSADDRESSING_ACTION property or configure the client DII using the service's WSDL");
        }
        String wsaActionString = wsaAction.getURI().toString();
        actionSpecifier.soapActionMustMatch(soapAction, wsaActionString);
        MAPWriter writer = new MAPWriter();
        SOAPHeader soapHeader = null;
        try {
            soapHeader = writer.getSOAPHeaderFromMessageContext(soapMessageContext);
        }
        catch (SOAPException e1) {
            FFDCFilter.processException((Throwable)e1, "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler.handleRequest", "1:220:1.96", (Object)e1);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "SOAPException whilst trying to retrieve or add a SOAPHeader to this SOAPMessage.");
            }
            throw new JAXRPCException(e1);
        }
        this.optimiseReplyAndFaultIfPossible((com.ibm.ws.webservices.engine.MessageContext)jaxRpcMsgContext, wsaOutboundProperties);
        NamespaceData namespaceData = wsaOutboundProperties.getNamespaceData();
        try {
            writer.addNamespaceDeclarationToSOAPEnvelope(soapMessageContext, namespaceData);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.wsaddressing.handlers.WSAddressingClientHandler.handleRequest", "1:235:1.96", (Object)e);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "handleRequest", "SOAPException whilst trying to add namespace declaration to SOAPEnvelope.");
            }
            throw new JAXRPCException(e);
        }
        writer.addPropertiesToSoapHeader(soapHeader, wsaOutboundProperties);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleRequest", Boolean.TRUE);
        }
        return true;
    }

    public boolean handleResponse(MessageContext jaxRpcMsgContext) {
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleResponse", jaxRpcMsgContext);
        }
        this.processInboundMessage(jaxRpcMsgContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext jaxRpcMsgContext) {
        if (this.isAddressingDisabled(jaxRpcMsgContext)) {
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "handleFault", jaxRpcMsgContext);
        }
        this.processInboundMessage(jaxRpcMsgContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "handleFault");
        }
        return true;
    }

    public QName[] getHeaders() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.info(TRACE_COMPONENT, "getHeaders");
        }
        return null;
    }

    private void processInboundMessage(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "processInboundMessage", jaxRpcMsgContext);
        }
        if (jaxRpcMsgContext instanceof SOAPMessageContext) {
            SOAPMessageContext inboundSOAPMessageContext = (SOAPMessageContext)jaxRpcMsgContext;
            MAPReader rm = new MAPReader();
            try {
                if (rm.setMessageContext(inboundSOAPMessageContext)) {
                    rm.addPropertiesToContext();
                }
            }
            catch (InvalidMultipleElementException e) {
                String message = "Check the contents on the SOAPHeader.  An InvalidMultipleElementException was thrown.  This is invalid according to the WS-Addressing Specification." + e.getMessage();
                Tr.warning(TRACE_COMPONENT, message);
                FFDCFilter.processException(e, CLASSNAME, "1:329:1.96");
            }
            catch (DestinationUnreachableException e) {
                String message = "A DestinationUnreachableException was thrown. This occurs when the wsaucf:RoutingInformation relates to a cluster which the processing server is not a memebr of.";
                Tr.warning(TRACE_COMPONENT, message);
                FFDCFilter.processException(e, CLASSNAME, "1:334:1.96");
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "processInboundMessage");
        }
    }

    private void optimiseReplyAndFaultIfPossible(com.ibm.ws.webservices.engine.MessageContext msgCtx, WSAOutboundProperties wsaOutboundProperties) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{msgCtx, wsaOutboundProperties};
            Tr.entry(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", parms);
        }
        com.ibm.ws.wsaddressing.integration.EndpointReference replyToEpr = (com.ibm.ws.wsaddressing.integration.EndpointReference)wsaOutboundProperties.getWsaddressingReplyToEpr();
        NamespaceData nsd = wsaOutboundProperties.getNamespaceData();
        if (nsd != null) {
            com.ibm.ws.wsaddressing.integration.EndpointReference faultToEpr;
            block16: {
                if (nsd.getNamespace().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && !msgCtx.isOneWay()) {
                    if (replyToEpr == null) {
                        AttributedURI auri = WSAddressingFactory.createAttributedURI(nsd.getAnonymousURI());
                        try {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "replyTo epr set to 2004_08 anonymous uri");
                            }
                            EndpointReference anonepr = EndpointReferenceManager.createEndpointReference(auri);
                            anonepr.setNamespace(nsd.getNamespace());
                            wsaOutboundProperties.setWsaddressingReplyToEpr(anonepr);
                        }
                        catch (EndpointReferenceCreationException e) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", e);
                            }
                            break block16;
                        }
                        catch (NamespaceNotSupportedException e) {
                            if (TRACE_COMPONENT.isDebugEnabled()) {
                                Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", e);
                            }
                            break block16;
                        }
                    }
                    if (replyToEpr.getAddress() == null || replyToEpr.getAddress().getURI() == null || "".equals(replyToEpr.getAddress().getURI().toString())) {
                        if (TRACE_COMPONENT.isDebugEnabled()) {
                            Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "replyTo address set to 2004_08 anonymous uri");
                        }
                        replyToEpr.setAddress(WSAddressingFactory.createAttributedURI(nsd.getAnonymousURI()));
                        wsaOutboundProperties.setWsaddressingReplyToEpr(replyToEpr);
                    }
                }
            }
            if ((faultToEpr = (com.ibm.ws.wsaddressing.integration.EndpointReference)wsaOutboundProperties.getWsaddressingFaultToEpr()) != null && msgCtx.isOneWay() && faultToEpr.validate() && faultToEpr.isAnonymousURI()) {
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible", "This is a synchronous fault");
                }
                wsaOutboundProperties.unsetWsaddressingFaultToEpr();
            }
        } else {
            Tr.warning(TRACE_COMPONENT, "NamespaceData object for the outbound message was null.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "optimiseReplyAndFaultIfPossible");
        }
    }

    protected boolean addressingDisabledGlobally() {
        return this.wsAddressingDisabled;
    }

    protected void setAddressingDisabledGlobally(boolean active) {
        this.wsAddressingDisabled = active;
    }
}

