/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.EndpointReferenceImpl;
import com.ibm.ws.wsaddressing.handlers.ReplyHelper;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Relationship;
import com.ibm.wsspi.wsaddressing.WSAddressingFactory;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;

public class MessagePivot {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MessagePivot";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MessagePivot.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public MessagePivot() {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "MessagePivot");
            Tr.exit(TRACE_COMPONENT, "MessagePivot");
        }
    }

    public MessageContext requestBecomesResponse(ReplyHelper replyHelper, MessageContext jaxRpcMsgContext) {
        boolean redirectReplyNotNull;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "requestBecomesResponse", jaxRpcMsgContext);
        }
        jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.NoneURI");
        Object destinationOverride = jaxRpcMsgContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (destinationOverride != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Destination override found.", destinationOverride);
            }
            if (destinationOverride instanceof EndpointReferenceImpl) {
                EndpointReferenceImpl destinationOverrideEPR = (EndpointReferenceImpl)destinationOverride;
                if (destinationOverrideEPR.isNoneURI()) {
                    jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectResponse");
                    jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                    jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.NoneResponse", destinationOverrideEPR);
                    jaxRpcMsgContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", destinationOverrideEPR);
                } else {
                    jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.RedirectResponse", destinationOverrideEPR);
                }
            }
        }
        boolean redirectFlag = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null;
        boolean bl = redirectReplyNotNull = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse") != null;
        if (redirectFlag && !redirectReplyNotNull) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Redirect cancelled because no REDIRECT_RESPONSE destination set.");
            }
            redirectFlag = false;
            jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
        }
        if (redirectFlag) {
            Object replyTo = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectResponse");
            jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", replyTo);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Used REDIRECT_RESPONSE EndpointReference for destination of response");
            }
            this.updateTargetEndpointAddress(jaxRpcMsgContext, replyTo);
        } else if (jaxRpcMsgContext.containsProperty("com.ibm.ws.wsaddressing.NoneResponse")) {
            jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.NoneURI", "true");
            Object replyTo = jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
            jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", replyTo);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "NONE_URI found for ReplyTo EndpointReference for destination of response");
            }
        } else {
            EndpointReference replyEPR = replyHelper.getSyncReplyEPR();
            if (replyEPR != null) {
                jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", replyEPR);
            } else {
                try {
                    replyEPR = replyHelper.getNamespaceData().createAnonymousEPR();
                    jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", replyEPR);
                }
                catch (EndpointReferenceCreationException e) {
                    Object[] params = new Object[]{replyHelper, jaxRpcMsgContext};
                    FFDCFilter.processException(e, "com.ibm.ws.wsaddressing.handlers.MessagePivot.requestBecomesResponse", "1:193:1.31", this, params);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "requestBecomesResponse");
                    }
                    throw new JAXRPCException(e);
                }
            }
            Object faultToObject = jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
            if (faultToObject instanceof EndpointReference) {
                Iterator it = ((com.ibm.ws.wsaddressing.integration.EndpointReference)faultToObject).getReferenceParameters();
                if (!it.hasNext()) {
                    jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
                    jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
                }
            } else {
                jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
                jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
            }
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.To");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:To removed.");
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:Reply removed.");
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.Action");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesResponse", "Inbound wsa:Action removed.");
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.RelationshipSet");
        this.inboundMessageIdBecomesReplyRelationship(jaxRpcMsgContext);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "requestBecomesResponse", jaxRpcMsgContext);
        }
        return jaxRpcMsgContext;
    }

    private void updateTargetEndpointAddress(MessageContext jaxRpcMsgContext, Object eprObject) {
        com.ibm.ws.wsaddressing.integration.EndpointReference epr;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "updateTargetEndpointAddress", new Object[]{jaxRpcMsgContext, eprObject});
        }
        if ((epr = (com.ibm.ws.wsaddressing.integration.EndpointReference)eprObject) != null) {
            AttributedURI auri = epr.getAddress();
            if (auri != null) {
                URI uri = auri.getURI();
                if (uri != null) {
                    String address = uri.toString();
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "Updated address will be : " + address);
                    }
                    ((com.ibm.ws.webservices.engine.MessageContext)jaxRpcMsgContext).setTargetEndpointAddress(address);
                } else if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "URI in EndpointReference was null.  Unable to update target address.");
                }
            } else if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "AttributedURI in EndpointReference was null.  Unable to update target address.");
            }
        } else if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "updateTargetEndpointAddress", "EndpointReference was null.  Unable to update target address.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "updateTargetEndpointAddress");
        }
    }

    public MessageContext requestBecomesFault(ReplyHelper replyHelper, MessageContext jaxRpcMsgContext) {
        boolean redirectFaultNotNull;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "requestBecomesFault", jaxRpcMsgContext);
        }
        jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.NoneURI");
        Object destinationOverride = jaxRpcMsgContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (destinationOverride != null) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Destination override found.", destinationOverride);
            }
            if (destinationOverride instanceof EndpointReferenceImpl) {
                EndpointReferenceImpl destinationOverrideEPR = (EndpointReferenceImpl)destinationOverride;
                if (destinationOverrideEPR.isNoneURI()) {
                    jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectFault");
                    jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
                    jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.NoneFault", destinationOverrideEPR);
                    jaxRpcMsgContext.setProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR", destinationOverrideEPR);
                } else {
                    jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.RedirectFault", destinationOverrideEPR);
                }
            }
        }
        boolean redirectFlag = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectRequired") != null;
        boolean bl = redirectFaultNotNull = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault") != null;
        if (redirectFlag && !redirectFaultNotNull) {
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "Redirect cancelled because no REDIRECT_FAULT destination set.");
            }
            redirectFlag = false;
            jaxRpcMsgContext.removeProperty("com.ibm.ws.wsaddressing.RedirectRequired");
        }
        if (redirectFlag) {
            Object faultTo = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.RedirectFault");
            jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", faultTo);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Used REDIRECT_FAULT EndpointReference for destination of fault");
            }
            this.updateTargetEndpointAddress(jaxRpcMsgContext, faultTo);
        } else if (jaxRpcMsgContext.containsProperty("com.ibm.ws.wsaddressing.NoneFault")) {
            jaxRpcMsgContext.setProperty("com.ibm.ws.wsaddressing.NoneURI", "true");
            Object faultTo = jaxRpcMsgContext.getProperty("com.ibm.ws.wsaddressing.NoneFault");
            jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", faultTo);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "NONE_URI found for FaultTo EndpointReference for destination of fault");
            }
        } else {
            EndpointReference faultEPR = replyHelper.getSyncFaultEPR();
            if (faultEPR != null) {
                jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", faultEPR);
            } else {
                try {
                    faultEPR = replyHelper.getNamespaceData().createAnonymousEPR();
                    jaxRpcMsgContext.setProperty("com.ibm.websphere.wsaddressing.destinationEPR", faultEPR);
                }
                catch (EndpointReferenceCreationException e) {
                    Object[] params = new Object[]{replyHelper, jaxRpcMsgContext};
                    FFDCFilter.processException(e, "com.ibm.ws.wsaddressing.handlers.MessagePivot.requestBecomesFault", "1:410:1.31", this, params);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "requestBecomesFault");
                    }
                    throw new JAXRPCException(e);
                }
            }
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.To");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Request wsa:To removed.");
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.replyToEPR");
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.ReplyToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:Reply removed.");
        }
        this.inboundMessageIdBecomesReplyRelationship(jaxRpcMsgContext);
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.faultToEPR");
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.FaultToEPR");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:FaultTo removed.");
        }
        jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.Action");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.debug(TRACE_COMPONENT, "requestBecomesFault", "Inbound wsa:Action removed.");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "requestBecomesFault", jaxRpcMsgContext);
        }
        return jaxRpcMsgContext;
    }

    private void inboundMessageIdBecomesReplyRelationship(MessageContext jaxRpcMsgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", jaxRpcMsgContext);
        }
        if (!jaxRpcMsgContext.containsProperty("com.ibm.wsspi.wsaddressing.relationshipSet")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", "no existing outbound WSADDRESSING_RELATIONSHIP_SET");
            }
            Object relatesTo = null;
            Object relatesToSet = null;
            Relationship replyRelation = null;
            Object inboundMessageId = jaxRpcMsgContext.getProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID");
            NamespaceData nsd = NamespaceData.getNamespaceDataFromContext(jaxRpcMsgContext);
            replyRelation = inboundMessageId instanceof AttributedURI ? WSAddressingFactory.createRelationship(((AttributedURI)inboundMessageId).getURI()) : WSAddressingFactory.createRelationship(nsd.getUnspecifiedMessageURI());
            replyRelation.setRelationshipType(nsd.getReplyRelationshipURI());
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            relationships.add(replyRelation);
            jaxRpcMsgContext.setProperty("com.ibm.wsspi.wsaddressing.relationshipSet", relationships);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.debug(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", replyRelation);
            }
            jaxRpcMsgContext.removeProperty("com.ibm.wsspi.wsaddressing.inbound.MessageID");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "lastMessageIdBecomesReplyRelationship", jaxRpcMsgContext);
        }
    }
}

