/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.handlers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.ReferenceParameter;
import com.ibm.ws.wsaddressing.binders.AttributedURIBinder;
import com.ibm.ws.wsaddressing.binders.EndpointReferenceTypeBinder;
import com.ibm.ws.wsaddressing.binders.RelationshipBinder;
import com.ibm.ws.wsaddressing.handlers.WSAOutboundProperties;
import com.ibm.ws.wsaddressing.namespace.NamespaceData;
import com.ibm.wsspi.wsaddressing.AttributedURI;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.Relationship;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class MAPWriter {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.handlers.MAPWriter";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(MAPWriter.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");
    private static AttributedURIBinder _attributedURIBinder = new AttributedURIBinder();
    private static RelationshipBinder _relationshipBinder = new RelationshipBinder();
    private static EndpointReferenceTypeBinder _endpointReferenceTypeBinder = new EndpointReferenceTypeBinder();

    public SOAPHeader getSOAPHeaderFromMessageContext(SOAPMessageContext soapMessageContext) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPHeaderFromMessageContext", soapMessageContext);
        }
        SOAPHeader soapHeader = null;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        if (soapMessage != null && (soapHeader = soapMessage.getSOAPHeader()) == null) {
            SOAPMessage sm = soapMessageContext.getMessage();
            SOAPPart sp = sm.getSOAPPart();
            SOAPEnvelope se = sp.getEnvelope();
            soapHeader = se.addHeader();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getSOAPHeaderFromMessageContext", soapHeader);
        }
        return soapHeader;
    }

    public void addPropertiesToSoapHeader(SOAPHeader soapHeader, WSAOutboundProperties wsaOutboundProperties) throws JAXRPCException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addPropertiesToSoapHeader", new Object[]{soapHeader, wsaOutboundProperties});
        }
        SOAPFactory soapFactory = new SOAPFactory();
        try {
            Name muName = null;
            if (wsaOutboundProperties.mustUnderstand()) {
                muName = soapFactory.createName("mustUnderstand", "soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
            }
            this.addAttributedURIToHeader(wsaOutboundProperties.getWsaddressingDestinationURI(), wsaOutboundProperties.getNamespaceData().getwsaTo(), soapHeader, soapFactory, muName);
            com.ibm.ws.wsaddressing.integration.EndpointReference epr = (com.ibm.ws.wsaddressing.integration.EndpointReference)wsaOutboundProperties.getWsaddressingDestinationEpr();
            this.addReferenceParametersToSOAPHeader(epr, soapHeader, wsaOutboundProperties);
            this.addAttributedURIToHeader(wsaOutboundProperties.getWsaddressingAction(), wsaOutboundProperties.getNamespaceData().getwsaAction(), soapHeader, soapFactory, muName);
            this.addAttributedURIToHeader(wsaOutboundProperties.getWsaddressingMessageId(), wsaOutboundProperties.getNamespaceData().getwsaMessageID(), soapHeader, soapFactory, muName);
            this.addEPRToHeader(wsaOutboundProperties.getWsaddressingFaultToEpr(), wsaOutboundProperties.getNamespaceData().getwsaFaultTo(), soapHeader, soapFactory, muName);
            this.addEPRToHeader(wsaOutboundProperties.getWsaddressingFromEpr(), wsaOutboundProperties.getNamespaceData().getwsaFrom(), soapHeader, soapFactory, muName);
            this.addEPRToHeader(wsaOutboundProperties.getWsaddressingReplyToEpr(), wsaOutboundProperties.getNamespaceData().getwsaReplyTo(), soapHeader, soapFactory, muName);
            Set relationships = wsaOutboundProperties.getWsaddressingRelationshipSet();
            if (relationships != null) {
                Iterator it = relationships.iterator();
                Name name = wsaOutboundProperties.getNamespaceData().getwsaRelatesTo();
                while (it.hasNext()) {
                    this.addRelationshipToHeader((Relationship)it.next(), name, soapHeader, soapFactory, wsaOutboundProperties, muName);
                }
            }
        }
        catch (SOAPException e1) {
            FFDCFilter.processException((Throwable)e1, "com.ibm.ws.wsaddressing.handlers.MAPWriter.addPropertiesToSoapHeader", "1:181:1.11", this);
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "addPropertiesToSoapHeader");
            }
            throw new JAXRPCException(e1);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addPropertiesToSoapHeader");
        }
    }

    private void addReferenceParametersToSOAPHeader(com.ibm.ws.wsaddressing.integration.EndpointReference destinationEPR, SOAPHeader soapHeader, WSAOutboundProperties wsaOutboundProperties) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader", destinationEPR);
        }
        if (destinationEPR != null) {
            Iterator it = destinationEPR.getReferenceParameters();
            while (it.hasNext()) {
                ReferenceParameter nextRefParamToSerialize = (ReferenceParameter)it.next();
                this.addReferenceParameterToHeader(nextRefParamToSerialize, soapHeader, wsaOutboundProperties);
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader", "The provided DestinationEPR was null");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParametersToSOAPHeader");
        }
    }

    protected void addNamespaceDeclarationToSOAPEnvelope(SOAPMessageContext soapMessageContext, NamespaceData namespaceData) throws SOAPException {
        SOAPMessage soapMessage;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope", new Object[]{soapMessageContext, namespaceData});
        }
        if ((soapMessage = soapMessageContext.getMessage()) != null && namespaceData != null) {
            SOAPPart soapPart;
            if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope", "The SOAPMessage was not null. Adding Namespace Declaration");
            }
            if ((soapPart = soapMessage.getSOAPPart()) != null) {
                SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
                soapEnvelope.addNamespaceDeclaration("wsa", namespaceData.getNamespace());
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addNameSpaceDeclarationToSOAPEnvelope");
        }
    }

    private void addEPRToHeader(EndpointReference epr, Name name, SOAPHeader outboundSoapHeader, javax.xml.soap.SOAPFactory soapFactory, Name mustUnderstand) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{epr, name, outboundSoapHeader, soapFactory};
            Tr.entry(TRACE_COMPONENT, "addEPRToHeader", parms);
        }
        if (epr != null && name != null) {
            SOAPElement replyToSoapElement = soapFactory.createElement(name);
            if (mustUnderstand != null) {
                this.addMustUnderstand(replyToSoapElement, mustUnderstand);
            }
            SOAPElement replyElement = _endpointReferenceTypeBinder.serialize(epr, replyToSoapElement, null);
            outboundSoapHeader.addChildElement(replyElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addEPRToHeader", "Either epr or name was null so no header added:" + epr + ", " + name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addEPRToHeader");
        }
    }

    private void addAttributedURIToHeader(AttributedURI auri, Name name, SOAPHeader soapHeader, javax.xml.soap.SOAPFactory soapFactory, Name mustUnderstand) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{auri, name, soapHeader, soapFactory};
            Tr.entry(TRACE_COMPONENT, "addAttributedURIToHeader", parms);
        }
        if (auri != null && name != null) {
            SOAPElement replyToSoapElement = soapFactory.createElement(name);
            if (mustUnderstand != null) {
                this.addMustUnderstand(replyToSoapElement, mustUnderstand);
            }
            SOAPElement replyElement = _attributedURIBinder.serialize(auri, replyToSoapElement, null);
            soapHeader.addChildElement(replyElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addAttributedURIToHeader", "Either auri or name was null so no header added:" + auri + ", " + name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addAttributedURIToHeader");
        }
    }

    private void addRelationshipToHeader(Relationship auri, Name name, SOAPHeader soapHeader, javax.xml.soap.SOAPFactory soapFactory, WSAOutboundProperties wsaOutboundProperties, Name mustUnderstand) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{auri, name, soapHeader, soapFactory};
            Tr.entry(TRACE_COMPONENT, "addRelationshipToHeader", parms);
        }
        if (auri != null && name != null) {
            SOAPElement replyToSoapElement = soapFactory.createElement(name);
            if (mustUnderstand != null) {
                this.addMustUnderstand(replyToSoapElement, mustUnderstand);
            }
            SOAPElement replyElement = _relationshipBinder.serialize(auri, replyToSoapElement, wsaOutboundProperties.getNamespaceData());
            soapHeader.addChildElement(replyElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addRelationshipToHeader", "Either auri or name was null so no header added:" + auri + ", " + name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addRelationshipToHeader");
        }
    }

    private void addStringToHeader(String auri, Name name, SOAPHeader soapHeader, javax.xml.soap.SOAPFactory soapFactory) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Object[] parms = new Object[]{auri, name, soapHeader, soapFactory};
            Tr.entry(TRACE_COMPONENT, "addStringToHeader", parms);
        }
        if (auri != null && name != null) {
            SOAPElement replyToSoapElement = soapFactory.createElement(name);
            replyToSoapElement.setValue(auri);
            soapHeader.addChildElement(replyToSoapElement);
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addStringToHeader", "Either auri or name was null so no header added:" + auri + ", " + name);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addStringToHeader");
        }
    }

    private void addReferenceParameterToHeader(ReferenceParameter nextRefParamToSerialize, SOAPHeader soapHeader, WSAOutboundProperties wsaOutboundProperties) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addReferenceParameterToHeader", nextRefParamToSerialize);
        }
        if (nextRefParamToSerialize != null) {
            SOAPElement refParamSoapElement = nextRefParamToSerialize.getSOAPElement();
            if (refParamSoapElement != null) {
                try {
                    Name name = wsaOutboundProperties.getNamespaceData().getwsaIsReferenceParameter();
                    if (name != null) {
                        while (refParamSoapElement.removeAttribute(name)) {
                            if (!TRACE_COMPONENT.isDebugEnabled()) continue;
                            Tr.debug(TRACE_COMPONENT, "wsa:IsReferenceParameter attribute removed before serialisation.");
                        }
                        refParamSoapElement.addAttribute(name, "true");
                    }
                    soapHeader.addChildElement(refParamSoapElement);
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", refParamSoapElement);
                    }
                }
                catch (SOAPException e) {
                    Object[] params = new Object[]{"Could not add this reference parameter to the SOAPHeader.", refParamSoapElement};
                    Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", params);
                }
            } else if (TRACE_COMPONENT.isDebugEnabled()) {
                Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", "SOAPElement was null, not adding a header");
            }
        } else if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "addReferenceParameterToHeader", "Parameter nextRefParamToSerialize was null, not adding a header");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addReferenceParameterToHeader");
        }
    }

    private void addMustUnderstand(SOAPElement soapElement, Name mustUnderstand) throws SOAPException {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addMustUnderstand");
        }
        soapElement.addAttribute(mustUnderstand, "1");
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addMustUnderstand");
        }
    }
}

