/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.UCFRoutingHelper;
import com.ibm.ws.wsaddressing.integration.EndpointReference;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCFRoutingHelperImpl
implements UCFRoutingHelper.UCFRoutingHelperInterface {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(UCFRoutingHelperImpl.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    @Override
    public Identity getWLMClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWLMClusterIdForDestinationEPR", messageContext);
        }
        String wlmClusterIdString = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.WLM_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(wlmClusterIdString, this.isUCFCallbackDisabled(messageContext));
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWLMClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    @Override
    public Identity getHAClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdForDestinationEPR", messageContext);
        }
        String wlmClusterIdString = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.AFFINITY_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(wlmClusterIdString, this.isUCFCallbackDisabled(messageContext));
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    @Override
    public boolean concreteIsDestinationEPRFragile(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteIsDestinationEPRFragile", messageContext);
        }
        boolean isFragile = false;
        String identityString = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(identityString, this.isUCFCallbackDisabled(messageContext));
        if (identity != null) {
            isFragile = true;
        } else if ("Fragile".equals(identityString)) {
            isFragile = true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteIsDestinationEPRFragile", Boolean.toString(isFragile));
        }
        return isFragile;
    }

    @Override
    public Identity getWLMClusterIdForProxy(SOAPMessageContext messageContext) {
        Map<String, Object> routingInformation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWLMClusterIdForProxy", messageContext);
        }
        Identity identity = null;
        if (messageContext != null && "WLM".equals((routingInformation = this.extractRoutingInformation(messageContext.getMessage())).get("com.ibm.ws.wsaddressing.header.routingType"))) {
            identity = (Identity)routingInformation.get("com.ibm.ws.wsaddressing.header.identity");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWLMClusterIdForProxy", identity);
        }
        return identity;
    }

    @Override
    public String getVirtualHostForProxy(SOAPMessageContext soapMessageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForProxy", soapMessageContext);
        }
        String virtualHost = null;
        if (soapMessageContext != null) {
            Map<String, Object> routingInformation = this.extractRoutingInformation(soapMessageContext.getMessage());
            virtualHost = (String)routingInformation.get("com.ibm.ws.wsaddressing.header.virtualHostName");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForProxy", virtualHost);
        }
        return virtualHost;
    }

    @Override
    public Identity getHAClusterIdForProxy(SOAPMessageContext messageContext) {
        Map<String, Object> routingInformation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdForProxy", messageContext);
        }
        Identity identity = null;
        if (messageContext != null && "HA".equals((routingInformation = this.extractRoutingInformation(messageContext.getMessage())).get("com.ibm.ws.wsaddressing.header.routingType"))) {
            identity = (Identity)routingInformation.get("com.ibm.ws.wsaddressing.header.identity");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdForProxy", identity);
        }
        return identity;
    }

    @Override
    public String getHAClusterIdStrForEndpoint(SOAPMessageContext messageContext) {
        Map<String, Object> routingInformation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getHAClusterIdStrForEndpoint", messageContext);
        }
        String clusterIdString = null;
        if (messageContext != null && "HA".equals((routingInformation = this.extractRoutingInformation(messageContext.getMessage())).get("com.ibm.ws.wsaddressing.header.routingType"))) {
            clusterIdString = (String)routingInformation.get("com.ibm.ws.wsaddressing.header.identityString");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getHAClusterIdStrForEndpoint", clusterIdString);
        }
        return clusterIdString;
    }

    @Override
    public boolean concreteIsMarkedFragileForProxy(SOAPMessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "concreteIsMarkedFragileForProxy", messageContext);
        }
        boolean isFragile = false;
        if (messageContext != null) {
            Map<String, Object> routingInformation = this.extractRoutingInformation(messageContext.getMessage());
            isFragile = "Fragile".equals(routingInformation.get("com.ibm.ws.wsaddressing.header.routingType"));
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "concreteIsMarkedFragileForProxy", isFragile);
        }
        return isFragile;
    }

    @Override
    public Identity getFragileClusterIdForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getFragileClusterIdForDestinationEPR", messageContext);
        }
        String fragileClusterIdString = this.getClusterIDStringFromDestinationEPR(messageContext, Constants.FRAGILE_ROUTING_KEY);
        Identity identity = this.getIdentityFromString(fragileClusterIdString, this.isUCFCallbackDisabled(messageContext));
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFragileClusterIdForDestinationEPR", identity);
        }
        return identity;
    }

    @Override
    public Identity getFragileClusterIdForProxy(SOAPMessageContext messageContext) {
        Map<String, Object> routingInformation;
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getFragileClusterIdForProxy", messageContext);
        }
        Identity identity = null;
        if (messageContext != null && "Fragile".equals((routingInformation = this.extractRoutingInformation(messageContext.getMessage())).get("com.ibm.ws.wsaddressing.header.routingType"))) {
            identity = (Identity)routingInformation.get("com.ibm.ws.wsaddressing.header.identity");
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getFragileClusterIdForProxy", identity);
        }
        return identity;
    }

    private String getClusterIDStringFromDestinationEPR(MessageContext messageContext, QName rp) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIDStringFromDestinationEPR", new Object[]{messageContext, rp});
        }
        SOAPElement routingInformationSE = this.getReferenceParameterFromDestinationEPR(messageContext);
        String clusterIdString = this.getStringFromSOAPElement(routingInformationSE, rp);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIDStringFromDestinationEPR", clusterIdString);
        }
        return clusterIdString;
    }

    private Identity getIdentityFromString(String strId, boolean skipActiveClusterTest) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getIdentityFromString", new Object[]{strId, skipActiveClusterTest});
        }
        if (strId == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was null, so return null");
            }
            return null;
        }
        if (strId.equals("Fragile")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "String parameter was Fragile, so return null");
            }
            return null;
        }
        Identity identity = null;
        ClusterService clusterService = ClusterServiceFactory.getClusterService();
        if (clusterService != null) {
            identity = clusterService.stringToIdentity(strId);
            if (!skipActiveClusterTest) {
                Set activeClusters = clusterService.getActiveClusterSet();
                boolean isClusterCellLocal = activeClusters.contains(identity);
                if (TRACE_COMPONENT.isDebugEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "isClusterCellLocal: " + isClusterCellLocal);
                }
                if (!isClusterCellLocal) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getIdentityFromString", "The detected Cluster Identity is not in the active clusters set so returning null");
                    }
                    return null;
                }
            }
        } else {
            String msg = "The ClusterService was not available in order to extract the clusterId for routing. ";
            Tr.error(TRACE_COMPONENT, msg);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getIdentityFromString", identity);
        }
        return identity;
    }

    private String getStringFromSOAPElement(SOAPElement element, QName expectedQName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getStringFromSOAPElement", new Object[]{element, expectedQName});
        }
        if (element == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", "SOAPElement parameter was null, so return null");
            }
            return null;
        }
        if (expectedQName == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", "QName parameter was null, so return null");
            }
            return null;
        }
        String result = null;
        if (element.getNamespaceURI().equals(expectedQName.getNamespaceURI()) && element.getLocalName().equals(expectedQName.getLocalPart())) {
            result = element.getValue();
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getStringFromSOAPElement", result);
        }
        return result;
    }

    private SOAPElement getReferenceParameterFromDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", new Object[]{messageContext});
        }
        if (messageContext != null && messageContext.containsProperty("com.ibm.websphere.wsaddressing.destinationEPR")) {
            Object msgCtxProperty = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
            if (!(msgCtxProperty instanceof com.ibm.wsspi.wsaddressing.EndpointReference)) {
                String msg = "WSAConstants.WSADDRESSING_DESTINATION_EPR property not an instance of EndpointReference";
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", msg);
                }
                return null;
            }
            EndpointReference destinationEPR = (EndpointReference)msgCtxProperty;
            if (destinationEPR != null) {
                if (destinationEPR.isIntermediaryPresent()) {
                    if (TRACE_COMPONENT.isEntryEnabled()) {
                        Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", "WSADDRESSING_DESTINATION_EPR isIntermediaryPresent() returned TRUE.  Should not add ClusterID.  Returning NULL.");
                    }
                    return null;
                }
                SOAPElement result = destinationEPR.getSOAPElementReferenceParameter(Constants.ROUTING_INFORMATION_QNAME);
                if (TRACE_COMPONENT.isEntryEnabled()) {
                    Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR", result);
                }
                return result;
            }
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getReferenceParameterFromDestinationEPR");
        }
        return null;
    }

    @Override
    public Identity getClusterIdentityFromSOAPElementText(SOAPElement soapElement) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdentityFromSOAPElementText", soapElement);
        }
        if (soapElement == null) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromSOAPElementText", "SOAPElement parameter was null, so return null");
            }
            return null;
        }
        String identityString = soapElement.getValue();
        Identity identity = this.getIdentityFromString(identityString, false);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromSOAPElementText", identity);
        }
        return identity;
    }

    @Override
    public String getVirtualHostForDestinationEPR(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getVirtualHostForDestinationEPR", messageContext);
        }
        String vHost = null;
        Object o = messageContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        if (o instanceof com.ibm.wsspi.wsaddressing.EndpointReference) {
            com.ibm.wsspi.wsaddressing.EndpointReference epr = (com.ibm.wsspi.wsaddressing.EndpointReference)o;
            vHost = epr.getReferenceParameter(Constants.VIRTUAL_HOST_QNAME);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getVirtualHostForDestinationEPR", vHost);
        }
        return vHost;
    }

    private boolean isUCFCallbackDisabled(MessageContext messageContext) {
        boolean disabled = false;
        if (messageContext instanceof com.ibm.ws.webservices.engine.MessageContext) {
            disabled = ((com.ibm.ws.webservices.engine.MessageContext)messageContext).isPropertyTrue("com.ibm.ws.wsaddressing.UCFCallback.disable");
        }
        if (TRACE_COMPONENT.isDebugEnabled()) {
            Tr.debug(TRACE_COMPONENT, "isUCFCallbackDisabled", disabled);
        }
        return disabled;
    }

    @Override
    public Object getClusterIdentityFromString(String clusterIdentityString) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getClusterIdentityFromString", clusterIdentityString);
        }
        Identity result = this.getIdentityFromString(clusterIdentityString, false);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getClusterIdentityFromString", result);
        }
        return result;
    }

    @Override
    public Map<String, Object> extractRoutingInformation(SOAPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "extractRoutingInformation", message);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        SOAPHeader header = null;
        if (message != null) {
            try {
                header = message.getSOAPHeader();
            }
            catch (SOAPException e) {
                FFDCFilter.processException((Throwable)e, this.getClass().getName() + ".extractRoutingInformation", "1:499:1.31", message);
            }
        }
        if (header != null) {
            Iterator iterator = header.getChildElements();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof SOAPElement)) continue;
                SOAPElement se = (SOAPElement)o;
                if (Constants.VIRTUAL_HOST_QNAME.equals(se.getElementQName())) {
                    String virtualHostName = se.getValue();
                    if (virtualHostName == null) continue;
                    result.put("com.ibm.ws.wsaddressing.header.virtualHostName", virtualHostName);
                    continue;
                }
                if (Constants.INTERMEDIARY_PRESENT_QNAME.equals(se.getElementQName())) {
                    result.put("com.ibm.ws.wsaddressing.header.intermediaryPresent", Boolean.TRUE);
                    continue;
                }
                if (!Constants.ROUTING_INFORMATION_QNAME.equals(se.getElementQName())) continue;
                Iterator inner = se.getChildElements();
                while (inner.hasNext()) {
                    Identity id;
                    Object o2 = inner.next();
                    if (!(o2 instanceof SOAPElement)) continue;
                    SOAPElement se2 = (SOAPElement)o2;
                    if (Constants.FRAGILE_ROUTING_KEY.equals(se2.getElementQName())) {
                        result.put("com.ibm.ws.wsaddressing.header.routingType", "Fragile");
                        id = this.getClusterIdentityFromSOAPElementText(se2);
                        if (id != null) {
                            result.put("com.ibm.ws.wsaddressing.header.identity", id);
                        }
                        result.put("com.ibm.ws.wsaddressing.header.identityString", se2.getValue());
                        continue;
                    }
                    if (Constants.AFFINITY_ROUTING_KEY.equals(se2.getElementQName())) {
                        result.put("com.ibm.ws.wsaddressing.header.routingType", "HA");
                        id = this.getClusterIdentityFromSOAPElementText(se2);
                        if (id != null) {
                            result.put("com.ibm.ws.wsaddressing.header.identity", id);
                        }
                        result.put("com.ibm.ws.wsaddressing.header.identityString", se2.getValue());
                        continue;
                    }
                    if (Constants.WLM_ROUTING_KEY.equals(se2.getElementQName())) {
                        result.put("com.ibm.ws.wsaddressing.header.routingType", "WLM");
                        id = this.getClusterIdentityFromSOAPElementText(se2);
                        if (id != null) {
                            result.put("com.ibm.ws.wsaddressing.header.identity", id);
                        }
                        result.put("com.ibm.ws.wsaddressing.header.identityString", se2.getValue());
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !TRACE_COMPONENT.isDebugEnabled()) continue;
                    Tr.debug(TRACE_COMPONENT, "Unrecognised child of RoutingInformation header", new Object[]{se2.getElementQName(), se2});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "extractRoutingInformation", result);
        }
        return result;
    }
}

