/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class NamespaceHelper {
    private static final TraceComponent TRACE_COMPONENT = Tr.register(NamespaceHelper.class, "WS-Addressing", "com.ibm.ws.wsaddressing.WSAddressingMessages");

    public boolean isNamespaceSupported(String namespace) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "isNamespaceSupported", namespace);
        }
        boolean supported = false;
        if (namespace == null || namespace.equals("")) {
            return false;
        }
        if (namespace.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") || namespace.equals("http://www.w3.org/2005/08/addressing")) {
            if (TRACE_COMPONENT.isEntryEnabled()) {
                Tr.exit(TRACE_COMPONENT, "isNamespaceSupported", "true");
            }
            return true;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "isNamespaceSupported", "false");
        }
        return false;
    }

    public String getNamespaceForChildSOAPElement(javax.xml.soap.SOAPElement soapElement, String localName) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNamespaceForChildSOAPElement", new Object[]{soapElement, localName});
        }
        String namespace = null;
        String namespaceForSOAPChild = "http://www.w3.org/2005/08/addressing";
        SOAPFactory soapFactory = null;
        soapFactory = soapElement instanceof SOAPElement ? ((SOAPElement)soapElement).getSOAPFactory() : new SOAPFactory();
        Name name = NamespaceHelper.createSOAPName(localName, soapFactory, namespaceForSOAPChild);
        Iterator iterator = soapElement.getChildElements(name);
        if (iterator.hasNext()) {
            namespace = namespaceForSOAPChild;
        }
        if (namespace == null && (iterator = soapElement.getChildElements(NamespaceHelper.createSOAPName(localName, soapFactory, namespaceForSOAPChild = "http://schemas.xmlsoap.org/ws/2004/08/addressing"))).hasNext()) {
            namespace = namespaceForSOAPChild;
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNamespaceForChildSOAPElement", namespace);
        }
        return namespace;
    }

    public String updateInboundWSANamespaceForMessageContext(SOAPHeader soapHeader, MessageContext msgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getWSANamespaceFromMessageContext", new Object[]{soapHeader, msgContext});
        }
        String result = null;
        result = (String)msgContext.getProperty("com.ibm.ws.wsaddressing.InboundNamespace");
        if (result == null) {
            ArrayList<String> namespacesFound = new ArrayList<String>();
            Iterator iter = soapHeader.getChildElements();
            while (iter.hasNext()) {
                javax.xml.soap.SOAPElement se;
                String localName;
                Object next = iter.next();
                if (!(next instanceof javax.xml.soap.SOAPElement) || (localName = (se = (javax.xml.soap.SOAPElement)next).getLocalName()) == null || !localName.equals("Action")) continue;
                namespacesFound.add(se.getNamespaceURI());
            }
            if (namespacesFound.contains("http://www.w3.org/2005/08/addressing")) {
                result = "http://www.w3.org/2005/08/addressing";
            } else {
                Iterator namespaces = namespacesFound.iterator();
                while (result == null && namespaces.hasNext()) {
                    String value = (String)namespaces.next();
                    if (!this.isNamespaceSupported(value)) continue;
                    result = value;
                }
            }
            if (result == null) {
                result = "http://www.w3.org/2005/08/addressing";
            }
        }
        msgContext.setProperty("com.ibm.ws.wsaddressing.InboundNamespace", result);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getWSANamespaceFromMessageContext", result);
        }
        return result;
    }

    public String updateOutboundWSANamespaceForMessageContext(MessageContext msgContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "updateOutboundWSANamespaceForMessageContext", msgContext);
        }
        Object outbound_namespace = msgContext.getProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace");
        Object destinationEPRObject = msgContext.getProperty("com.ibm.websphere.wsaddressing.destinationEPR");
        String result = "http://www.w3.org/2005/08/addressing";
        if (outbound_namespace instanceof String) {
            EndpointReference destinationEPR;
            String destinationEPRNamespace;
            String namespaceString = (String)outbound_namespace;
            if (!this.isNamespaceSupported(namespaceString)) {
                String message = "The WS-Addressing namespace " + outbound_namespace + " specified by the WSADDRESSING_OUTBOUND_NAMESPACE property is not supported by this implementation";
                Tr.warning(TRACE_COMPONENT, message);
                throw new JAXRPCException(message);
            }
            if (destinationEPRObject instanceof EndpointReference && !(destinationEPRNamespace = (destinationEPR = (EndpointReference)destinationEPRObject).getNamespace()).equals(namespaceString)) {
                String message = "The WS-Addressing namespace " + namespaceString + " specified by the WSADDRESSING_OUTBOUND_NAMESPACE property conflicts with the namespace of the destination EPR (specified by WSADDRESSING_DESTINATION_EPR property): " + destinationEPRNamespace;
                Tr.warning(TRACE_COMPONENT, message);
                throw new JAXRPCException(message);
            }
            result = namespaceString;
        } else if (destinationEPRObject instanceof EndpointReference) {
            EndpointReference destinationEPR = (EndpointReference)destinationEPRObject;
            result = destinationEPR.getNamespace();
        }
        msgContext.setProperty("com.ibm.wsspi.wsaddressing.OutboundNamespace", result);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "updateOutboundWSANamespaceForMessageContext", result);
        }
        return result;
    }

    private static Name createSOAPName(String localName, javax.xml.soap.SOAPFactory soapFactory, String namespace) {
        Name name = null;
        try {
            name = soapFactory.createName(localName, "wsa", namespace);
        }
        catch (SOAPException e) {
            FFDCFilter.processException((Throwable)e, Constants.class.getName() + ".createSOAPName", "1:292:1.10", localName);
        }
        return name;
    }
}

