/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wlm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public final class TypeConversion {
    private static final TraceComponent tc = Tr.register(TypeConversion.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final int CONVERSION_CONSTANT = 65536;

    public static int bytesToInt(byte[] bytes, int offset) {
        int result = 0;
        for (int i = offset; i < offset + 4; ++i) {
            result <<= 8;
            result |= bytes[i] & 0xFF;
        }
        return result;
    }

    public static short bytesToShort(byte[] bytes, int offset) {
        short result = 0;
        for (int i = offset; i < offset + 2; ++i) {
            result = (short)(result << 8);
            result = (short)(result | bytes[i] & 0xFF);
        }
        return result;
    }

    public static long bytesTolong(byte[] bytes, int offset) {
        long result = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            result <<= 8;
            result |= (long)bytes[i] & 0xFFL;
        }
        return result;
    }

    public static char[] bytesToChar(byte[] bytes) {
        int length = bytes.length;
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bytes[i];
        }
        return result;
    }

    public static byte[] charToBytes(char[] chars) {
        int length = chars.length;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)chars[i];
        }
        return result;
    }

    public static void intToBytes(int value, byte[] bytes, int offset) {
        for (int i = offset + 3; i >= offset; --i) {
            bytes[i] = (byte)value;
            value >>= 8;
        }
    }

    public static void shortToBytes(short value, byte[] bytes, int offset) {
        for (int i = offset + 1; i >= offset; --i) {
            bytes[i] = (byte)value;
            value = (short)(value >> 8);
        }
    }

    public static void longToBytes(long value, byte[] bytes, int offset) {
        for (int i = offset + 7; i >= offset; --i) {
            bytes[i] = (byte)value;
            value >>= 8;
        }
    }

    public static int shortToInt(short input) {
        int i = input;
        if (i < 0) {
            i = 65536 + i;
        }
        return i;
    }

    public static byte[] doubleToSingleBytes(byte[][] bytes) {
        if (bytes.length == 0) {
            return new byte[0];
        }
        int size = 4;
        for (int i = 0; i < bytes.length; ++i) {
            size += bytes[i].length + 4;
        }
        byte[] result = new byte[size];
        TypeConversion.intToBytes(bytes.length, result, 0);
        int index = 4;
        for (int i = 0; i < bytes.length; ++i) {
            int length = bytes[i].length;
            TypeConversion.intToBytes(length, result, index);
            System.arraycopy(bytes[i], 0, result, index += 4, length);
            index += length;
        }
        return result;
    }

    public static byte[][] singleToDoubleBytes(byte[] bytes) {
        int arraysLength = bytes.length == 0 ? 0 : TypeConversion.bytesToInt(bytes, 0);
        byte[][] result = new byte[arraysLength][];
        int index = 4;
        for (int i = 0; i < arraysLength; ++i) {
            int length = TypeConversion.bytesToInt(bytes, index);
            byte[] tmp = new byte[length];
            System.arraycopy(bytes, index += 4, tmp, 0, length);
            index += length;
            result[i] = tmp;
        }
        return result;
    }

    public static byte[] stringsToBytes(String[] strings) {
        byte[] result = new byte[]{(byte)strings.length};
        for (int i = 0; i < strings.length; ++i) {
            byte[] bytes = strings[i].getBytes();
            byte[] tmp = new byte[bytes.length + result.length + 4];
            System.arraycopy(result, 0, tmp, 0, result.length);
            TypeConversion.intToBytes(bytes.length, tmp, result.length);
            System.arraycopy(bytes, 0, tmp, result.length + 4, bytes.length);
            result = tmp;
        }
        return result;
    }

    public static String[] bytesToStrings(byte[] bytes) {
        String[] result = new String[bytes[0]];
        int index = 1;
        for (int i = 0; i < result.length; ++i) {
            int length = TypeConversion.bytesToInt(bytes, index);
            result[i] = new String(bytes, index += 4, length);
            index += length;
        }
        return result;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.8 ");
        }
    }
}

