/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.wsdl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.CatalogManager;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.xml.resolver.Catalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWSCatalogAccessor
implements CatalogManager {
    private static TraceComponent tc = Tr.register(JaxWSCatalogAccessor.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private JAXWSCatalogManager _catalogManager;
    private ClassLoader classLoader;
    private Enumeration<URL> catalogURLs;
    private static final String ARCHIVE_PROTOCOL = "archive://";
    private boolean catalogParsed;

    public JaxWSCatalogAccessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.catalogParsed = false;
    }

    @Override
    public String resolveLocation(String location) throws IOException, MalformedURLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveLocation, location= " + location);
        }
        String resolvedLocation = null;
        JAXWSCatalogManager catalogManager = this.getOrCreateCatalogManager();
        Catalog catalog = catalogManager.getCatalog();
        if (tc.isDebugEnabled()) {
            catalogManager.setVerbosity(100);
        } else {
            catalogManager.setVerbosity(0);
        }
        if (catalog != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JAX-WS Catalog found... attempting resolution");
            }
            this.parseCatalog();
            resolvedLocation = catalog.resolveSystem(location);
            if (resolvedLocation == null) {
                resolvedLocation = catalog.resolveURI(location);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "JAX-WS Catalog not found no resolution needed");
        }
        if (resolvedLocation == null || "".equals(resolvedLocation)) {
            resolvedLocation = location;
        } else if (resolvedLocation.startsWith(ARCHIVE_PROTOCOL)) {
            resolvedLocation = resolvedLocation.substring(ARCHIVE_PROTOCOL.length(), resolvedLocation.length());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveLocation, location= " + location + ", resolvedLocation= " + resolvedLocation);
        }
        return resolvedLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseCatalog() throws IOException {
        try {
            if (!this.catalogParsed) {
                this.catalogURLs = this.classLoader.getResources("META-INF/jax-ws-catalog.xml");
                if (this.catalogURLs != null && this.catalogURLs.hasMoreElements()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found multiple JAX-WS catalogs for location: META-INF/jax-ws-catalog.xml");
                    }
                    this.parseURLs(this.catalogURLs);
                }
                this.catalogURLs = this.classLoader.getResources("WEB-INF/jax-ws-catalog.xml");
                if (this.catalogURLs != null && this.catalogURLs.hasMoreElements()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found multiple JAX-WS catalogs for location: WEB-INF/jax-ws-catalog.xml");
                    }
                    this.parseURLs(this.catalogURLs);
                }
                if (!this.catalogParsed) {
                    URL catalogURL = this.classLoader.getResource("WEB-INF/jax-ws-catalog.xml");
                    if (catalogURL == null) {
                        catalogURL = this.classLoader.getResource("META-INF/jax-ws-catalog.xml");
                        if (catalogURL != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found JAX-WS catalog in EJB file");
                            }
                            JAXWSCatalogManager catalogManager = this.getOrCreateCatalogManager();
                            catalogManager.getCatalog().parseCatalog(catalogURL);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found JAX-WS catalog in WAR file");
                        }
                        JAXWSCatalogManager catalogManager = this.getOrCreateCatalogManager();
                        catalogManager.getCatalog().parseCatalog(catalogURL);
                    }
                }
            }
        }
        finally {
            this.catalogParsed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseURLs(Enumeration<URL> urls) throws IOException {
        try {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                JAXWSCatalogManager catalogManager = this.getOrCreateCatalogManager();
                catalogManager.getCatalog().parseCatalog(url);
            }
        }
        finally {
            this.catalogParsed = true;
        }
    }

    private JAXWSCatalogManager getOrCreateCatalogManager() {
        if (this._catalogManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "return existing catalogManager:" + this._catalogManager);
            }
            return this._catalogManager;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create new catalogManager");
        }
        this.setCatalogManager(this.classLoader);
        return this._catalogManager;
    }

    private void setCatalogManager(ClassLoader cl) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create catalogManager with classloader: " + cl);
        }
        this._catalogManager = new OASISCatalogManager(cl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "created catalogManager is: " + this._catalogManager);
        }
    }
}

