/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.context.Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.ThreadContextMigrator;

public class SecurityContextMigrator
implements ThreadContextMigrator {
    private static final TraceComponent tc = Tr.register(SecurityContextMigrator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void cleanupContext(MessageContext mc) {
        String mep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupContext");
        }
        if (mc.getAxisOperation() != null && ("http://www.w3.org/2006/01/wsdl/in-only".equals(mep = mc.getAxisOperation().getMessageExchangePattern()) || "http://www.w3.org/2004/08/wsdl/in-only".equals(mep) || "http://www.w3.org/2006/01/wsdl/in-out".equals(mep) || "http://www.w3.org/2004/08/wsdl/in-out".equals(mep) || "http://www.w3.org/ns/wsdl/in-only".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep))) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Resetting security context on Axis2 MessageContext");
            }
            mc.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupContext");
        }
    }

    public void cleanupThread(MessageContext arg0) {
    }

    public void migrateContextToThread(MessageContext mc) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateContextToThread");
        }
        try {
            final MessageContext fMsgContext = mc;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "runWith MessageContext = " + fMsgContext);
            }
            PrivilegedExceptionAction invokeAction = new PrivilegedExceptionAction(){

                public Object run() throws AxisFault {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "invokeAction, MessageContext");
                    }
                    return SecurityContextMigrator.this._migrateContextToThread(fMsgContext);
                }
            };
            this.runWithDomain(invokeAction, fMsgContext);
        }
        catch (Exception we) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught " + we.getMessage());
            }
            throw AxisFault.makeFault(we);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "migrateContextToThread");
        }
    }

    public Object runWithDomain(final PrivilegedExceptionAction action, MessageContext mc) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "runWithDomain MessageContext = " + mc);
        }
        if (mc == null || action == null) {
            return null;
        }
        Object obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
        if (obj != null && obj instanceof Context) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retriving security context on MessageContext");
            }
            try {
                final Context ctx = (Context)obj;
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ctx.runWithDomain(action);
                    }
                });
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught - runWithDomain");
                }
                AxisFault af = new AxisFault(e.toString(), e);
                throw af;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security context object missing in Message Context");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean _migrateContextToThread(MessageContext mc) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_migrateContextToThread");
        }
        try {
            block15: {
                try {
                    final ContextManager manager = ContextManagerFactory.getInstance();
                    if (manager.isCellSecurityEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WebSphere cell security enabled, copying security context from MessageContext to TLS");
                        }
                        if (mc.getAxisOperation() == null) break block15;
                        String mep = mc.getAxisOperation().getMessageExchangePattern();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "MEP: " + mep);
                        }
                        if (!"http://www.w3.org/2006/01/wsdl/in-only".equals(mep) && !"http://www.w3.org/2004/08/wsdl/in-only".equals(mep) && !"http://www.w3.org/2006/01/wsdl/in-out".equals(mep) && !"http://www.w3.org/2004/08/wsdl/in-out".equals(mep) && !"http://www.w3.org/ns/wsdl/in-only".equals(mep) && !"http://www.w3.org/ns/wsdl/in-out".equals(mep)) break block15;
                        Object obj = mc.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                        if (obj != null && obj instanceof Context) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Copying security context on MessageContext onto security context in thread local storage.");
                            }
                            final Context mcContext = (Context)obj;
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws WSSecurityException {
                                        Context tlsContext = manager.getSerializableContext();
                                        tlsContext.setCallerSubject(mcContext.getCallerSubject());
                                        tlsContext.setRunAsSubject(mcContext.getRunAsSubject());
                                        tlsContext.setPropagationTokens(mcContext.getPropagationTokens());
                                        tlsContext.setContext();
                                        return null;
                                    }
                                });
                                break block15;
                            }
                            catch (PrivilegedActionException ex) {
                                Throwable t = ex.getCause();
                                AxisFault af = null;
                                if (t != null) {
                                    af = new AxisFault(t.toString(), t);
                                    throw af;
                                }
                                af = AxisFault.makeFault(ex);
                                throw af;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security context was not found on MessageContext and does not need to be copied to thread local storage");
                        }
                        break block15;
                    }
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "WebSphere cell security disabled, will not copy security context from MessageContext to TLS");
                }
                catch (AxisFault af) {
                    throw af;
                }
                catch (Throwable t) {
                    AxisFault af = new AxisFault(t.toString(), t);
                    throw af;
                }
            }
            Object var10_12 = null;
            if (!tc.isEntryEnabled()) return true;
            Tr.exit(tc, "_migrateContextToThread");
            return true;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "_migrateContextToThread");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void migrateThreadToContext(MessageContext mc) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "migrateThreadToContext");
        }
        try {
            block22: {
                try {
                    final ContextManager manager = ContextManagerFactory.getInstance();
                    if (manager.isCellSecurityEnabled()) {
                        String mep;
                        Context context;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WebSphere cell security enabled, copying security context from TLS to MessageContext");
                        }
                        try {
                            context = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws WSSecurityException {
                                    return manager.getSerializableContext();
                                }
                            });
                        }
                        catch (PrivilegedActionException ex) {
                            Throwable t = ex.getCause();
                            AxisFault af = null;
                            if (t != null) {
                                af = new AxisFault(t.toString(), t);
                                throw af;
                            }
                            af = AxisFault.makeFault(ex);
                            throw af;
                        }
                        String string = mep = mc.getAxisOperation() != null ? mc.getAxisOperation().getMessageExchangePattern() : null;
                        if ("http://www.w3.org/2006/01/wsdl/out-only".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mep) || "http://www.w3.org/2006/01/wsdl/out-in".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-only".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep)) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            final ObjectOutputStream oos = new ObjectOutputStream(baos);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Serializing security context object for deep copy");
                            }
                            try {
                                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws IOException, ClassNotFoundException {
                                        oos.writeObject(context);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException ex) {
                                Throwable t = ex.getCause();
                                AxisFault af = null;
                                if (t != null) {
                                    af = new AxisFault(t.toString(), t);
                                    throw af;
                                }
                                af = AxisFault.makeFault(ex);
                                throw af;
                            }
                            byte[] bytes = baos.toByteArray();
                            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                            final ObjectInputStream ois = new ObjectInputStream(bais);
                            Context deserContext = null;
                            try {
                                deserContext = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws IOException, ClassNotFoundException {
                                        return ois.readObject();
                                    }
                                });
                            }
                            catch (PrivilegedActionException ex) {
                                Throwable t = ex.getCause();
                                AxisFault af = null;
                                if (t != null) {
                                    af = new AxisFault(t.toString(), t);
                                    throw af;
                                }
                                af = AxisFault.makeFault(ex);
                                throw af;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting deserialized context object on MessageContext");
                            }
                            mc.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", deserContext);
                            break block22;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not serialize/deserialize security context");
                        }
                        mc.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", context);
                        break block22;
                    }
                    if (!tc.isDebugEnabled()) break block22;
                    Tr.debug(tc, "WebSphere cell security disabled, will not copy security context from TLS to MessageContext");
                }
                catch (AxisFault af) {
                    throw af;
                }
                catch (IOException ioe) {
                    AxisFault af = AxisFault.makeFault(ioe);
                    throw af;
                }
                catch (Throwable t) {
                    AxisFault af = new AxisFault(t.toString(), t);
                    throw af;
                }
            }
            Object var15_25 = null;
            if (!tc.isEntryEnabled()) return;
            Tr.exit(tc, "migrateThreadToContext");
            return;
        }
        catch (Throwable throwable) {
            Object var15_26 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "migrateThreadToContext");
            throw throwable;
        }
    }
}

