/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.BAAInputStream;
import com.ibm.ws.webservices.utils.BAAOutputStream;
import com.ibm.ws.webservices.utils.BufferUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletInputStream;

public class DetachableInputStream
extends ServletInputStream {
    private static final TraceComponent _tc = Tr.register(DetachableInputStream.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    BAAInputStream localStream = null;
    boolean isClosed = false;
    private InputStream localIS;

    public DetachableInputStream(InputStream in) {
        this.localIS = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "detach");
        }
        if (this.localStream == null && !this.isClosed) {
            BAAOutputStream baaos = new BAAOutputStream();
            try {
                try {
                    BufferUtils.inputStream2OutputStream(this.localIS, baaos);
                    this.localIS.close();
                }
                catch (Throwable t) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "detach caught exception.  Processing continues:" + t);
                        Tr.debug(_tc, "  " + DetachableInputStream.stackToString(t));
                    }
                    Object var4_3 = null;
                    this.localIS = null;
                }
                Object var4_2 = null;
                this.localIS = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.localIS = null;
                throw throwable;
            }
            this.localStream = new BAAInputStream(baaos.buffers(), baaos.length());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "The local stream built from the detached stream has a length of:" + baaos.length());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "The local stream is not built. isClosed : " + this.isClosed);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "detach");
        }
    }

    public int available() throws IOException {
        if (this.localStream != null) {
            return this.localStream.available();
        }
        return this.localIS.available();
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.localStream != null) {
            this.localStream.close();
        } else {
            this.localIS.close();
        }
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public int read() throws IOException {
        if (this.localStream == null) {
            return this.localIS.read();
        }
        return this.localStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.localStream == null) {
            return this.localIS.read(b, off, len);
        }
        return this.localStream.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        if (this.localStream == null) {
            return this.localIS.read(b);
        }
        return this.localStream.read(b);
    }

    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long n) throws IOException {
        if (this.localStream == null) {
            return this.localIS.skip(n);
        }
        return this.localStream.skip(n);
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        return text;
    }
}

