/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.security;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.ConfigProvider;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.ws.websvcs.transport.security.JSSEConfigSSL;
import com.ibm.ws.websvcs.transport.security.WASConfigSSL;
import com.ibm.ws.websvcs.transport.security.WSConfigSSLChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class ConfigSSLProvider
implements ConfigProvider {
    private static final TraceComponent _tc = Tr.register(ConfigSSLProvider.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static JSSEHelper _jhlpr = null;
    private static ConfigSSLProvider cfgPvdr = null;
    private static HashMap connInfoTable = null;
    protected static final String emptyString = "";

    private ConfigSSLProvider() {
    }

    public static final synchronized ConfigSSLProvider getInstance(DefaultHTTPSTransportClientProperties tcp) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getInstance()");
        }
        if (cfgPvdr == null) {
            String sslClientProps = null;
            URL url = null;
            _jhlpr = JSSEHelper.getInstance();
            sslClientProps = tcp.getSSLClientPropsName();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "sslClientProps " + sslClientProps);
            }
            if (sslClientProps != null && sslClientProps != emptyString) {
                try {
                    url = new URL("file", emptyString, sslClientProps);
                }
                catch (MalformedURLException mf) {
                    FFDCFilter.processException(mf, "com.ibm.ws.websvcs.transport.security.ConfigSSLProvider.getInstance", "93");
                    Object[] inserts = new Object[]{mf};
                    String msg = NLSProvider.getNLS().getFormattedMessage("sslClientPropsFileNotSpec00", inserts, "The Secure Sockets Layer (SSL) client configuration file, ssl.client.props, is not specified due to the following error: {0}");
                    throw new AxisFault(msg);
                }
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "loadSSLClientProps", url.toString());
                }
                _jhlpr.loadClientSSLPropertiesFromURL(url.toString(), false);
            }
            cfgPvdr = new ConfigSSLProvider();
            connInfoTable = new HashMap();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getInstance()");
        }
        return cfgPvdr;
    }

    public Config getConfig(MessageContext mc, WSAddress addr, DefaultHTTPSTransportClientProperties tcp) throws AxisFault {
        ConfigSSL retConfig = null;
        Properties currProps = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "ConfigSSLProvider.getConfig() : " + addr);
        }
        try {
            boolean programmaticSet = false;
            boolean aliasBased = false;
            String sslAliasName = null;
            String sslClientProps = null;
            WSConfigSSLChangeListener slistener = new WSConfigSSLChangeListener();
            currProps = _jhlpr.getSSLPropertiesOnThread();
            if (currProps != null) {
                programmaticSet = true;
                currProps = _jhlpr.getProperties(null, null, slistener);
                if (_tc.isEventEnabled()) {
                    Object[] inserts = new Object[]{currProps.toString(), slistener.toString()};
                    Tr.event(_tc, "sslPropertiesProgramSet", inserts);
                }
                retConfig = new WASConfigSSL();
            } else if (!programmaticSet) {
                Object[] inserts;
                try {
                    sslAliasName = tcp.getSSLConfigurationName();
                    sslClientProps = tcp.getSSLClientPropsName();
                }
                catch (ClassCastException cEx) {
                    FFDCFilter.processException((Throwable)cEx, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
                    sslAliasName = null;
                    sslClientProps = null;
                    throw cEx;
                }
                if (_tc.isEventEnabled()) {
                    inserts = new Object[]{sslAliasName, sslClientProps};
                    Tr.event(_tc, "sslConfigFromContext", inserts);
                }
                if ((currProps = _jhlpr.getProperties(sslAliasName, this.getConnInfo(addr), slistener)) == null) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "sslConfigResolveFailed00");
                    }
                    if ((currProps = _jhlpr.getProperties("DefaultSystemProperties", this.getConnInfo(addr), slistener)) == null) {
                        inserts = new Object[]{addr.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("sslConfigResolveFailed01", inserts, "No Secure Sockets Layer (SSL) configuration is available for the {0} endpoint.");
                        throw new AxisFault(msg);
                    }
                }
                if (_tc.isEventEnabled()) {
                    inserts = new Object[]{currProps.toString(), slistener.toString()};
                    Tr.event(_tc, "sslPropertiesFromJSSEHelper", inserts);
                }
                if (currProps.getProperty("com.ibm.ssl.alias").equalsIgnoreCase("DefaultSystemProperties")) {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "invokeMethod00 JSSEConfigSSL " + JSSEConfigSSL.class.getName());
                    }
                    retConfig = new JSSEConfigSSL();
                } else {
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "invokeMethod00 WASConfigSSL " + WASConfigSSL.class.getName());
                    }
                    retConfig = new WASConfigSSL();
                    String aNameConfigured = sslAliasName;
                    int lastslash = aNameConfigured.lastIndexOf("/");
                    if (lastslash != -1) {
                        aNameConfigured = aNameConfigured.substring(lastslash + 1);
                    }
                    String aNameFromHelper = currProps.getProperty("com.ibm.ssl.alias");
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The absolute name for configured SSL Configuration alias is: " + aNameConfigured);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "The SSL alias name from JSSEHelper properties is: " + aNameFromHelper);
                    }
                    if (aNameFromHelper.equalsIgnoreCase(aNameConfigured)) {
                        aliasBased = true;
                    }
                }
            }
            retConfig.putAll((Map)currProps);
            retConfig.setlistener(slistener);
            if (programmaticSet) {
                retConfig.setPreConfig(currProps);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Saved previous programmatic SSL configuration: " + currProps.toString());
                }
            } else {
                retConfig.setPreConfig(null);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "No previous programmatic SSL configuration to be saved.");
                }
            }
            _jhlpr.setSSLPropertiesOnThread(retConfig);
        }
        catch (SSLException sE) {
            FFDCFilter.processException((Throwable)sE, "com.ibm.ws.webservices.engine.transport.security.getConfigSSL", "%C", this);
            AxisFault.makeFault(sE);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "ConfigSSLProvider.getConfig()");
        }
        return retConfig;
    }

    private HashMap getConnInfo(WSAddress addr) {
        String targetKey;
        HashMap<String, String> retHmap;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getConnInfo outbound  " + addr.getSchemaInString() + " host : " + addr.getHostname() + " port : " + String.valueOf(addr.getPort()));
        }
        if ((retHmap = (HashMap<String, String>)connInfoTable.get(targetKey = "outbound" + addr.getSchemaInString() + addr.getHostname() + String.valueOf(addr.getPort()))) == null) {
            retHmap = new HashMap<String, String>();
            retHmap.put("com.ibm.ssl.direction", "outbound");
            if (addr.getSchema() == 1 || addr.getSchema() == 2) {
                retHmap.put("com.ibm.ssl.endPointName", "WEBSERVICES_HTTP");
            } else {
                retHmap.put("com.ibm.ssl.endPointName", addr.getSchemaInString());
            }
            retHmap.put("com.ibm.ssl.remoteHost", addr.getHostname());
            retHmap.put("com.ibm.ssl.remotePort", String.valueOf(addr.getPort()));
            connInfoTable.put(targetKey, retHmap);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "sslConnectionInfo " + retHmap.toString());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getConnInfo");
        }
        return retHmap;
    }
}

