/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.Properties;
import org.apache.axis2.description.AxisService;

public class PolicySetUtils
implements Constants {
    private static final TraceComponent _tc = Tr.register(PolicySetUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public static String getOutReqWithSSLConfigAlias(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("outRequestwithSSL:configAlias");
    }

    public static String getOutAsyncRspWithSSLConfigAlias(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("outAsyncResponsewithSSL:configAlias");
    }

    public static String getInAsyncRspWithSSLConfigAlias(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("inResponsewithSSL:configAlias");
    }

    public static String getOutReqWithSSLFile(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("outRequestwithSSL:configFile");
    }

    public static String getOutAsyncRspWithSSLFile(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("outAsyncResponsewithSSL:configFile");
    }

    public static String getInAsyncRspWithSSLFile(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Binding Props were null.");
            }
            return null;
        }
        return bindingProps.getProperty("inResponsewithSSL:configFile");
    }

    public static String getListeningPort(AxisService service) {
        Properties bindingProps = PolicySetUtils.getHTTPBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(bindingProps, "com.ibm.websphere.webservices.http.listenerPort");
    }

    public static String getSecureListeningPort(AxisService service) {
        Properties bindingProps = PolicySetUtils.getSSLBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(bindingProps, "com.ibm.websphere.webservices.https.listenerPort");
    }

    public static boolean isOutReqSSLenabled(AxisService service) {
        Properties policyProps = PolicySetUtils.getSSLPolicy(service);
        if (policyProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String value = policyProps.getProperty("outRequestSSLenabled");
        return "yes".equalsIgnoreCase(value);
    }

    public static boolean isOutAsyncRspSSLenabled(AxisService service) {
        Properties policyProps = PolicySetUtils.getSSLPolicy(service);
        if (policyProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String value = policyProps.getProperty("outAsyncResponseSSLenabled");
        return "yes".equalsIgnoreCase(value);
    }

    public static boolean isInAsyncRspSSLenabled(AxisService service) {
        Properties policyProps = PolicySetUtils.getSSLPolicy(service);
        if (policyProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return false;
        }
        String value = policyProps.getProperty("inResponseSSLenabled");
        return "yes".equalsIgnoreCase(value);
    }

    public static Properties getSSLBindings(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeBinding("SSL_BINDING");
    }

    public static Properties getSSLPolicy(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeConfiguration("SSL_POLICY");
    }

    public static Properties getHTTPBindings(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeBinding("HTTP_BINDING");
    }

    public static Properties getHTTPPolicy(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeConfiguration("HTTP_POLICY");
    }

    public static String getJMSConnectionFactory(AxisService service) {
        Properties bindingProps = PolicySetUtils.getJMSBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(bindingProps, "com.ibm.websphere.webservices.jms.AsyncReplyCFName");
    }

    public static String getJMSDestination(AxisService service) {
        Properties bindingProps = PolicySetUtils.getJMSBindings(service);
        if (bindingProps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Props were null.");
            }
            return null;
        }
        return PolicySetUtils.getCustomBindingValue(bindingProps, "com.ibm.websphere.webservices.jms.AsyncReplyQueueName");
    }

    public static Properties getJMSPolicy(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeConfiguration("JMS_POLICY");
    }

    public static Properties getJMSBindings(AxisService service) {
        if (service == null) {
            return null;
        }
        PolicySetConfiguration ps = (PolicySetConfiguration)Axis2Utils.getPolicySet(service);
        if (ps == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Policy Set was null.");
            }
            return null;
        }
        return (Properties)ps.getPolicyTypeBinding("JMS_BINDING");
    }

    public static String getCustomBindingValue(Properties props, String customBindingName) {
        if (props == null || props.isEmpty() || customBindingName == null) {
            return null;
        }
        for (String string : props.keySet()) {
            if (!customBindingName.equalsIgnoreCase(props.getProperty(string))) continue;
            String propValueKey = string.substring(0, string.lastIndexOf(58) + 1) + "value";
            return props.getProperty(propValueKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void expandAttributes(Properties props, VariableExpander expander) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "expandAttributes");
        }
        if (props == null || expander == null) {
            if (!_tc.isDebugEnabled()) return;
            Tr.debug(_tc, "Properties or expander is null. Not expanding.");
            return;
        }
        try {
            try {
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    value = expander.expand(value);
                    props.setProperty(string, value);
                }
                Object var6_6 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (Exception e) {
                Tr.error(_tc, "caughtException", e);
                Object var6_7 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "expandAttributes");
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "expandAttributes");
            throw throwable;
        }
        Tr.exit(_tc, "expandAttributes");
    }

    public static String findCustomPropertyValue(Properties attributes, String name) {
        String propValueKey = name.substring(0, name.lastIndexOf(58) + 1) + "value";
        for (String string : attributes.keySet()) {
            if (!propValueKey.equals(string)) continue;
            return (String)attributes.get(propValueKey);
        }
        return "";
    }

    public static String maskPasswords(Properties props) {
        if (props == null) {
            return "NONE";
        }
        String propsStr = props.toString();
        int front = 0;
        int back = 0;
        String passwordKey = "password=";
        StringBuffer result = new StringBuffer();
        while ((back = propsStr.indexOf("password=", front)) >= 0) {
            result.append(propsStr.substring(front, back += "password=".length()));
            front = back;
            back = propsStr.indexOf(44, front);
            for (int i = 0; i < back - front; ++i) {
                result.append("*");
            }
            front = back;
        }
        result.append(propsStr.substring(front));
        return result.toString();
    }

    public static String getDecodedPassword(String password) throws Exception {
        if (PasswordUtil.getCryptoAlgorithm(password) != null) {
            return PasswordUtil.decode(password);
        }
        return password;
    }
}

