/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicyTypeLoader;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class JMSPolicyTypeLoader
implements PolicyTypeLoader {
    private static final TraceComponent _tc = Tr.register(JMSPolicyTypeLoader.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void init(Map properties) throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "init");
        }
    }

    public void load(ClassLoader sysCL, VariableExpander vm, InputStream input, PolicySetConfiguration psConfig) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "load", new Object[]{sysCL, vm, input, psConfig});
        }
        Properties attributes = JMSPolicyTypeFileHelper.readPolicy(input);
        PolicySetUtils.expandAttributes(attributes, vm);
        if (attributes != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "load", "Got values from Properties object...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "load", "Setting JMS_POLICY");
        }
        psConfig.setPolicyTypeConfiguration("JMS_POLICY", attributes);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "load", new Object[]{sysCL, vm, input, psConfig});
        }
    }

    public void destroy() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroy");
        }
    }

    public String getType() throws Exception {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getType", "JMSTransport");
        }
        return "JMSTransport";
    }

    public WSPolicyAssertionProcessor getWSPolicyAssertionProcessor() {
        return null;
    }
}

