/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.websvcs.transport.common.TransportConstants;
import com.ibm.ws.websvcs.transport.policyset.NamespacePrefixMapperImpl;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.PolicyValidation;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Properties;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.All;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.BasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.CustomProperty;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.ExactlyOne;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.ObjectFactory;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.OutAsyncResponseBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.OutRequestBasicAuth;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.Policy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSPolicyTypeFileHelper {
    private static final TraceComponent _tc = Tr.register(JMSPolicyTypeFileHelper.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String CLASSNAME = JMSPolicyTypeFileHelper.class.getCanonicalName();

    static boolean writePolicyBinding(String bindingPath, java.util.Properties attributes) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.writePolicyBinding()...");
        }
        boolean success = JMSPolicyTypeFileHelper.writePolicy(bindingPath, attributes);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicyBinding().");
        }
        return success;
    }

    static boolean writePolicyBinding(OutputStream os, java.util.Properties attributes) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.writePolicyBinding(outputstream)...");
        }
        boolean success = JMSPolicyTypeFileHelper.writePolicy(os, attributes);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicy(outputstream) : " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean writePolicy(String policyTypePath, java.util.Properties attributes) throws IOException {
        boolean success;
        block14: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "JMSPolicyTypeFileHelper.writePolicy()...");
            }
            success = true;
            if (attributes != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Properties object not null. Getting values from object.");
            }
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Validating the property objects.");
                }
                success = PolicyValidation.getInstance().validateFullPolicy(attributes);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:104:1.2");
                if (_tc.isErrorEnabled()) {
                    Tr.error(_tc, "validatePolicyFail00", e);
                }
                success = false;
            }
            if (success) {
                OutputStream outputStream = null;
                try {
                    File policyFile = new File(policyTypePath);
                    if (!policyFile.exists()) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "writePolicy", "File does not exist. Will be created: " + policyTypePath);
                        }
                        success = false;
                    } else {
                        outputStream = new FileOutputStream(policyFile);
                        success = JMSPolicyTypeFileHelper.writePolicy(outputStream, attributes);
                    }
                    Object var6_6 = null;
                    if (outputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                outputStream.close();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicy() : " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean writePolicy(OutputStream os, java.util.Properties props) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.writePolicy(outputstream)...");
        }
        boolean success = true;
        try {
            try {
                Policy policy = JMSPolicyTypeFileHelper.createPolicyObject(props);
                final ClassLoader cl = PolicyTypeFileHelper.class.getClassLoader();
                JAXBContext jc = null;
                try {
                    jc = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JAXBContext.newInstance((String)"com.ibm.ws.websvcs.transport.policyset.jms.jaxb", (ClassLoader)cl);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                Marshaller policyMarshaller = jc.createMarshaller();
                policyMarshaller.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", (Object)new NamespacePrefixMapperImpl());
                policyMarshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                policyMarshaller.marshal((Object)policy, os);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:104:1.2");
                if (_tc.isErrorEnabled()) {
                    Tr.error(_tc, "marshallPolicyFail00", e);
                }
                success = false;
                Object var8_10 = null;
                if (!_tc.isEntryEnabled()) return success;
                Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicy(outputstream) : " + success);
                return success;
            }
            Object var8_9 = null;
            if (!_tc.isEntryEnabled()) return success;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicy(outputstream) : " + success);
            throw throwable;
        }
        Tr.exit(_tc, "...JMSPolicyTypeFileHelper.writePolicy(outputstream) : " + success);
        return success;
    }

    static java.util.Properties readBinding(String bindingPath) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.readBinding()..." + bindingPath);
        }
        java.util.Properties resultProperties = JMSPolicyTypeFileHelper.readPolicy(bindingPath);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.readBinding()." + bindingPath);
        }
        return resultProperties;
    }

    static java.util.Properties readPolicy(String policyTypePath) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.readPolicy()... policyTypePath : " + policyTypePath);
        }
        List<All> alternatives = JMSPolicyTypeFileHelper.getAlternativesFromFile(policyTypePath);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "alternatives size : " + alternatives.size());
        }
        java.util.Properties resultProperties = new java.util.Properties();
        All jax_All = alternatives.get(0);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "jax_all : " + jax_All);
        }
        try {
            JMSPolicyTypeFileHelper.populateProperties(resultProperties, jax_All);
        }
        catch (Exception e) {
            resultProperties = new java.util.Properties();
            throw new IOException("Could not extract all property values.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.readPolicy(). policyTypePath : " + policyTypePath);
        }
        return resultProperties;
    }

    static java.util.Properties readBinding(InputStream bindingIS) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.readBinding()..." + bindingIS);
        }
        java.util.Properties resultProperties = JMSPolicyTypeFileHelper.readPolicy(bindingIS);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.readBinding()." + bindingIS);
        }
        return resultProperties;
    }

    static java.util.Properties readPolicy(InputStream policyIS) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeFileHelper.readPolicy()... policyIS : " + policyIS);
        }
        java.util.Properties resultProperties = new java.util.Properties();
        List<All> alternatives = JMSPolicyTypeFileHelper.getAlternativesFromStream(policyIS);
        if (alternatives != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "alternatives size : " + alternatives.size());
            }
            All jax_All = alternatives.get(0);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "jax_all : " + jax_All);
            }
            try {
                JMSPolicyTypeFileHelper.populateProperties(resultProperties, jax_All);
            }
            catch (Exception e) {
                resultProperties = new java.util.Properties();
                throw new IOException("Could not extract all property values.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.readPolicy(). policyIS : " + policyIS);
        }
        return resultProperties;
    }

    private static void populateProperties(java.util.Properties resultProperties, All jax_All) throws Exception {
        block6: for (int i = 0; i < TransportConstants.policyElements.length; ++i) {
            switch (i) {
                case 22: {
                    if (jax_All.getRequestTimeout() == null) continue block6;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.policyElements[i] + " with " + "requestTimeout" + " : " + jax_All.getRequestTimeout());
                    }
                    resultProperties.put("requestTimeout", jax_All.getRequestTimeout());
                    continue block6;
                }
                case 23: {
                    if (jax_All.getAllowTransactionalAsyncMessaging() == null) continue block6;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.policyElements[i] + " with " + "allowTransactionalAsyncMessaging" + " : " + jax_All.getAllowTransactionalAsyncMessaging());
                    }
                    resultProperties.put("allowTransactionalAsyncMessaging", jax_All.getAllowTransactionalAsyncMessaging());
                    continue block6;
                }
                case 18: {
                    if (jax_All.getOutAsyncResponseBasicAuth() == null || jax_All.getOutAsyncResponseBasicAuth().getBasicAuth() == null || jax_All.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid() == null) continue block6;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.policyElements[i] + " with " + "outAsyncResponseBasicAuth:userid" + " : " + jax_All.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid() + " " + "outAsyncResponseBasicAuth:password" + " : ********");
                    }
                    resultProperties.put("outAsyncResponseBasicAuth:userid", jax_All.getOutAsyncResponseBasicAuth().getBasicAuth().getUserid());
                    String pWD = jax_All.getOutAsyncResponseBasicAuth().getBasicAuth().getPassword();
                    if (pWD != null && !"".equals(pWD)) {
                        pWD = PolicySetUtils.getDecodedPassword(pWD);
                    }
                    resultProperties.put("outAsyncResponseBasicAuth:password", pWD);
                    continue block6;
                }
                case 17: {
                    if (jax_All.getOutRequestBasicAuth() == null || jax_All.getOutRequestBasicAuth().getBasicAuth() == null || jax_All.getOutRequestBasicAuth().getBasicAuth().getUserid() == null) continue block6;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readPolicy", "Setting " + TransportConstants.policyElements[i] + " with " + "outRequestBasicAuth:userid" + " : " + jax_All.getOutRequestBasicAuth().getBasicAuth().getUserid() + " " + "outRequestBasicAuth:password" + " : ********");
                    }
                    resultProperties.put("outRequestBasicAuth:userid", jax_All.getOutRequestBasicAuth().getBasicAuth().getUserid());
                    String pWD = jax_All.getOutRequestBasicAuth().getBasicAuth().getPassword();
                    if (pWD != null && !"".equals(pWD)) {
                        pWD = PolicySetUtils.getDecodedPassword(pWD);
                    }
                    resultProperties.put("outRequestBasicAuth:password", pWD);
                }
            }
        }
        if (jax_All.getProperties() != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readPolicy", "1 Setting custom properties with " + jax_All.getProperties().toString());
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "readPolicy", "2 Setting custom properties with " + jax_All.getProperties().getCustomProperty() + "size : " + jax_All.getProperties().getCustomProperty().size());
            }
            List<CustomProperty> customProps = jax_All.getProperties().getCustomProperty();
            for (int j = 0; j < customProps.size(); ++j) {
                CustomProperty prop = customProps.get(j);
                resultProperties.put("properties_" + j + ":" + "name", prop.getName());
                resultProperties.put("properties_" + j + ":" + "value", prop.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<All> getAlternativesFromFile(String policyTypePath) throws IOException {
        void var1_3;
        block16: {
            InputStream policyFileStream;
            block15: {
                List<All> list;
                block14: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "JMSPolicyTypeFileHelper.getAlternativesFromFile()...");
                    }
                    ArrayList arrayList = new ArrayList();
                    policyFileStream = null;
                    try {
                        try {
                            final ClassLoader cl = JMSPolicyTypeFileHelper.class.getClassLoader();
                            JAXBContext jc = null;
                            try {
                                jc = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        return JAXBContext.newInstance((String)"com.ibm.ws.websvcs.transport.policyset.jms.jaxb", (ClassLoader)cl);
                                    }
                                });
                            }
                            catch (PrivilegedActionException pae) {
                                throw pae.getException();
                            }
                            Unmarshaller um = jc.createUnmarshaller();
                            File policyFile = new File(policyTypePath);
                            if (!policyFile.exists()) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "getAlternativesFromFile", "File does not exist: " + policyTypePath);
                                }
                                list = null;
                                Object var9_12 = null;
                                if (policyFileStream == null) return list;
                                break block14;
                            }
                            policyFileStream = new FileInputStream(policyFile);
                            List<All> list2 = JMSPolicyTypeFileHelper.getAlternativesFromStream(policyFileStream);
                            break block15;
                        }
                        catch (Exception e) {
                            FFDCFilter.processException(e, CLASSNAME, "1:207:1.2");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "getAlternativesFromFile", "Exception caught during unmarshalling: " + e);
                            }
                            Object var9_14 = null;
                            if (policyFileStream != null) {
                                policyFileStream.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_15 = null;
                        if (policyFileStream != null) {
                            policyFileStream.close();
                        }
                        throw throwable;
                    }
                }
                policyFileStream.close();
                return list;
            }
            Object var9_13 = null;
            if (policyFileStream != null) {
                policyFileStream.close();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.getAlternativesFromFile()");
        }
        return var1_3;
    }

    private static List<All> getAlternativesFromStream(InputStream policyIS) {
        List<All> result;
        block12: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "JMSPolicyTypeFileHelper.getAlternativesFromStream()...");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getAlternativesFromStream", "Policy InputStream: " + policyIS);
            }
            if (policyIS == null) {
                return null;
            }
            result = new ArrayList<All>();
            try {
                final ClassLoader cl = JMSPolicyTypeFileHelper.class.getClassLoader();
                JAXBContext jc = null;
                try {
                    jc = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JAXBContext.newInstance((String)"com.ibm.ws.websvcs.transport.policyset.jms.jaxb", (ClassLoader)cl);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                Unmarshaller um = jc.createUnmarshaller();
                InputStream policyFileStream = policyIS;
                StreamSource ss = new StreamSource(policyFileStream);
                JAXBElement policy = um.unmarshal((Source)ss, Policy.class);
                if (policy != null) {
                    Policy policyObject;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getAlternativesFromStream", "JAXBElement<Policy> unmarshalled: " + policy);
                    }
                    if ((policyObject = (Policy)policy.getValue()) != null && policyObject.getExactlyOne() != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getAlternativesFromStream", "An ExactlyOne element found.");
                        }
                        result = policyObject.getExactlyOne().getAll();
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:207:1.2");
                if (!_tc.isDebugEnabled()) break block12;
                Tr.debug(_tc, "getAlternativesFromStream", "Exception caught during unmarshalling: " + e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.getAlternativesFromStream() " + result.toArray().toString());
        }
        return result;
    }

    private static Policy createPolicyObject(java.util.Properties attributes) throws Exception {
        All jaxb_All;
        Policy policy;
        ExactlyOne eo;
        block22: {
            List<CustomProperty> customProperties;
            ObjectFactory of;
            block21: {
                Object[] inserts;
                BasicAuth ba;
                String pWD;
                String uID;
                block20: {
                    block19: {
                        String value;
                        block18: {
                            if (_tc.isEntryEnabled()) {
                                Tr.entry(_tc, "JMSPolicyTypeFileHelper.createPolicyObject()...");
                            }
                            of = new ObjectFactory();
                            eo = of.createExactlyOne();
                            policy = of.createPolicy();
                            policy.setExactlyOne(eo);
                            jaxb_All = of.createAll();
                            value = attributes.getProperty("requestTimeout");
                            if (value != null) {
                                try {
                                    jaxb_All.setRequestTimeout(value);
                                }
                                catch (ClassCastException cEx) {
                                    FFDCFilter.processException(cEx, "com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper.createPolicyObject", "696");
                                    if (!_tc.isErrorEnabled()) break block18;
                                    Tr.error(_tc, "nonStrElemReceived00", "requestTimeout");
                                }
                            }
                        }
                        if ((value = attributes.getProperty("allowTransactionalAsyncMessaging")) != null) {
                            try {
                                jaxb_All.setAllowTransactionalAsyncMessaging(value);
                            }
                            catch (ClassCastException cEx) {
                                FFDCFilter.processException(cEx, "com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper.createPolicyObject", "696");
                                if (!_tc.isErrorEnabled()) break block19;
                                Tr.error(_tc, "nonStrElemReceived00", "allowTransactionalAsyncMessaging");
                            }
                        }
                    }
                    uID = null;
                    pWD = null;
                    uID = attributes.getProperty("outAsyncResponseBasicAuth:userid");
                    pWD = attributes.getProperty("outAsyncResponseBasicAuth:password");
                    if (uID != null && pWD != null) {
                        try {
                            pWD = PasswordUtil.encode(pWD);
                            ba = of.createBasicAuth();
                            ba.setUserid(uID);
                            ba.setPassword(pWD);
                            OutAsyncResponseBasicAuth outAsyResBA = of.createOutAsyncResponseBasicAuth();
                            outAsyResBA.setBasicAuth(ba);
                            jaxb_All.setOutAsyncResponseBasicAuth(outAsyResBA);
                        }
                        catch (ClassCastException cEx) {
                            FFDCFilter.processException(cEx, "com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper.createPolicyObject", "1048");
                            if (!_tc.isErrorEnabled()) break block20;
                            inserts = new Object[]{OutAsyncResponseBasicAuth.class.getCanonicalName(), "outAsyncResponseBasicAuth"};
                            Tr.error(_tc, "nonStrElemReceived01", inserts);
                        }
                    }
                }
                uID = null;
                pWD = null;
                uID = attributes.getProperty("outRequestBasicAuth:userid");
                pWD = attributes.getProperty("outRequestBasicAuth:password");
                if (uID != null && pWD != null) {
                    try {
                        pWD = PasswordUtil.encode(pWD);
                        ba = of.createBasicAuth();
                        ba.setUserid(uID);
                        ba.setPassword(pWD);
                        OutRequestBasicAuth outReqBA = of.createOutRequestBasicAuth();
                        outReqBA.setBasicAuth(ba);
                        jaxb_All.setOutRequestBasicAuth(outReqBA);
                    }
                    catch (ClassCastException cEx) {
                        FFDCFilter.processException(cEx, "com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper.createPolicyObject", "1070");
                        if (!_tc.isErrorEnabled()) break block21;
                        inserts = new Object[]{OutRequestBasicAuth.class.getCanonicalName(), "outRequestBasicAuth"};
                        Tr.error(_tc, "nonStrElemReceived01", inserts);
                    }
                }
            }
            if ((customProperties = JMSPolicyTypeFileHelper.getCustomProperties(attributes)).size() > 0) {
                try {
                    com.ibm.ws.websvcs.transport.policyset.jms.jaxb.Properties props = of.createProperties();
                    Iterator<CustomProperty> propIter = customProperties.iterator();
                    while (propIter.hasNext()) {
                        props.getCustomProperty().add(propIter.next());
                    }
                    jaxb_All.setProperties(props);
                }
                catch (ClassCastException cEx) {
                    FFDCFilter.processException(cEx, "com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper.createPolicyObject", "1084");
                    if (!_tc.isErrorEnabled()) break block22;
                    Object[] inserts = new Object[]{Properties.class.getCanonicalName(), "properties"};
                    Tr.error(_tc, "nonStrElemReceived01", inserts);
                }
            }
        }
        eo.getAll().add(jaxb_All);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeFileHelper.createPolicyObject()");
        }
        return policy;
    }

    public static List<CustomProperty> getCustomProperties(java.util.Properties attributes) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCustomProperties");
        }
        ArrayList<CustomProperty> customProperties = new ArrayList<CustomProperty>();
        for (String string : attributes.keySet()) {
            int index = string.lastIndexOf(58);
            if (!string.startsWith("properties") || index == -1 || !string.substring(index + 1).equals("name")) continue;
            String name = (String)attributes.get(string);
            String value = PolicySetUtils.findCustomPropertyValue(attributes, string);
            if (value != null && !"".equals(value)) {
                CustomProperty customProp = new CustomProperty();
                customProp.setName(name);
                customProp.setValue(value);
                customProperties.add(customProp);
            }
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Obtained custom property name=" + name + " value=" + value);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCustomProperties");
        }
        return customProperties;
    }

    static boolean updatePolicyOrBinding(InputStream oldIn, InputStream newIn, OutputStream os, boolean isBinding) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyTypeFileHelper.updatePolicyOrBinding()...", "isBinding=" + isBinding);
        }
        boolean success = true;
        try {
            java.util.Properties oldProps = new java.util.Properties();
            java.util.Properties newProps = new java.util.Properties();
            if (oldIn != null) {
                oldProps = JMSPolicyTypeFileHelper.readBinding(oldIn);
            }
            if (newIn != null) {
                newProps = JMSPolicyTypeFileHelper.readBinding(newIn);
            }
            newProps.putAll((Map<?, ?>)oldProps);
            success = isBinding ? JMSPolicyTypeFileHelper.writePolicyBinding(os, newProps) : JMSPolicyTypeFileHelper.writePolicy(os, newProps);
        }
        catch (Exception e) {
            Object[] inserts = new Object[]{e};
            Tr.error(_tc, "caughtException", inserts);
            success = false;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...PolicyTypeFileHelper.updatePolicyOrBinding() : " + success);
        }
        return success;
    }
}

