/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.PolicyValidation;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPolicyTypeProvider
implements PolicyTypeProvider {
    private static final TraceComponent _tc = Tr.register(HttpPolicyTypeProvider.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public String getType() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpPolicyTypeProvider.getType()...", "HTTPTransport");
        }
        return "HTTPTransport";
    }

    @Override
    public Properties getAttributes(String policyFileName, Properties attributes, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.getAttributes()...");
        }
        Properties result = this.performRead(policyFileName, attributes, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.getAttributes()", new Object[]{result});
        }
        return result;
    }

    @Override
    public Properties getBinding(String bindingFileName, Properties attributes, Map context) throws Exception {
        boolean filePresent = true;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.getBinding()...");
        }
        Properties result = new Properties();
        File file = new File(bindingFileName);
        if (file.length() == 0L) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpPolicyTypeProvider.getBinding() - binding file is empty, returning without trying to load");
            }
            filePresent = false;
        }
        if (filePresent) {
            result = this.performRead(bindingFileName, attributes, true);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.getBinding()", new Object[]{result});
        }
        return result;
    }

    @Override
    public boolean setAttributes(String policyFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.setAttributes()...");
        }
        boolean success = this.performWrite(policyFileName, attributes, replace, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.setAttributes()", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.setBinding()...");
        }
        boolean success = this.performWrite(bindingFileName, attributes, replace, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.setBinding()", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean validate(String policySetFileName, String policyFileName, Map context) throws Exception {
        boolean result = false;
        Properties existingAttrs = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.validate()...", new Object[]{policySetFileName, policyFileName});
        }
        PolicyValidation policyValidate = PolicyValidation.getInstance();
        policyValidate.loadPolicy(policyFileName);
        existingAttrs = PolicyTypeFileHelper.readPolicy(policyFileName);
        result = policyValidate.validateFullPolicy(existingAttrs);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.validate()", new Object[]{result});
        }
        return result;
    }

    private boolean performWrite(String filename, Properties attrs, boolean replace, boolean isBinding) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.performWrite()...", new Object[]{filename, replace, isBinding, PolicySetUtils.maskPasswords(attrs)});
        }
        boolean success = false;
        if (replace) {
            success = isBinding ? PolicyTypeFileHelper.writePolicyBinding(filename, attrs) : PolicyTypeFileHelper.writePolicy(filename, attrs);
        } else {
            Properties existingAttrs = null;
            Properties resultAttrs = new Properties();
            boolean filePresent = true;
            File file = new File(filename);
            if (file.length() == 0L) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "HttpPolicyTypeProvider.performWrite() - binding file is empty");
                }
                filePresent = false;
            }
            if (filePresent) {
                existingAttrs = isBinding ? PolicyTypeFileHelper.readBinding(filename) : PolicyTypeFileHelper.readPolicy(filename);
            }
            if (existingAttrs != null && !existingAttrs.isEmpty()) {
                for (Object key : existingAttrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found existing attribute: " + key);
                    }
                    resultAttrs.put(key, existingAttrs.get(key));
                }
                for (Object key : attrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting specified attribute: " + key);
                    }
                    resultAttrs.put(key, attrs.get(key));
                }
                success = isBinding ? PolicyTypeFileHelper.writePolicyBinding(filename, resultAttrs) : PolicyTypeFileHelper.writePolicy(filename, resultAttrs);
            } else {
                for (Object key : attrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting specified attribute: " + key);
                    }
                    resultAttrs.put(key, attrs.get(key));
                }
                success = isBinding ? PolicyTypeFileHelper.writePolicyBinding(filename, attrs) : PolicyTypeFileHelper.writePolicy(filename, attrs);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.performWrite()");
        }
        return success;
    }

    private Properties performRead(String filename, Properties attrs, boolean isBinding) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.performRead()...", new Object[]{filename, isBinding, PolicySetUtils.maskPasswords(attrs)});
        }
        Properties existingAttributes = null;
        existingAttributes = isBinding ? PolicyTypeFileHelper.readBinding(filename) : PolicyTypeFileHelper.readPolicy(filename);
        Properties resultAttributes = null;
        if (attrs != null && !attrs.isEmpty()) {
            resultAttributes = new Properties();
            for (Object key : attrs.keySet()) {
                if (existingAttributes.containsKey(key)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Copying attribute: " + key);
                    }
                    resultAttributes.put(key, existingAttributes.get(key));
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Attribute requested but not available: " + key);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No attributes specified. Copying all " + existingAttributes.size() + "of the available attributes.");
            }
            resultAttributes = existingAttributes;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.performRead()", new Object[]{PolicySetUtils.maskPasswords(resultAttributes)});
        }
        return resultAttributes;
    }

    @Override
    public InputStream downgradeBinding(InputStream bindingFileStream, Map<String, String> context) throws Exception {
        return bindingFileStream;
    }

    @Override
    public InputStream downgradePolicy(InputStream policyFileStream, Map<String, String> context) throws Exception {
        return policyFileStream;
    }

    @Override
    public boolean mergeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradePolicy(String oldPolicyFilePath, String newPolicyFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.upgradeBinding()...");
        }
        boolean success = PolicyTypeFileHelper.updatePolicyOrBinding(oldBindingFile, newBindingFile, resultBindingFile, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.upgradeBinding() : " + success);
        }
        return success;
    }

    @Override
    public boolean mergeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.mergeBinding()...");
        }
        boolean success = PolicyTypeFileHelper.updatePolicyOrBinding(oldBindingFile, newBindingFile, resultBindingFile, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.mergeBinding() : " + success);
        }
        return success;
    }

    @Override
    public boolean upgradePolicy(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpPolicyTypeProvider.upgradePolicy()...");
        }
        boolean success = PolicyTypeFileHelper.updatePolicyOrBinding(oldPolicyFile, newPolicyFile, resultPolicyFile, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpPolicyTypeProvider.upgradePolicy() : " + success);
        }
        return success;
    }
}

