/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;

public class JMSSender
extends AbstractHandler
implements TransportSender {
    private static final TraceComponent _tc = Tr.register(JMSSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public static final String MC_PRP_REPLYQCF = "ReplyQCF";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block14: {
            Handler.InvocationResponse invocationResponse;
            block13: {
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "invoke msgContext : " + msgContext);
                }
                try {
                    try {
                        String targetAddress = (String)msgContext.getProperty("TransportURL");
                        if (targetAddress == null && msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                            targetAddress = msgContext.getTo().getAddress();
                            if (msgContext.getTo().hasNoneAddress()) {
                                invocationResponse = Handler.InvocationResponse.CONTINUE;
                                Object var5_8 = null;
                                if (!_tc.isEntryEnabled()) return invocationResponse;
                                break block13;
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "targetAddress: " + (targetAddress != null ? targetAddress : "<null>"));
                        }
                        if (targetAddress != null) {
                            try {
                                SOAPOverJMSSender sender = new SOAPOverJMSSender();
                                sender.invoke(msgContext);
                                break block14;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSTransportSender.invoke", "160", this);
                                throw AxisFault.makeFault(e);
                            }
                        }
                        if (msgContext.getProperty("TRANSPORT_OUT") == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("nullTOTransportOut00", new Object[0], "Both the TransportOut and property MessageContext.TRANSPORT_OUT values are null.");
                            throw new AxisFault(msg);
                        }
                        this.sendUsingOutputStream(msgContext);
                        break block14;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSSender.invoke", "200", this);
                        throw AxisFault.makeFault(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "invoke");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "invoke");
            return invocationResponse;
        }
        Object var5_9 = null;
        if (!_tc.isEntryEnabled()) return Handler.InvocationResponse.CONTINUE;
        Tr.exit(_tc, "invoke");
        return Handler.InvocationResponse.CONTINUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendUsingOutputStream(MessageContext msgContext) throws AxisFault, XMLStreamException, IOException {
        block40: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "sendUsingOutputStream");
            }
            try {
                Message jmsMessage = null;
                if (msgContext.isFault()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Fault msgContext : " + msgContext);
                    }
                    jmsMessage = (Message)msgContext.getProperty("JMSMESSAGE");
                } else {
                    MessageContext requestMC;
                    OperationContext opCtx = msgContext.getOperationContext();
                    if (opCtx != null && (requestMC = opCtx.getMessageContext("In")) != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Traversed to request message context to retrieve JMS request message.");
                        }
                        jmsMessage = (Message)requestMC.getProperty("JMSMESSAGE");
                    }
                }
                Queue replyQueue = null;
                if (jmsMessage != null) {
                    replyQueue = (Queue)jmsMessage.getJMSReplyTo();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "replyQueue : " + (replyQueue != null ? ((Object)replyQueue).toString() : "<not-specified>"));
                    }
                }
                if (replyQueue == null) break block40;
                boolean isTextMessage = jmsMessage instanceof TextMessage;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Request was a TextMessage: " + isTextMessage);
                }
                ConnectionFactory qcf = this.getReplyQCF(msgContext);
                Connection connection = qcf.createConnection();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created the connection.");
                }
                try {
                    try {
                        ByteArrayOutputStream out;
                        Session session = connection.createSession(false, 1);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the session.");
                        }
                        MessageProducer sender = session.createProducer(replyQueue);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the sender.");
                        }
                        if ((out = (ByteArrayOutputStream)msgContext.getProperty("TRANSPORT_OUT")) != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "MessageContext.TRANSPORT_OUT was set.");
                            }
                        } else {
                            out = new ByteArrayOutputStream();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Created new BAOS.");
                            }
                        }
                        Message jmsReplyMsg = null;
                        String contentType = null;
                        if (isTextMessage) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Creating a JMS TextMessage.");
                            }
                            jmsReplyMsg = session.createTextMessage();
                            contentType = JMSUtils.writeMessage(out, msgContext, true);
                            out.flush();
                            jmsReplyMsg.setText(out.toString());
                        } else {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Creating a JMS BytesMessage.");
                            }
                            jmsReplyMsg = session.createBytesMessage();
                            contentType = JMSUtils.writeMessage(out, msgContext, false);
                            out.flush();
                            ((BytesMessage)jmsReplyMsg).writeBytes(out.toByteArray());
                        }
                        boolean specProtocol = false;
                        String version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion");
                        if (version != null && version.length() > 0) {
                            if (version.compareTo("1.0") != 0) {
                                Object[] inserts = new Object[]{"1.0"};
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsunrecognizedBindingVersion", inserts, "The version {0} should be 1.0");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            specProtocol = true;
                        }
                        if (specProtocol) {
                            jmsReplyMsg.setStringProperty("SOAPJMS_contentType", contentType);
                            jmsReplyMsg.setStringProperty("SOAPJMS_bindingVersion", "1.0");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set SOAPJMS_contentType to : " + contentType + ", and " + "SOAPJMS_bindingVersion" + " to : " + "1.0" + " on the JMS reply message");
                            }
                        } else {
                            jmsReplyMsg.setStringProperty("contentType", contentType);
                            jmsReplyMsg.setStringProperty("transportVersion", "1");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set contentType to : " + contentType + ", and " + "transportVersion" + " to : " + "1" + " on the JMS reply message");
                            }
                        }
                        HashMap responseTransportHeaders = null;
                        responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                        if (responseTransportHeaders != null) {
                            this.setResponseHandlerTransportProperties(jmsReplyMsg, responseTransportHeaders);
                        }
                        jmsReplyMsg.setJMSCorrelationID(jmsMessage.getJMSMessageID());
                        long replyTTL = jmsMessage.getJMSExpiration() - jmsMessage.getJMSTimestamp();
                        if (replyTTL < 0L) {
                            replyTTL = 0L;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to send JMS response message: " + jmsReplyMsg.toString());
                            Tr.debug(_tc, "Message send options:\ndeliveryMode=" + jmsMessage.getJMSDeliveryMode() + ", priority=" + jmsMessage.getJMSPriority() + ", timeToLive=" + replyTTL);
                        }
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, contentType, out.toByteArray());
                        }
                        sender.send(jmsReplyMsg, jmsMessage.getJMSDeliveryMode(), jmsMessage.getJMSPriority(), replyTTL);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sent the response message.");
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.onMessage", "720", this);
                        Object[] inserts = new Object[]{e.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsUnexpected", inserts, "Unexpected exception caught while sending reply message {0} ");
                        Tr.error(_tc, msg);
                        throw new AxisFault(msg);
                    }
                    Object var18_25 = null;
                }
                catch (Throwable throwable) {
                    Object var18_26 = null;
                    connection.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closed the connection.");
                    }
                    throw throwable;
                }
                connection.close();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closed the connection.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.onMessage", "737", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsUnexpected", inserts, "Unexpected exception caught while sending reply message {0} ");
                Tr.error(_tc, msg);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendUsingOutputStream");
        }
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ConnectionFactory getReplyQCF(MessageContext mc) throws Exception {
        ConnectionFactory replyQCF = null;
        try {
            block7: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "getReplyQCF");
                    }
                    if (replyQCF != null) break block7;
                    InitialContext ic2 = this.getInitialContext();
                    String jndiName = (String)mc.getProperty(MC_PRP_REPLYQCF);
                    if (jndiName == null) {
                        jndiName = "java:comp/env/jms/WebServicesReplyQCF";
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Looking up reply QCF: " + jndiName);
                    }
                    replyQCF = (ConnectionFactory)ic2.lookup(jndiName);
                    if (!_tc.isDebugEnabled()) break block7;
                    Tr.debug(_tc, "Found the QCF!");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.getReplyQCF", "165", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to locate my reply QCF, exception = " + e.toString());
                    throw e;
                }
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return replyQCF;
            Tr.exit(_tc, "getReplyQCF");
            return replyQCF;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getReplyQCF");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        InitialContext initialContext = null;
        try {
            block5: {
                try {
                    if (initialContext != null) break block5;
                    initialContext = new InitialContext();
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.getInitialContext", "114", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to create initial context!");
                    throw e;
                }
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return initialContext;
            Tr.exit(_tc, "getInitialContext");
            return initialContext;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getInitialContext");
            throw throwable;
        }
    }

    private void setResponseHandlerTransportProperties(Message jmsMessage, HashMap responseTransportHeaders) throws AxisFault {
        try {
            if (responseTransportHeaders != null) {
                for (Map.Entry headerMapEntry : responseTransportHeaders.entrySet()) {
                    if (headerMapEntry.getKey() == null || !(headerMapEntry.getKey() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                    if (!JavaUtils.hasValue(transportHeaderKey)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    if (headerMapEntry.getValue() == null || !(headerMapEntry.getValue() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{headerMapEntry.getValue()});
                        continue;
                    }
                    String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                    if (!JavaUtils.hasValue(transportHeaderValue)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{transportHeaderValue});
                        continue;
                    }
                    if (jmsMessage.propertyExists(transportHeaderKey)) continue;
                    jmsMessage.setStringProperty(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.setResponseHandlerTransportProperties", "902", this);
            StringBuffer exceptionInfo = new StringBuffer();
            Object[] inserts = new Object[]{je.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            exceptionInfo.append(msg);
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                Object[] inserts1 = new Object[]{e.toString()};
                String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                exceptionInfo.append(msg1);
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new AxisFault("JMS ", exceptionInfo.toString());
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }
}

