/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.exception.EndpointException;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.exception.ConfigurationException;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.jms.JMSOutTransportInfo;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.security.context.ContextManager;
import com.ibm.wsspi.webservices.management.EndpointManagerMBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.util.MessageContextBuilder;

public class JMSProcessMessage
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register(JMSProcessMessage.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    protected transient ConfigurationContext configContext = null;
    private String targetService = null;
    private String contentType = null;
    private String soapAction = null;
    private JMSOutTransportInfo jmsOutTransportInfo = null;
    private static final int VERSION_SOAP11 = 1;

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.fMessageDrivenCtx = ctx;
    }

    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSProcessMessage");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "JMSProcessMessage");
        }
    }

    public void setConfigContext(ConfigurationContext ctxt) {
        this.configContext = ctxt;
    }

    private MessageContext createMessageContext(Message jmsMessage, ByteArrayOutputStream out) throws AxisFault, WSSecurityException {
        ByteArrayOutputStream responseOstrm = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createMessageContext");
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            MessageContext msgContext = new MessageContext();
            msgContext.setConfigurationContext(this.configContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "configContext : " + this.configContext.toString());
            }
            msgContext.setIncomingTransportName("jms");
            AxisConfiguration axisConfiguration = this.configContext.getAxisConfiguration();
            if (axisConfiguration != null) {
                msgContext.setTransportIn(axisConfiguration.getTransportIn("jms"));
                msgContext.setTransportOut(axisConfiguration.getTransportOut("jms"));
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "TransportIn and TransportOut are set");
                }
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "axisConfiguration is null");
                }
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsNoAxisConfiguration", new Object[0], "Fault creating MessageContext. AxisConfiguration is NULL.");
                throw new AxisFault(msg);
            }
            msgContext.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "charset encoding : UTF-8");
            }
            this.jmsOutTransportInfo = new JMSOutTransportInfo();
            msgContext.setProperty("OutTransportInfo", this.jmsOutTransportInfo);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "OutTransportInfo is set");
            }
            this.handleSoapAction(jmsMessage, msgContext, this.soapAction);
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                msgContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", ContextManager.getContext());
            }
            msgContext.setProperty("com.ibm.ws.websvcs.INCOMING_SERVER_SIDE_REQUEST", new Boolean(true));
            this.contentType = this.contentType == null ? null : this.contentType.trim();
            msgContext.setProperty("ContentType", this.contentType);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting contentType : " + this.contentType + " in MessageContext");
            }
            responseOstrm = new ByteArrayOutputStream();
            msgContext.setProperty("TRANSPORT_OUT", responseOstrm);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "MessageContext TRANSPORT_OUT is set.");
            }
            msgContext.setServerSide(true);
            msgContext.setEnvelope(TransportUtils.createSOAPMessage(msgContext, in, this.contentType));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "SOAP envelope is set");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "createMessageContext : " + msgContext);
            }
            return msgContext;
        }
        catch (AxisFault ae) {
            StringBuffer exceptionInfo = new StringBuffer("Axis fault creating the MessageContext : ");
            exceptionInfo.append(ae.toString());
            AxisFault e = AxisFault.makeFault(ae);
            throw new AxisFault("JMS ", e.toString());
        }
        catch (XMLStreamException xe) {
            StringBuffer exceptionInfo = new StringBuffer("Error reading the SOAP envelope: ");
            exceptionInfo.append(xe.toString());
            AxisFault e = AxisFault.makeFault(xe);
            throw new AxisFault("JMS ", e.toString());
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, this.getClass().getName(), "237", this);
            StringBuffer exceptionInfo = new StringBuffer();
            Object[] inserts = new Object[]{je.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            exceptionInfo.append(msg);
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                Object[] inserts1 = new Object[]{e.toString()};
                String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                exceptionInfo.append(msg1);
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new AxisFault("JMS ", exceptionInfo.toString());
        }
    }

    private void extractIBMProperties(Message jmsMessage) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractIBMProperties");
        }
        this.targetService = jmsMessage.getStringProperty("targetService");
        if (this.targetService == null || this.targetService.length() == 0) {
            Object[] inserts = new Object[]{"targetService"};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsnoTargetService", inserts, "Target service is not available");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve targetService property from JMS message: " + (this.targetService == null ? "<null>" : this.targetService));
        }
        this.contentType = jmsMessage.getStringProperty("contentType");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve contentType property from JMS message: " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve soapAction property from JMS message: " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractIBMProperties");
        }
    }

    private void extractSPECProperties(Message jmsMessage, Queue replyQueue) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "extractSPECProperties");
        }
        this.targetService = jmsMessage.getStringProperty("SOAPJMS_targetService");
        if (this.targetService == null || this.targetService.length() == 0) {
            Object[] inserts = new Object[]{"SOAPJMS_targetService"};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsnoTargetService", inserts, "The JMSSender did not set {0} on the JMS request message prior to sending the message to the destination queue or topic");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve SOAPJMS_targetService property from JMS message : " + (this.targetService == null ? "<null>" : this.targetService));
        }
        this.contentType = jmsMessage.getStringProperty("SOAPJMS_contentType");
        if (this.contentType == null || this.contentType.length() == 0) {
            Object[] inserts = new Object[]{"SOAPJMS_contentType"};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsmissingContentType", inserts, "The JMSSender did not set {0} on the JMS request message prior to sending the message to the destination queue or topic");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve SOAPJMS_contentType property from JMS message : " + (this.contentType == null ? "<null>" : this.contentType));
        }
        this.soapAction = jmsMessage.getStringProperty("SOAPJMS_soapAction");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieve SOAPJMS_soapAction property from JMS message : " + (this.soapAction == null ? "<null>" : this.soapAction));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "extractSPECProperties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onMessage(Message jmsMessage) {
        block55: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "onMessage");
            }
            MessageContext msgContext = null;
            Queue replyQueue = null;
            String requestMessageId = null;
            boolean specProtocol = false;
            ByteArrayOutputStream ostrm = null;
            boolean suspendResumeTran = true;
            TransactionSuspender tranSuspender = null;
            if (MessageTrace.isTraceEnabled()) {
                Tr.debug(_tc, "Received JMS request message: " + jmsMessage.toString());
            }
            try {
                String enableTransaction = jmsMessage.getStringProperty("enableTransaction");
                suspendResumeTran = JavaUtils.isFalse(enableTransaction);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "suspendResumeTran = " + suspendResumeTran);
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName(), "412", this);
                Object[] inserts = new Object[]{t.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsFault01", inserts, "The following Exception {0} occured while constructing MessageContext");
                Tr.error(_tc, msg);
                throw new EJBException(t.toString());
            }
            if (suspendResumeTran) {
                tranSuspender = new TransactionSuspender();
            }
            try {
                block52: {
                    try {
                        String version;
                        if (suspendResumeTran) {
                            tranSuspender.suspendTransaction();
                        }
                        if ((version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion")) != null && version.length() != 0) {
                            if (version.compareTo("1.0") != 0) {
                                Object[] inserts = new Object[]{"1.0"};
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsunrecognizedBindingVersion", inserts, "The version {0} should be 1.0");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            specProtocol = true;
                        }
                        requestMessageId = jmsMessage.getJMSMessageID();
                        replyQueue = (Queue)jmsMessage.getJMSReplyTo();
                        if (specProtocol) {
                            this.extractSPECProperties(jmsMessage, replyQueue);
                        } else {
                            this.extractIBMProperties(jmsMessage);
                        }
                        if (jmsMessage instanceof BytesMessage) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got BytesMessage, contentType=" + this.contentType);
                            }
                            BytesMessage bmsg = (BytesMessage)jmsMessage;
                            ostrm = new ByteArrayOutputStream();
                            byte[] chunk = new byte[4096];
                            int numBytes = 1;
                            while (numBytes > 0) {
                                numBytes = bmsg.readBytes(chunk);
                                if (numBytes <= 0) continue;
                                ostrm.write(chunk, 0, numBytes);
                            }
                            ostrm.flush();
                        } else {
                            if (!(jmsMessage instanceof TextMessage)) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidReplyMsgType", new Object[0], "The reply message has invalid type of message type.");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Got TextMessage, contentType=" + this.contentType);
                            }
                            String strMessage = ((TextMessage)jmsMessage).getText();
                            ostrm = new ByteArrayOutputStream();
                            ostrm.write(strMessage.getBytes());
                            ostrm.flush();
                        }
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.INBOUND_JMS_REQUEST, this.contentType, ostrm.toByteArray());
                        }
                        if (ostrm == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                            throw new AxisFault(msg);
                        }
                        msgContext = this.createMessageContext(jmsMessage, ostrm);
                        EndpointManagerMBean mbean = Axis2Utils.getEndpointManagerMBean(this.configContext);
                        if (mbean == null) {
                            Object[] inserts = new Object[]{Axis2Utils.getApplicationName(this.configContext.getAxisConfiguration()), Axis2Utils.getModuleName(this.configContext.getAxisConfiguration())};
                            String msg = NLSProvider.getNLS().getFormattedMessage("mbeanNotFound00", inserts, "Could not find the Endpoint Manager MBean for the application {0}, module {1}.");
                            Tr.error(_tc, "mbeanNotFound00", inserts);
                            throw new ConfigurationException(msg);
                        }
                        Endpoint endpoint = mbean.getEndpointListenerWithPortComponentName(this.targetService);
                        if (endpoint == null) {
                            Object[] inserts = new Object[]{this.targetService};
                            String msg = NLSProvider.getNLS().getFormattedMessage("endpointNotFound00", inserts, "Could not locate the endpoint for {0}.");
                            Tr.error(_tc, "endpointNotFound00", inserts);
                            throw new EndpointException(msg);
                        }
                        if (endpoint.getState() == 3) {
                            Object[] inserts = new Object[]{this.targetService};
                            String msg = NLSProvider.getNLS().getFormattedMessage("endpointStopped00", inserts, "The endpoint is currently stopped for {0}.");
                            Tr.error(_tc, "endpointStopped00", inserts);
                            throw new EndpointException(msg);
                        }
                        msgContext.setProperty("targetService", this.targetService);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Set targetService property on message context to: " + this.targetService);
                        }
                        msgContext.setProperty("transport.jms.requestMessage", jmsMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "MessageContext : " + msgContext + " setting id : " + requestMessageId);
                        }
                        msgContext.setProperty("asyncCorrelationID", requestMessageId);
                        if (replyQueue != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "msgContext : " + msgContext);
                            }
                            msgContext.setProperty("JMSMESSAGE", jmsMessage);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Calling AxisEngine.receive()...");
                        }
                        AxisEngine.receive(msgContext);
                        if (!_tc.isDebugEnabled()) break block52;
                        Tr.debug(_tc, "Returned from AxisEngine.receive()");
                    }
                    catch (Exception ex) {
                        block54: {
                            boolean userException;
                            AxisFault e;
                            block56: {
                                e = AxisFault.makeFault(ex);
                                userException = false;
                                if (msgContext != null) {
                                    block53: {
                                        OperationContext opContext = msgContext.getOperationContext();
                                        if (opContext != null) {
                                            try {
                                                MessageContext msgCtx = opContext.getMessageContext("Out");
                                                if (msgCtx == null || msgCtx.getProperty("org.apache.axis2.jaxws.checkedException") == null) break block53;
                                                userException = true;
                                                if (_tc.isDebugEnabled()) {
                                                    Tr.debug(_tc, "USER_EXCEPTION is set. Not throwing the exception.");
                                                }
                                            }
                                            catch (AxisFault ex1) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (!userException) {
                                        FFDCFilter.processException((Throwable)e, this.getClass().getName(), "622", this);
                                        Object[] inserts = new Object[]{e.toString()};
                                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsError03", inserts, "The specified exception occurred while a request was being processed {0} ");
                                        Tr.error(_tc, msg);
                                    }
                                }
                                if (replyQueue == null) break block56;
                                if (e != null) {
                                    try {
                                        if (msgContext == null) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "msgContext is null... creating one");
                                            }
                                            msgContext = this.createMessageContext(jmsMessage, ostrm);
                                        }
                                        if (msgContext.getEnvelope() == null && JMSUtils.getSoapVersion(msgContext, this.contentType) != 1) {
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "Setting envelope...");
                                            }
                                            msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
                                        }
                                        MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
                                        faultContext.setProperty("JMSMESSAGE", jmsMessage);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "faultMessageContext : " + faultContext + " setting " + "asyncCorrelationID" + " : " + requestMessageId);
                                        }
                                        faultContext.setProperty("asyncCorrelationID", requestMessageId);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Calling AxisEngine.sendFault()...");
                                        }
                                        AxisEngine.sendFault(faultContext);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Returned from AxisEngine.fault()");
                                        }
                                        break block54;
                                    }
                                    catch (Exception ex1) {}
                                }
                                break block54;
                            }
                            if (!userException) {
                                throw new RuntimeException(e.getMessage());
                            }
                        }
                        Object var16_32 = null;
                        if (suspendResumeTran) {
                            tranSuspender.resumeTransaction();
                        }
                        break block55;
                    }
                }
                Object var16_31 = null;
                if (suspendResumeTran) {
                    tranSuspender.resumeTransaction();
                }
            }
            catch (Throwable throwable) {
                Object var16_33 = null;
                if (suspendResumeTran) {
                    tranSuspender.resumeTransaction();
                }
                throw throwable;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "onMessage");
        }
    }

    private void handleSoapAction(Message jmsMessage, MessageContext msgContext, String soapAction) throws JMSException {
        if (soapAction == null || soapAction.length() == 0) {
            msgContext.setSoapAction(null);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Disabling soapAction on MessageContext...");
            }
        } else {
            if (soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
                soapAction = soapAction.substring(1, soapAction.length() - 1);
            }
            msgContext.setSoapAction(soapAction);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting soapAction on MessageContext to: " + soapAction);
            }
        }
    }

    public void ejbRemove() {
    }
}

