/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.jms.JMSProcessMessage;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class JMSListenerMDB
implements MessageDrivenBean,
MessageListener {
    private static final TraceComponent _tc = Tr.register(JMSListenerMDB.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private MessageDrivenContext fMessageDrivenCtx = null;
    protected ConfigurationContext configContext = null;
    private List jaxwsPortComponents = null;
    private com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB jaxrpcListenerMDB = null;
    private JMSProcessMessage jaxwsProcessMessage = null;

    public MessageDrivenContext getMessageDrivenContext() {
        return this.fMessageDrivenCtx;
    }

    private com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB getJaxrpcMDB() {
        if (this.jaxrpcListenerMDB == null) {
            this.jaxrpcListenerMDB = new com.ibm.ws.webservices.engine.transport.jms.JMSListenerMDB();
            this.jaxrpcListenerMDB.ejbCreate();
        }
        return this.jaxrpcListenerMDB;
    }

    public void setMessageDrivenContext(MessageDrivenContext ctx) {
        this.fMessageDrivenCtx = ctx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ejbCreate() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Common JMSListenerMDB.ejbCreate()");
        }
        try {
            try {
                this.getConfigContext();
                this.jaxwsProcessMessage = new JMSProcessMessage();
                this.jaxwsProcessMessage.ejbCreate();
            }
            catch (Exception fault) {
                FFDCFilter.processException((Throwable)fault, "com.ibm.ws.websvcs.transport.jms.JMSListenerMDB.ejbCreate", "126", this);
                Object[] inserts = new Object[]{fault.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                Tr.error(_tc, msg);
                throw new EJBException(msg);
            }
            Object var5_1 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var5_2 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "Common JMSListenerMDB.ejbCreate()");
            throw throwable;
        }
        Tr.exit(_tc, "Common JMSListenerMDB.ejbCreate()");
    }

    public void getConfigContext() throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Common JMSListenerMDB.getConfigContext()");
        }
        try {
            WASAxis2Service service = null;
            try {
                service = (WASAxis2Service)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return WsServiceRegistry.getService(this, WASAxis2Service.class);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WASAxis2Service= " + service.toString());
            }
            if (service != null) {
                ServerModuleMetaData smmd = (ServerModuleMetaData)service.getModuleMetaData();
                if (smmd != null) {
                    this.configContext = smmd.getConfigurationContext();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "configContext= " + this.configContext.toString());
                    }
                    this.getPortComponentNames();
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "SMMD is null.");
                }
            }
        }
        catch (Exception e2) {
            FFDCFilter.processException((Throwable)e2, "com.ibm.ws.websvcs.transport.jms.JMSListenerMDB.getConfigContext", "157", this);
            Object[] inserts = new Object[]{e2.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            Tr.error(_tc, msg);
            AxisFault e2 = AxisFault.makeFault(e2);
            throw e2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Common JMSListenerMDB.getConfigContext()");
        }
    }

    public List getPortComponentNames() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Common JMSListenerMDB.getPortComponentNames()");
        }
        if (this.configContext != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ConfigurationContext : " + this.configContext.toString());
            }
            this.jaxwsPortComponents = new ArrayList();
            AxisConfiguration axisCfg = this.configContext.getAxisConfiguration();
            Iterator svcGrpIter = axisCfg.getServiceGroups();
            if (_tc.isDebugEnabled() && !svcGrpIter.hasNext()) {
                Tr.debug(_tc, "No ServiceGroups");
            }
            while (svcGrpIter.hasNext()) {
                AxisServiceGroup svcGrp = (AxisServiceGroup)svcGrpIter.next();
                Iterator svcIter = svcGrp.getServices();
                if (_tc.isDebugEnabled() && !svcIter.hasNext()) {
                    Tr.debug(_tc, "No AxisService");
                }
                while (svcIter.hasNext()) {
                    AxisService svc = (AxisService)svcIter.next();
                    String portCompName = Axis2Utils.getPortComponentName(svc);
                    if (portCompName == null) continue;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding Port Component : " + portCompName);
                    }
                    this.jaxwsPortComponents.add(portCompName);
                }
                if (!_tc.isDebugEnabled() || this.jaxwsPortComponents.isEmpty()) continue;
                Tr.debug(_tc, "jaxwsPortComponents : " + this.jaxwsPortComponents.toString());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ConfigurationContext is NULL");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Common JMSListenerMDB.getPortComponentNames()");
        }
        return this.jaxwsPortComponents;
    }

    public void onMessage(Message jmsMessage) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Common JMSListenerMDB.onMessage()");
        }
        boolean specProtocol = false;
        String targetService = null;
        try {
            String version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion");
            if (version != null && version.length() != 0) {
                if (version.compareTo("1.0") != 0) {
                    Object[] inserts = new Object[]{"1.0"};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsunrecognizedBindingVersion", inserts, "The version {0} should be 1.0");
                    Tr.error(_tc, msg);
                    throw new AxisFault(msg);
                }
                specProtocol = true;
            }
            if ((targetService = specProtocol ? jmsMessage.getStringProperty("SOAPJMS_targetService") : jmsMessage.getStringProperty("targetService")) == null || targetService.length() == 0) {
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsNoTargetService", new Object[0], "TargetService is NULL.");
                Tr.error(_tc, msg);
                throw new AxisFault(msg);
            }
        }
        catch (Exception ex) {
            AxisFault e = AxisFault.makeFault(ex);
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSListenerMDB.onMessage", "256", this);
            Object[] inserts = new Object[]{e.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            Tr.error(_tc, msg);
        }
        if (this.jaxwsPortComponents != null && this.jaxwsPortComponents.contains(targetService)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service : " + targetService + " is JAX-WS");
            }
            this.jaxwsProcessMessage.setConfigContext(this.configContext);
            try {
                this.jaxwsProcessMessage.onMessage(jmsMessage);
            }
            catch (Exception e2) {
                AxisFault e2 = AxisFault.makeFault(e2);
                FFDCFilter.processException((Throwable)e2, "com.ibm.ws.websvcs.transport.jms.JMSListenerMDB.onMessage", "304", this);
                Object[] inserts = new Object[]{e2.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                Tr.error(_tc, msg);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Service : " + targetService + " is JAX-RPC");
            }
            this.getJaxrpcMDB().onMessage(jmsMessage);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Common JMSListenerMDB.onMessage()");
        }
    }

    public void ejbRemove() {
    }
}

